/*
 * generated by Xtext 2.9.2
 */
package org.xtext.example.mydsl.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.xtext.example.mydsl.einDsl.Aggregation;
import org.xtext.example.mydsl.einDsl.ChartType;
import org.xtext.example.mydsl.einDsl.Condtition;
import org.xtext.example.mydsl.einDsl.Date;
import org.xtext.example.mydsl.einDsl.DayTimeGroup;
import org.xtext.example.mydsl.einDsl.DimensionValue;
import org.xtext.example.mydsl.einDsl.EinDslPackage;
import org.xtext.example.mydsl.einDsl.Group;
import org.xtext.example.mydsl.einDsl.GroupList;
import org.xtext.example.mydsl.einDsl.LastNTimeGroup;
import org.xtext.example.mydsl.einDsl.LastTimeGroup;
import org.xtext.example.mydsl.einDsl.MeasureList;
import org.xtext.example.mydsl.einDsl.Model;
import org.xtext.example.mydsl.einDsl.QTypekeyWord;
import org.xtext.example.mydsl.einDsl.Query;
import org.xtext.example.mydsl.einDsl.ThisTimeGroup;
import org.xtext.example.mydsl.einDsl.TimeGroup;
import org.xtext.example.mydsl.einDsl.Transition;
import org.xtext.example.mydsl.services.EinDslGrammarAccess;

@SuppressWarnings("all")
public class EinDslSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private EinDslGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == EinDslPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case EinDslPackage.AGGREGATION:
				sequence_Aggregation(context, (Aggregation) semanticObject); 
				return; 
			case EinDslPackage.CHART_TYPE:
				sequence_ChartType(context, (ChartType) semanticObject); 
				return; 
			case EinDslPackage.CONDTITION:
				sequence_Condtition(context, (Condtition) semanticObject); 
				return; 
			case EinDslPackage.DATE:
				sequence_Date(context, (Date) semanticObject); 
				return; 
			case EinDslPackage.DAY_TIME_GROUP:
				sequence_DayTimeGroup(context, (DayTimeGroup) semanticObject); 
				return; 
			case EinDslPackage.DIMENSION_VALUE:
				sequence_DimensionValue(context, (DimensionValue) semanticObject); 
				return; 
			case EinDslPackage.GROUP:
				sequence_Group(context, (Group) semanticObject); 
				return; 
			case EinDslPackage.GROUP_LIST:
				sequence_GroupList(context, (GroupList) semanticObject); 
				return; 
			case EinDslPackage.LAST_NTIME_GROUP:
				sequence_LastNTimeGroup(context, (LastNTimeGroup) semanticObject); 
				return; 
			case EinDslPackage.LAST_TIME_GROUP:
				sequence_LastTimeGroup(context, (LastTimeGroup) semanticObject); 
				return; 
			case EinDslPackage.MEASURE_LIST:
				sequence_MeasureList(context, (MeasureList) semanticObject); 
				return; 
			case EinDslPackage.MODEL:
				sequence_Model(context, (Model) semanticObject); 
				return; 
			case EinDslPackage.QTYPEKEY_WORD:
				sequence_QTypekeyWord(context, (QTypekeyWord) semanticObject); 
				return; 
			case EinDslPackage.QUERY:
				sequence_Query(context, (Query) semanticObject); 
				return; 
			case EinDslPackage.THIS_TIME_GROUP:
				sequence_ThisTimeGroup(context, (ThisTimeGroup) semanticObject); 
				return; 
			case EinDslPackage.TIME_GROUP:
				sequence_TimeGroup(context, (TimeGroup) semanticObject); 
				return; 
			case EinDslPackage.TRANSITION:
				sequence_Transition(context, (Transition) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Aggregation returns Aggregation
	 *
	 * Constraint:
	 *     (agg='average' | agg='number of' | agg='total')
	 */
	protected void sequence_Aggregation(ISerializationContext context, Aggregation semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ChartType returns ChartType
	 *
	 * Constraint:
	 *     chartType='as'
	 */
	protected void sequence_ChartType(ISerializationContext context, ChartType semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.CHART_TYPE__CHART_TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.CHART_TYPE__CHART_TYPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getChartTypeAccess().getChartTypeAsKeyword_0_0(), semanticObject.getChartType());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Condtition returns Condtition
	 *
	 * Constraint:
	 *     (
	 *         (con+='for' dimValue=DimensionValue dimen=Dimension) | 
	 *         (conTimeCurrent='for' thisTimeGroup=ThisTimeGroup) | 
	 *         (conlastTimePast='for' lastTimeGroup=LastTimeGroup) | 
	 *         (conlastNTimePast='for' lastNTimeGroup=LastNTimeGroup) | 
	 *         (conDayTimeGroup='for' dayTimeGroup=DayTimeGroup)
	 *     )
	 */
	protected void sequence_Condtition(ISerializationContext context, Condtition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Date returns Date
	 *
	 * Constraint:
	 *     (d=Day m=Month y=Year)
	 */
	protected void sequence_Date(ISerializationContext context, Date semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.DATE__D) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.DATE__D));
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.DATE__M) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.DATE__M));
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.DATE__Y) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.DATE__Y));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDateAccess().getDDayParserRuleCall_0_0(), semanticObject.getD());
		feeder.accept(grammarAccess.getDateAccess().getMMonthParserRuleCall_1_0(), semanticObject.getM());
		feeder.accept(grammarAccess.getDateAccess().getYYearParserRuleCall_2_0(), semanticObject.getY());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     DayTimeGroup returns DayTimeGroup
	 *
	 * Constraint:
	 *     (dayTimeGroup='today' | dayTimeGroup='yesterday')
	 */
	protected void sequence_DayTimeGroup(ISerializationContext context, DayTimeGroup semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     DimensionValue returns DimensionValue
	 *
	 * Constraint:
	 *     value=EinString+
	 */
	protected void sequence_DimensionValue(ISerializationContext context, DimensionValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     GroupList returns GroupList
	 *
	 * Constraint:
	 *     ((dimGroup=Dimension timeGroup+=TimeGroup?) | timeGroup+=TimeGroup)
	 */
	protected void sequence_GroupList(ISerializationContext context, GroupList semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Group returns Group
	 *
	 * Constraint:
	 *     ((dimGroup=Dimension timeGroup+=TimeGroup?) | timeGroup+=TimeGroup)
	 */
	protected void sequence_Group(ISerializationContext context, Group semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     LastNTimeGroup returns LastNTimeGroup
	 *
	 * Constraint:
	 *     lastTimeGroup='last'
	 */
	protected void sequence_LastNTimeGroup(ISerializationContext context, LastNTimeGroup semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.LAST_NTIME_GROUP__LAST_TIME_GROUP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.LAST_NTIME_GROUP__LAST_TIME_GROUP));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getLastNTimeGroupAccess().getLastTimeGroupLastKeyword_0_0(), semanticObject.getLastTimeGroup());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     LastTimeGroup returns LastTimeGroup
	 *
	 * Constraint:
	 *     lastTimeGroup='last'
	 */
	protected void sequence_LastTimeGroup(ISerializationContext context, LastTimeGroup semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.LAST_TIME_GROUP__LAST_TIME_GROUP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.LAST_TIME_GROUP__LAST_TIME_GROUP));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getLastTimeGroupAccess().getLastTimeGroupLastKeyword_0_0(), semanticObject.getLastTimeGroup());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     MeasureList returns MeasureList
	 *
	 * Constraint:
	 *     (names+=Measure names+=Measure*)
	 */
	protected void sequence_MeasureList(ISerializationContext context, MeasureList semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Model returns Model
	 *
	 * Constraint:
	 *     greetings=Query
	 */
	protected void sequence_Model(ISerializationContext context, Model semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.MODEL__GREETINGS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.MODEL__GREETINGS));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getModelAccess().getGreetingsQueryParserRuleCall_0(), semanticObject.getGreetings());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     QTypekeyWord returns QTypekeyWord
	 *
	 * Constraint:
	 *     qKeyword='plot'
	 */
	protected void sequence_QTypekeyWord(ISerializationContext context, QTypekeyWord semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.QTYPEKEY_WORD__QKEYWORD) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.QTYPEKEY_WORD__QKEYWORD));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getQTypekeyWordAccess().getQKeywordPlotKeyword_0(), semanticObject.getQKeyword());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Query returns Query
	 *
	 * Constraint:
	 *     (key=QTypekeyWord? aggregation=Aggregation? measure=MeasureList (groupBy+=Group | condition=Condtition | range=Transition)* chartType=ChartType?)
	 */
	protected void sequence_Query(ISerializationContext context, Query semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ThisTimeGroup returns ThisTimeGroup
	 *
	 * Constraint:
	 *     thisTimeGroup='this'
	 */
	protected void sequence_ThisTimeGroup(ISerializationContext context, ThisTimeGroup semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.THIS_TIME_GROUP__THIS_TIME_GROUP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.THIS_TIME_GROUP__THIS_TIME_GROUP));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getThisTimeGroupAccess().getThisTimeGroupThisKeyword_0_0_0(), semanticObject.getThisTimeGroup());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     TimeGroup returns TimeGroup
	 *
	 * Constraint:
	 *     (timeGroup='day' | timeGroup='week' | timeGroup='month' | timeGroup='quarter' | timeGroup='year')
	 */
	protected void sequence_TimeGroup(ISerializationContext context, TimeGroup semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Transition returns Transition
	 *
	 * Constraint:
	 *     (dateStart=Date dateEnd=Date)
	 */
	protected void sequence_Transition(ISerializationContext context, Transition semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.TRANSITION__DATE_START) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.TRANSITION__DATE_START));
			if (transientValues.isValueTransient(semanticObject, EinDslPackage.Literals.TRANSITION__DATE_END) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EinDslPackage.Literals.TRANSITION__DATE_END));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getTransitionAccess().getDateStartDateParserRuleCall_1_0(), semanticObject.getDateStart());
		feeder.accept(grammarAccess.getTransitionAccess().getDateEndDateParserRuleCall_3_0(), semanticObject.getDateEnd());
		feeder.finish();
	}
	
	
}
