/*
 * generated by Xtext 2.9.1
 */
package eposse.experiments.xtext.oblang.serializer;

import com.google.inject.Inject;
import eposse.experiments.xtext.oblang.services.OblangGrammarAccess;
import java.util.Set;
import oblang.Block;
import oblang.ClassDef;
import oblang.OblangPackage;
import oblang.OpCall;
import oblang.OpDef;
import oblang.Var;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class OblangSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private OblangGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == OblangPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case OblangPackage.BLOCK:
				sequence_Block(context, (Block) semanticObject); 
				return; 
			case OblangPackage.CLASS_DEF:
				sequence_ClassDef(context, (ClassDef) semanticObject); 
				return; 
			case OblangPackage.OP_CALL:
				sequence_OpCall(context, (OpCall) semanticObject); 
				return; 
			case OblangPackage.OP_DEF:
				sequence_OpDef(context, (OpDef) semanticObject); 
				return; 
			case OblangPackage.VAR:
				sequence_Var(context, (Var) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Block returns Block
	 *
	 * Constraint:
	 *     stmts+=Stmt*
	 */
	protected void sequence_Block(ISerializationContext context, Block semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ClassDef returns ClassDef
	 *
	 * Constraint:
	 *     (name=EString opdefs+=OpDef* classdefs+=ClassDef*)
	 */
	protected void sequence_ClassDef(ISerializationContext context, ClassDef semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Stmt returns OpCall
	 *     OpCall returns OpCall
	 *
	 * Constraint:
	 *     (subject=[Var|ID] op=[OpDef|ID])
	 */
	protected void sequence_OpCall(ISerializationContext context, OpCall semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OblangPackage.Literals.OP_CALL__SUBJECT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OblangPackage.Literals.OP_CALL__SUBJECT));
			if (transientValues.isValueTransient(semanticObject, OblangPackage.Literals.OP_CALL__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OblangPackage.Literals.OP_CALL__OP));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getOpCallAccess().getSubjectVarIDTerminalRuleCall_0_0_1(), semanticObject.getSubject());
		feeder.accept(grammarAccess.getOpCallAccess().getOpOpDefIDTerminalRuleCall_2_0_1(), semanticObject.getOp());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     OpDef returns OpDef
	 *
	 * Constraint:
	 *     (name=EString block=Block)
	 */
	protected void sequence_OpDef(ISerializationContext context, OpDef semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OblangPackage.Literals.NAMED_ELEMENT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OblangPackage.Literals.NAMED_ELEMENT__NAME));
			if (transientValues.isValueTransient(semanticObject, OblangPackage.Literals.OP_DEF__BLOCK) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OblangPackage.Literals.OP_DEF__BLOCK));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getOpDefAccess().getNameEStringParserRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getOpDefAccess().getBlockBlockParserRuleCall_2_0(), semanticObject.getBlock());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Stmt returns Var
	 *     Var returns Var
	 *
	 * Constraint:
	 *     (type=[ClassDef|QualifiedName] name=EString)
	 */
	protected void sequence_Var(ISerializationContext context, Var semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OblangPackage.Literals.VAR__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OblangPackage.Literals.VAR__TYPE));
			if (transientValues.isValueTransient(semanticObject, OblangPackage.Literals.NAMED_ELEMENT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OblangPackage.Literals.NAMED_ELEMENT__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVarAccess().getTypeClassDefQualifiedNameParserRuleCall_1_0_1(), semanticObject.getType());
		feeder.accept(grammarAccess.getVarAccess().getNameEStringParserRuleCall_2_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
}
