/**
 */
package oblang.util;

import oblang.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see oblang.OblangPackage
 * @generated
 */
public class OblangAdapterFactory extends AdapterFactoryImpl
{
    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static OblangPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public OblangAdapterFactory()
    {
        if (modelPackage == null)
        {
            modelPackage = OblangPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object object)
    {
        if (object == modelPackage)
        {
            return true;
        }
        if (object instanceof EObject)
        {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch that delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected OblangSwitch<Adapter> modelSwitch =
        new OblangSwitch<Adapter>()
        {
            @Override
            public Adapter caseClassDef(ClassDef object)
            {
                return createClassDefAdapter();
            }
            @Override
            public Adapter caseOpDef(OpDef object)
            {
                return createOpDefAdapter();
            }
            @Override
            public Adapter caseStmt(Stmt object)
            {
                return createStmtAdapter();
            }
            @Override
            public Adapter caseNamedElement(NamedElement object)
            {
                return createNamedElementAdapter();
            }
            @Override
            public Adapter caseVar(Var object)
            {
                return createVarAdapter();
            }
            @Override
            public Adapter caseBlock(Block object)
            {
                return createBlockAdapter();
            }
            @Override
            public Adapter caseOpCall(OpCall object)
            {
                return createOpCallAdapter();
            }
            @Override
            public Adapter caseUMLClass(UMLClass object)
            {
                return createUMLClassAdapter();
            }
            @Override
            public Adapter defaultCase(EObject object)
            {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    @Override
    public Adapter createAdapter(Notifier target)
    {
        return modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link oblang.ClassDef <em>Class Def</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see oblang.ClassDef
     * @generated
     */
    public Adapter createClassDefAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link oblang.OpDef <em>Op Def</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see oblang.OpDef
     * @generated
     */
    public Adapter createOpDefAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link oblang.Stmt <em>Stmt</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see oblang.Stmt
     * @generated
     */
    public Adapter createStmtAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link oblang.NamedElement <em>Named Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see oblang.NamedElement
     * @generated
     */
    public Adapter createNamedElementAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link oblang.Var <em>Var</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see oblang.Var
     * @generated
     */
    public Adapter createVarAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link oblang.Block <em>Block</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see oblang.Block
     * @generated
     */
    public Adapter createBlockAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link oblang.OpCall <em>Op Call</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see oblang.OpCall
     * @generated
     */
    public Adapter createOpCallAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link oblang.UMLClass <em>UML Class</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see oblang.UMLClass
     * @generated
     */
    public Adapter createUMLClassAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter()
    {
        return null;
    }

} //OblangAdapterFactory
