package org.eclipse.datatools.play.popup.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.ResourceUtil;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PlayWithDDLViaAPIAction implements IObjectActionDelegate {

	private ISelection mStashedSelection = null;
	
	/**
	 * Constructor for Action1.
	 */
	public PlayWithDDLViaAPIAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		if (mStashedSelection != null && !mStashedSelection.isEmpty()) {
			if (mStashedSelection instanceof IStructuredSelection) {
				IStructuredSelection ssel = (IStructuredSelection) mStashedSelection;
				if (ssel.getFirstElement() instanceof IConnectionProfile) {
					IConnectionProfile icp = (IConnectionProfile) ssel.getFirstElement();
					try {
						cacheDatabase(icp);
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		mStashedSelection = selection;
	}

	public Database getDatabaseForProfile (IConnectionProfile profile) {
        IManagedConnection managedConnection = ((IConnectionProfile)profile).getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");//java.sql.Connection"); 
       if (managedConnection != null) 
       { 
    	   try {
	           ConnectionInfo connectionInfo = (ConnectionInfo) managedConnection.getConnection().getRawConnection(); 
	           if (connectionInfo != null) { 
	                   return connectionInfo.getSharedDatabase();         
	           }
    	   } catch (Exception e) {
    		   e.printStackTrace();
    	   }
       } 
       return null;
	}
	
	public void cacheDatabase(IConnectionProfile profile) throws IOException {
		Database database = getDatabaseForProfile(profile);
		String fileName = "c:\\" + database.getName();
		if(fileName == null) throw new IllegalStateException();
	    initConnectionDirectory(fileName);
		OutputStream out = new FileOutputStream(new File(fileName + "//cache.xmi"));
		Resource r = new XMIResourceImpl();
		r.getContents().add(database);
		ResourceUtil.resolveDanglingReferences(r);
		Map options = new HashMap();
		options.put(XMIResource.OPTION_ENCODING, "UTF-8"); //$NON-NLS-1$
		r.save(out, options);
		r.getContents().clear();
	}

	private void initConnectionDirectory(String name) {
		File dir = new File(name);
		if(!dir.exists()) {
			dir.mkdirs();
		}	
	}

	/* I need to be able to generate DDL and execute them against DB connections, 
based on a data-model (tables & columns) that I will be reading from a 
file. At this stage I am not sure of the file format that I will use. 

Can someone point me to the relevant classes, preferably with some sample 
code to give me a head start.

Also, if there is a pre-existing format for the datamodel that is tightly 
integrated with the DTP project (e.g. EMF model) in which they can be 
saved, with a relevant UI tool for editing the data-model, that would also 
be fantastic

As an API user, I found it pretty tricky finding relevant documentation on 
the DTP APIs - I realise that most usage of DTP is done through other 
Eclipse projects, but I am a little stuck at the moment.	 */

}
