/**
 * <copyright>
 * </copyright>
 *
 * $Id: XpdlSwitch.java,v 1.1 2006/12/29 12:25:12 yyang Exp $
 */
package com.soyatec.xpdl.util;

import com.soyatec.xpdl.*;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see com.soyatec.xpdl.XpdlPackage
 * @generated
 */
public class XpdlSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static XpdlPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XpdlSwitch() {
		if (modelPackage == null) {
			modelPackage = XpdlPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case XpdlPackage.ACTIVITIES_TYPE: {
				ActivitiesType activitiesType = (ActivitiesType)theEObject;
				Object result = caseActivitiesType(activitiesType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.ACTIVITY_SETS_TYPE: {
				ActivitySetsType activitySetsType = (ActivitySetsType)theEObject;
				Object result = caseActivitySetsType(activitySetsType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.ACTIVITY_SET_TYPE: {
				ActivitySetType activitySetType = (ActivitySetType)theEObject;
				Object result = caseActivitySetType(activitySetType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.ACTIVITY_TYPE: {
				ActivityType activityType = (ActivityType)theEObject;
				Object result = caseActivityType(activityType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.ACTUAL_PARAMETERS_TYPE: {
				ActualParametersType actualParametersType = (ActualParametersType)theEObject;
				Object result = caseActualParametersType(actualParametersType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.APPLICATIONS_TYPE: {
				ApplicationsType applicationsType = (ApplicationsType)theEObject;
				Object result = caseApplicationsType(applicationsType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.APPLICATION_TYPE: {
				ApplicationType applicationType = (ApplicationType)theEObject;
				Object result = caseApplicationType(applicationType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.ARRAY_TYPE_TYPE: {
				ArrayTypeType arrayTypeType = (ArrayTypeType)theEObject;
				Object result = caseArrayTypeType(arrayTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.AUTOMATIC_TYPE: {
				AutomaticType automaticType = (AutomaticType)theEObject;
				Object result = caseAutomaticType(automaticType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.BASIC_TYPE_TYPE: {
				BasicTypeType basicTypeType = (BasicTypeType)theEObject;
				Object result = caseBasicTypeType(basicTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.BLOCK_ACTIVITY_TYPE: {
				BlockActivityType blockActivityType = (BlockActivityType)theEObject;
				Object result = caseBlockActivityType(blockActivityType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.CONDITION_TYPE: {
				ConditionType conditionType = (ConditionType)theEObject;
				Object result = caseConditionType(conditionType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.CONFORMANCE_CLASS_TYPE: {
				ConformanceClassType conformanceClassType = (ConformanceClassType)theEObject;
				Object result = caseConformanceClassType(conformanceClassType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.DATA_FIELDS_TYPE: {
				DataFieldsType dataFieldsType = (DataFieldsType)theEObject;
				Object result = caseDataFieldsType(dataFieldsType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.DATA_FIELD_TYPE: {
				DataFieldType dataFieldType = (DataFieldType)theEObject;
				Object result = caseDataFieldType(dataFieldType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.DATA_TYPE_TYPE: {
				DataTypeType dataTypeType = (DataTypeType)theEObject;
				Object result = caseDataTypeType(dataTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.DEADLINE_TYPE: {
				DeadlineType deadlineType = (DeadlineType)theEObject;
				Object result = caseDeadlineType(deadlineType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.DECLARED_TYPE_TYPE: {
				DeclaredTypeType declaredTypeType = (DeclaredTypeType)theEObject;
				Object result = caseDeclaredTypeType(declaredTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.DOCUMENT_ROOT: {
				DocumentRoot documentRoot = (DocumentRoot)theEObject;
				Object result = caseDocumentRoot(documentRoot);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.ENUMERATION_TYPE_TYPE: {
				EnumerationTypeType enumerationTypeType = (EnumerationTypeType)theEObject;
				Object result = caseEnumerationTypeType(enumerationTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.ENUMERATION_VALUE_TYPE: {
				EnumerationValueType enumerationValueType = (EnumerationValueType)theEObject;
				Object result = caseEnumerationValueType(enumerationValueType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.EXTENDED_ATTRIBUTES_TYPE: {
				ExtendedAttributesType extendedAttributesType = (ExtendedAttributesType)theEObject;
				Object result = caseExtendedAttributesType(extendedAttributesType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.EXTENDED_ATTRIBUTE_TYPE: {
				ExtendedAttributeType extendedAttributeType = (ExtendedAttributeType)theEObject;
				Object result = caseExtendedAttributeType(extendedAttributeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.EXTERNAL_PACKAGES_TYPE: {
				ExternalPackagesType externalPackagesType = (ExternalPackagesType)theEObject;
				Object result = caseExternalPackagesType(externalPackagesType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.EXTERNAL_PACKAGE_TYPE: {
				ExternalPackageType externalPackageType = (ExternalPackageType)theEObject;
				Object result = caseExternalPackageType(externalPackageType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.EXTERNAL_REFERENCE_TYPE: {
				ExternalReferenceType externalReferenceType = (ExternalReferenceType)theEObject;
				Object result = caseExternalReferenceType(externalReferenceType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.FINISH_MODE_TYPE: {
				FinishModeType finishModeType = (FinishModeType)theEObject;
				Object result = caseFinishModeType(finishModeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.FORMAL_PARAMETERS_TYPE: {
				FormalParametersType formalParametersType = (FormalParametersType)theEObject;
				Object result = caseFormalParametersType(formalParametersType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.FORMAL_PARAMETER_TYPE: {
				FormalParameterType formalParameterType = (FormalParameterType)theEObject;
				Object result = caseFormalParameterType(formalParameterType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.IMPLEMENTATION_TYPE: {
				ImplementationType implementationType = (ImplementationType)theEObject;
				Object result = caseImplementationType(implementationType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.JOIN_TYPE: {
				JoinType joinType = (JoinType)theEObject;
				Object result = caseJoinType(joinType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.LIST_TYPE_TYPE: {
				ListTypeType listTypeType = (ListTypeType)theEObject;
				Object result = caseListTypeType(listTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.MANUAL_TYPE: {
				ManualType manualType = (ManualType)theEObject;
				Object result = caseManualType(manualType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.MEMBER_TYPE: {
				MemberType memberType = (MemberType)theEObject;
				Object result = caseMemberType(memberType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.NO_TYPE: {
				NoType noType = (NoType)theEObject;
				Object result = caseNoType(noType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.PACKAGE_HEADER_TYPE: {
				PackageHeaderType packageHeaderType = (PackageHeaderType)theEObject;
				Object result = casePackageHeaderType(packageHeaderType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.PACKAGE_TYPE: {
				PackageType packageType = (PackageType)theEObject;
				Object result = casePackageType(packageType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.PARTICIPANTS_TYPE: {
				ParticipantsType participantsType = (ParticipantsType)theEObject;
				Object result = caseParticipantsType(participantsType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.PARTICIPANT_TYPE: {
				ParticipantType participantType = (ParticipantType)theEObject;
				Object result = caseParticipantType(participantType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.PARTICIPANT_TYPE_TYPE: {
				ParticipantTypeType participantTypeType = (ParticipantTypeType)theEObject;
				Object result = caseParticipantTypeType(participantTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.PROCESS_HEADER_TYPE: {
				ProcessHeaderType processHeaderType = (ProcessHeaderType)theEObject;
				Object result = caseProcessHeaderType(processHeaderType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.RECORD_TYPE_TYPE: {
				RecordTypeType recordTypeType = (RecordTypeType)theEObject;
				Object result = caseRecordTypeType(recordTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.REDEFINABLE_HEADER_TYPE: {
				RedefinableHeaderType redefinableHeaderType = (RedefinableHeaderType)theEObject;
				Object result = caseRedefinableHeaderType(redefinableHeaderType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.RESPONSIBLES_TYPE: {
				ResponsiblesType responsiblesType = (ResponsiblesType)theEObject;
				Object result = caseResponsiblesType(responsiblesType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.ROUTE_TYPE: {
				RouteType routeType = (RouteType)theEObject;
				Object result = caseRouteType(routeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.SCHEMA_TYPE_TYPE: {
				SchemaTypeType schemaTypeType = (SchemaTypeType)theEObject;
				Object result = caseSchemaTypeType(schemaTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.SCRIPT_TYPE: {
				ScriptType scriptType = (ScriptType)theEObject;
				Object result = caseScriptType(scriptType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.SIMULATION_INFORMATION_TYPE: {
				SimulationInformationType simulationInformationType = (SimulationInformationType)theEObject;
				Object result = caseSimulationInformationType(simulationInformationType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.SPLIT_TYPE: {
				SplitType splitType = (SplitType)theEObject;
				Object result = caseSplitType(splitType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.START_MODE_TYPE: {
				StartModeType startModeType = (StartModeType)theEObject;
				Object result = caseStartModeType(startModeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.SUB_FLOW_TYPE: {
				SubFlowType subFlowType = (SubFlowType)theEObject;
				Object result = caseSubFlowType(subFlowType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TIME_ESTIMATION_TYPE: {
				TimeEstimationType timeEstimationType = (TimeEstimationType)theEObject;
				Object result = caseTimeEstimationType(timeEstimationType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TOOL_TYPE: {
				ToolType toolType = (ToolType)theEObject;
				Object result = caseToolType(toolType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TRANSITION_REFS_TYPE: {
				TransitionRefsType transitionRefsType = (TransitionRefsType)theEObject;
				Object result = caseTransitionRefsType(transitionRefsType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TRANSITION_REF_TYPE: {
				TransitionRefType transitionRefType = (TransitionRefType)theEObject;
				Object result = caseTransitionRefType(transitionRefType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TRANSITION_RESTRICTIONS_TYPE: {
				TransitionRestrictionsType transitionRestrictionsType = (TransitionRestrictionsType)theEObject;
				Object result = caseTransitionRestrictionsType(transitionRestrictionsType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TRANSITION_RESTRICTION_TYPE: {
				TransitionRestrictionType transitionRestrictionType = (TransitionRestrictionType)theEObject;
				Object result = caseTransitionRestrictionType(transitionRestrictionType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TRANSITIONS_TYPE: {
				TransitionsType transitionsType = (TransitionsType)theEObject;
				Object result = caseTransitionsType(transitionsType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TRANSITION_TYPE: {
				TransitionType transitionType = (TransitionType)theEObject;
				Object result = caseTransitionType(transitionType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TYPE_DECLARATIONS_TYPE: {
				TypeDeclarationsType typeDeclarationsType = (TypeDeclarationsType)theEObject;
				Object result = caseTypeDeclarationsType(typeDeclarationsType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.TYPE_DECLARATION_TYPE: {
				TypeDeclarationType typeDeclarationType = (TypeDeclarationType)theEObject;
				Object result = caseTypeDeclarationType(typeDeclarationType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.UNION_TYPE_TYPE: {
				UnionTypeType unionTypeType = (UnionTypeType)theEObject;
				Object result = caseUnionTypeType(unionTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.WORKFLOW_PROCESSES_TYPE: {
				WorkflowProcessesType workflowProcessesType = (WorkflowProcessesType)theEObject;
				Object result = caseWorkflowProcessesType(workflowProcessesType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.WORKFLOW_PROCESS_TYPE: {
				WorkflowProcessType workflowProcessType = (WorkflowProcessType)theEObject;
				Object result = caseWorkflowProcessType(workflowProcessType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XpdlPackage.XPRESSION_TYPE: {
				XpressionType xpressionType = (XpressionType)theEObject;
				Object result = caseXpressionType(xpressionType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Activities Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Activities Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseActivitiesType(ActivitiesType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Activity Sets Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Activity Sets Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseActivitySetsType(ActivitySetsType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Activity Set Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Activity Set Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseActivitySetType(ActivitySetType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Activity Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Activity Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseActivityType(ActivityType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Actual Parameters Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Actual Parameters Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseActualParametersType(ActualParametersType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Applications Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Applications Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseApplicationsType(ApplicationsType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Application Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Application Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseApplicationType(ApplicationType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Array Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Array Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseArrayTypeType(ArrayTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Automatic Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Automatic Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAutomaticType(AutomaticType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Basic Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Basic Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBasicTypeType(BasicTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Block Activity Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Block Activity Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBlockActivityType(BlockActivityType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Condition Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Condition Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseConditionType(ConditionType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Conformance Class Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Conformance Class Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseConformanceClassType(ConformanceClassType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Data Fields Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Data Fields Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDataFieldsType(DataFieldsType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Data Field Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Data Field Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDataFieldType(DataFieldType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Data Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Data Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDataTypeType(DataTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Deadline Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Deadline Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDeadlineType(DeadlineType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Declared Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Declared Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDeclaredTypeType(DeclaredTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Document Root</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDocumentRoot(DocumentRoot object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Enumeration Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Enumeration Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseEnumerationTypeType(EnumerationTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Enumeration Value Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Enumeration Value Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseEnumerationValueType(EnumerationValueType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Extended Attributes Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Extended Attributes Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseExtendedAttributesType(ExtendedAttributesType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Extended Attribute Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Extended Attribute Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseExtendedAttributeType(ExtendedAttributeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>External Packages Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>External Packages Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseExternalPackagesType(ExternalPackagesType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>External Package Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>External Package Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseExternalPackageType(ExternalPackageType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>External Reference Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>External Reference Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseExternalReferenceType(ExternalReferenceType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Finish Mode Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Finish Mode Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFinishModeType(FinishModeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Formal Parameters Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Formal Parameters Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFormalParametersType(FormalParametersType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Formal Parameter Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Formal Parameter Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFormalParameterType(FormalParameterType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Implementation Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Implementation Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseImplementationType(ImplementationType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Join Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Join Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseJoinType(JoinType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>List Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>List Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseListTypeType(ListTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Manual Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Manual Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseManualType(ManualType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Member Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Member Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseMemberType(MemberType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>No Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>No Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseNoType(NoType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Package Header Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Package Header Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object casePackageHeaderType(PackageHeaderType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Package Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Package Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object casePackageType(PackageType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Participants Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Participants Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseParticipantsType(ParticipantsType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Participant Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Participant Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseParticipantType(ParticipantType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Participant Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Participant Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseParticipantTypeType(ParticipantTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Process Header Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Process Header Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseProcessHeaderType(ProcessHeaderType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Record Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Record Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRecordTypeType(RecordTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Redefinable Header Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Redefinable Header Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRedefinableHeaderType(RedefinableHeaderType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Responsibles Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Responsibles Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseResponsiblesType(ResponsiblesType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Route Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Route Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRouteType(RouteType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Schema Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Schema Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSchemaTypeType(SchemaTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Script Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Script Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseScriptType(ScriptType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Simulation Information Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Simulation Information Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSimulationInformationType(SimulationInformationType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Split Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Split Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSplitType(SplitType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Start Mode Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Start Mode Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseStartModeType(StartModeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Sub Flow Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Sub Flow Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSubFlowType(SubFlowType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Time Estimation Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Time Estimation Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTimeEstimationType(TimeEstimationType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Tool Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Tool Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseToolType(ToolType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Transition Refs Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Transition Refs Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTransitionRefsType(TransitionRefsType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Transition Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Transition Ref Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTransitionRefType(TransitionRefType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Transition Restrictions Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Transition Restrictions Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTransitionRestrictionsType(TransitionRestrictionsType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Transition Restriction Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Transition Restriction Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTransitionRestrictionType(TransitionRestrictionType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Transitions Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Transitions Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTransitionsType(TransitionsType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Transition Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Transition Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTransitionType(TransitionType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Type Declarations Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Type Declarations Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTypeDeclarationsType(TypeDeclarationsType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Type Declaration Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Type Declaration Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTypeDeclarationType(TypeDeclarationType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Union Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Union Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseUnionTypeType(UnionTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Workflow Processes Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Workflow Processes Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseWorkflowProcessesType(WorkflowProcessesType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Workflow Process Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Workflow Process Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseWorkflowProcessType(WorkflowProcessType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Xpression Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Xpression Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseXpressionType(XpressionType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //XpdlSwitch
