package brent.testcase;

import java.util.Date;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.vtp.launching.IVoiceXMLBrowser;
import org.eclipse.vtp.launching.IVoiceXMLBrowserConstants;
import org.eclipse.vtp.launching.VoiceXMLBrowserInput;
import org.eclipse.vtp.launching.VoiceXMLBrowserProcess;
import org.eclipse.vtp.launching.VoiceXMLLogMessage;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
public class MyVoiceXMLBrowser implements IVoiceXMLBrowser {
	protected VoiceXMLBrowserProcess process = null;
	
	public void start() {
		System.out.println("brentBrowser.start()");
		
		DebugEvent event[] = new DebugEvent[10];
		for (int i = 0 ; i < 10;i++) {
			event[i] = new DebugEvent(this, DebugEvent.MODEL_SPECIFIC, IVoiceXMLBrowserConstants.EVENT_LOG_MESSAGE);
			event[i].setData(new VoiceXMLLogMessage(new Date(), "This is a test " + i));
		}
		DebugPlugin.getDefault().fireDebugEventSet(event);
	}

	public void stop() {
		System.out.println("brentBrowser.stop()");
		DebugEvent event[] = new DebugEvent[2];
		event[0] = new DebugEvent(process, DebugEvent.TERMINATE);
		event[1] = new DebugEvent(process.getLaunch(), DebugEvent.CHANGE);
//		event[0] = new DebugEvent(process, DebugEvent.TERMINATE);
//		event[1] = new DebugEvent(process, DebugEvent.CHANGE, DebugEvent.CONTENT);
//		event[1] = new DebugEvent(process, DebugEvent.CHANGE, DebugEvent.STATE);
//		event[2] = new DebugEvent(process.getLaunch(), DebugEvent.TERMINATE);
//		event[3] = new DebugEvent(process.getLaunch(), DebugEvent.CHANGE, DebugEvent.CONTENT);
		DebugPlugin.getDefault().fireDebugEventSet(event);
	}

	public void sendInput(VoiceXMLBrowserInput input) {
		System.out.println("brentBrowser.sendInput()");
		
		DebugEvent event[] = new DebugEvent[1];
		event[0] = new DebugEvent(this, DebugEvent.MODEL_SPECIFIC, IVoiceXMLBrowserConstants.EVENT_LOG_MESSAGE);
		if (input.getInputType()==VoiceXMLBrowserInput.TYPE_DTMF) {
			event[0].setData(new VoiceXMLLogMessage(new Date(), "Got DTMF " + input.getInput()));
		} else {
			event[0].setData(new VoiceXMLLogMessage(new Date(), "Got Something else "));
		}
		DebugPlugin.getDefault().fireDebugEventSet(event);
	}

	public void setProperty(String propertyname, Object value) {
		System.out.println("brentBrowser.setProperty(" + propertyname + "," + value.toString() + ")");

	}

	public boolean hasCapability(String capability) {
		if (capability == null) {
			return false;
		}
		if (capability.equals(IVoiceXMLBrowser.CAPABILITY_LOG_EVENT)) {
			return true;
		}
		if (capability.equals(IVoiceXMLBrowser.CAPABILITY_INTERACTIVE)) {
			return true;
		}
		if (capability.equals(IVoiceXMLBrowser.CAPABILITY_DTMF)) {
			return true;
		}
		return false;
	}

	public void setProcess(VoiceXMLBrowserProcess process) {
		this.process=process;
	}

	public VoiceXMLBrowserProcess getProcess() {
		return process;
	}

}
