package brent.testcase;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.debug.ui.BrowserConfigurationUIListener;
import org.eclipse.vtp.debug.ui.IBrowserConfigurationUI;

public class MyBrowserUI implements IBrowserConfigurationUI {
	public final String INTENSITY="brent.testcase.intensity";
	
	private BrowserConfigurationUIListener listener = null;
	private Text speechText;
	
	/**
	 * Initializes the given launch configuration with default values for this UI. This method is called when a new launch configuration is created such that the configuration can be initialized with meaningful values. This method may be called before this tab's control is created. 
	 *
	 * @param configuration Launch Configuration
	 */
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		System.out.println("setDefaults");
		if (speechText != null) {
			try {
				speechText.setText(configuration.getAttribute(INTENSITY, "Default"));
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * Copies values from this tab into the given launch configuration.
	 * 
	 * @param configuration Launch Configuration
	 */
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		System.out.println("performApply");
		if (speechText != null) {
			configuration.setAttribute(INTENSITY, speechText.getText());
		}
	}
	
	/**
	 * Initializes this UI's controls with values from the given launch configuration. This method is called when a configuration is selected to view or edit, after this UI's control has been created. 
	 * @param configuration
	 */
	public void initializeFrom(ILaunchConfiguration configuration) {
		System.out.println("initializeFrom");
		if (speechText != null) {
			try {
				speechText.setText(configuration.getAttribute(INTENSITY, "Default"));
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
	}
	
	public void drawConfigurationUI(Composite UI, final BrowserConfigurationUIListener listener) {
		System.out.println("draw");
		this.listener=listener;
		
		GridLayout gl = new GridLayout();
		gl.numColumns=2;
		UI.setLayout(gl);
		
		Label l = new Label(UI, SWT.NONE);
		l.setText("Speech Intensity: ");
		
		speechText = new Text(UI, SWT.BORDER);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.grabExcessHorizontalSpace=true;
		speechText.setLayoutData(gd);
		speechText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				System.out.println("modify");
				listener.contentsChanged();
				
			}
		});
		
	}

	public boolean isValid(ILaunchConfiguration configuration) {
		return true;
	}

	public void dispose() {
		// TODO Auto-generated method stub
		
	}

}
