/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlBasicRenderer
extends Renderer {
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();
    protected static final Param[] EMPTY_PARAMS = new Param[0];

    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }

    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!(component instanceof UIInput)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No decoding necessary since the component {0} is not an instance or a sub class of UIInput", component.getId());
            }
            return;
        }
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        assert (clientId != null);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(clientId);
        if (newValue != null) {
            this.setSubmittedValue(component, newValue);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "new value after decoding {0}", newValue);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String currentValue = this.getCurrentValue(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Value to be rendered {0}", currentValue);
        }
        this.getEndTextToRender(context, component, currentValue);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String augmentIdReference(String forValue, UIComponent fromComponent) {
        String id;
        int idSuffix;
        int forSuffix = forValue.lastIndexOf("j_id");
        if (forSuffix <= 0 && (idSuffix = (id = fromComponent.getId()).lastIndexOf("j_id")) > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Augmenting for attribute with " + id.substring(idSuffix) + " suffix from Id attribute");
            }
            forValue = forValue + id.substring(idSuffix);
        }
        return forValue;
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator<UIComponent> kids = this.getChildren(component);
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }

    protected Iterator<UIComponent> getChildren(UIComponent component) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            return component.getChildren().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        String currentValue = null;
        Object currentObj = this.getValue(component);
        if (currentObj != null) {
            currentValue = this.getFormattedValue(context, component, currentObj);
        }
        return currentValue;
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
    }

    protected UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = null;
        if (component.getFacetCount() > 0 && (facet = component.getFacet(name)) != null && !facet.isRendered()) {
            facet = null;
        }
        return facet;
    }

    protected UIComponent getForComponent(FacesContext context, String forComponent, UIComponent component) {
        if (null == forComponent || forComponent.length() == 0) {
            return null;
        }
        UIComponent result = null;
        try {
            for (UIComponent currentParent = component; currentParent != null && (result = currentParent.findComponent(forComponent)) == null; currentParent = currentParent.getParent()) {
            }
            if (result == null) {
                result = HtmlBasicRenderer.findUIComponentBelow((UIComponent)context.getViewRoot(), forComponent);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null && logger.isLoggable(Level.WARNING)) {
            logger.warning(MessageUtils.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_IN_VIEW_WARNING", forComponent));
        }
        return result;
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue, Converter converter) throws ConverterException {
        if (!(component instanceof ValueHolder)) {
            if (currentValue != null) {
                return currentValue.toString();
            }
            return null;
        }
        if (converter == null) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null) {
            if (currentValue == null) {
                return "";
            }
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = Util.getConverterForClass(converterType, context);
            if (converter == null) {
                return currentValue.toString();
            }
        }
        return converter.getAsString(context, component, currentValue);
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return this.getFormattedValue(context, component, currentValue, null);
    }

    protected Iterator getMessageIter(FacesContext context, String forComponent, UIComponent component) {
        UIComponent result;
        Iterator messageIter = null != forComponent ? (forComponent.length() == 0 ? context.getMessages(null) : ((result = this.getForComponent(context, forComponent, component)) == null ? Collections.EMPTY_LIST.iterator() : context.getMessages(result.getClientId(context)))) : context.getMessages();
        return messageIter;
    }

    protected Param[] getParamList(UIComponent command) {
        if (command.getChildCount() > 0) {
            ArrayList<Param> parameterList = new ArrayList<Param>();
            for (UIComponent kid : command.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter uiParam = (UIParameter)kid;
                Object value = uiParam.getValue();
                Param param = new Param(uiParam.getName(), value == null ? null : value.toString());
                parameterList.add(param);
            }
            return parameterList.toArray(new Param[parameterList.size()]);
        }
        return EMPTY_PARAMS;
    }

    protected Object getValue(UIComponent component) {
        throw new UnsupportedOperationException();
    }

    protected void setSubmittedValue(UIComponent component, Object value) {
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        String id = component.getId();
        return null != id && !id.startsWith("j_id");
    }

    protected String writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) {
        String id;
        block3: {
            id = null;
            if (this.shouldWriteIdAttribute(component)) {
                try {
                    id = component.getClientId(context);
                    writer.writeAttribute("id", (Object)id, "id");
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_WRITE_ID_ATTRIBUTE", e.getMessage());
                    logger.warning(message);
                }
            }
        }
        return id;
    }

    protected void rendererParamsNotNull(FacesContext context, UIComponent component) {
        Util.notNull("context", context);
        Util.notNull("component", component);
    }

    protected boolean shouldEncode(UIComponent component) {
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "End encoding component {0} since rendered attribute is set to false", component.getId());
            }
            return false;
        }
        return true;
    }

    protected boolean shouldDecode(UIComponent component) {
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No decoding necessary since the component {0} is disabled or read-only", component.getId());
            }
            return false;
        }
        return true;
    }

    protected boolean shouldEncodeChildren(UIComponent component) {
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Children of component {0} will not be encoded since this component's rendered attribute is false", component.getId());
            }
            return false;
        }
        return true;
    }

    private static UIComponent findUIComponentBelow(UIComponent startPoint, String forComponent) {
        UIComponent retComp = null;
        if (startPoint.getChildCount() > 0) {
            List children = startPoint.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                UIComponent comp = (UIComponent)children.get(i);
                if (comp instanceof NamingContainer) {
                    try {
                        retComp = comp.findComponent(forComponent);
                    }
                    catch (IllegalArgumentException iae) {
                        continue;
                    }
                }
                if (retComp == null && comp.getChildCount() > 0) {
                    retComp = HtmlBasicRenderer.findUIComponentBelow(comp, forComponent);
                }
                if (retComp != null) break;
            }
        }
        return retComp;
    }

    public static class Param {
        public String name;
        public String value;

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

