/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.facelets.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.webapp.pdl.AttachedObjectHandler;
import javax.faces.webapp.pdl.EditableValueHolderAttachedObjectHandler;
import javax.faces.webapp.pdl.facelets.FaceletContext;
import javax.faces.webapp.pdl.facelets.FaceletException;
import javax.faces.webapp.pdl.facelets.tag.TagAttribute;
import javax.faces.webapp.pdl.facelets.tag.TagAttributeException;
import javax.faces.webapp.pdl.facelets.tag.TagConfig;
import javax.faces.webapp.pdl.facelets.tag.TagException;

public final class ValueChangeListenerHandler
extends TagHandlerImpl
implements EditableValueHolderAttachedObjectHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;

    public ValueChangeListenerHandler(TagConfig config) {
        super(config);
        TagAttribute type = this.getAttribute("type");
        if (type != null) {
            if (!type.isLiteral()) {
                throw new TagAttributeException(type, "Must be a literal class name of type ValueChangeListener");
            }
            try {
                ReflectionUtil.forName(type.getValue());
            }
            catch (ClassNotFoundException e) {
                throw new TagAttributeException(type, "Couldn't qualify ValueChangeListener", (Throwable)e);
            }
            this.listenerType = type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent == null || !ComponentSupport.isNew(parent)) {
            return;
        }
        if (parent instanceof EditableValueHolder) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (parent.getAttributes().containsKey("javax.faces.application.Resource.ComponentResource")) {
            CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add((AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not of type EditableValueHolder, type is: " + parent);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        EditableValueHolder evh = (EditableValueHolder)parent;
        ValueExpression b = null;
        if (this.binding != null) {
            b = this.binding.getValueExpression(ctx, ValueChangeListener.class);
        }
        LazyValueChangeListener listener = new LazyValueChangeListener(this.listenerType, b);
        evh.addValueChangeListener((ValueChangeListener)listener);
    }

    public String getFor() {
        String result = null;
        TagAttribute attr = this.getAttribute("for");
        if (null != attr) {
            result = attr.getValue();
        }
        return result;
    }

    private static class LazyValueChangeListener
    implements ValueChangeListener,
    Serializable {
        private static final long serialVersionUID = 7613811124326963180L;
        private final String type;
        private final ValueExpression binding;

        public LazyValueChangeListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processValueChange(ValueChangeEvent event) throws AbortProcessingException {
            ValueChangeListener instance = null;
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            if (this.binding != null) {
                instance = (ValueChangeListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (ValueChangeListener)ReflectionUtil.forName(this.type).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                instance.processValueChange(event);
            }
        }
    }
}

