/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.facelets.tag.MetaTagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.ActionSourceRule;
import com.sun.faces.facelets.tag.jsf.ComponentConfig;
import com.sun.faces.facelets.tag.jsf.ComponentRule;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.facelets.tag.jsf.EditableValueHolderRule;
import com.sun.faces.facelets.tag.jsf.ValueHolderRule;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.AjaxBehavior;
import javax.faces.component.AjaxBehaviors;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.InitialStateEvent;
import javax.faces.webapp.pdl.facelets.FaceletContext;
import javax.faces.webapp.pdl.facelets.tag.MetaRule;
import javax.faces.webapp.pdl.facelets.tag.MetaRuleset;
import javax.faces.webapp.pdl.facelets.tag.TagAttribute;
import javax.faces.webapp.pdl.facelets.tag.TagException;

public class ComponentHandler
extends MetaTagHandlerImpl {
    private static final Logger log = Logger.getLogger("facelets.tag.component");
    private final TagAttribute binding;
    protected String componentType;
    protected final TagAttribute id;
    private final String rendererType;
    private static final String INITIAL_STATE_EVENT_KEY = "facelets.tag.InitialStateEvent";

    public ComponentHandler(ComponentConfig config) {
        super(config);
        this.componentType = config.getComponentType();
        this.rendererType = config.getRendererType();
        this.id = this.getAttribute("id");
        this.binding = this.getAttribute("binding");
    }

    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        String facetName = this.getFacetName(ctx, parent);
        String id = ctx.generateUniqueId(this.tagId);
        UIComponent c = ComponentSupport.findChildByTagId(parent, id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Found, marking children for cleanup");
            }
            ComponentSupport.markForDeletion(c);
        } else {
            c = this.createComponent(ctx);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            this.setAttributes(ctx, c);
            c.getAttributes().put("com.sun.faces.facelets.MARK_ID", id);
            if (this.id != null) {
                c.setId(this.id.getValue(ctx));
            } else {
                UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
                if (root != null) {
                    String uid = root.createUniqueId();
                    c.setId(uid);
                }
            }
            if (this.rendererType != null) {
                c.setRendererType(this.rendererType);
            }
            this.onComponentCreated(ctx, c, parent);
        }
        c.pushComponentToEL(ctx.getFacesContext(), c);
        this.applyNextHandler(ctx, c);
        if (componentFound) {
            ComponentSupport.finalizeForDeletion(c);
            if (facetName == null) {
                parent.getChildren().remove(c);
            }
        }
        c.processEvent((ComponentSystemEvent)ComponentHandler.getInitialStateEvent(ctx.getFacesContext(), c));
        this.onComponentPopulated(ctx, c, parent);
        if (facetName == null) {
            parent.getChildren().add(c);
        } else {
            parent.getFacets().put(facetName, c);
        }
        c.popComponentFromEL(ctx.getFacesContext());
    }

    private static InitialStateEvent getInitialStateEvent(FacesContext context, UIComponent source) {
        InitialStateEvent ise = null;
        Map attrs = context.getAttributes();
        ise = (InitialStateEvent)attrs.get(INITIAL_STATE_EVENT_KEY);
        if (null == ise) {
            ise = new InitialStateEvent(source);
            attrs.put(INITIAL_STATE_EVENT_KEY, ise);
        } else {
            ise.setComponent(source);
        }
        return ise;
    }

    protected final String getFacetName(FaceletContext ctx, UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    protected UIComponent createComponent(FaceletContext ctx) {
        UIComponent c = null;
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, Object.class);
            c = app.createComponent(ve, faces, this.componentType, this.rendererType);
            if (c != null) {
                c.setValueExpression("binding", ve);
            }
        } else {
            c = app.createComponent(faces, this.componentType, this.rendererType);
        }
        return c;
    }

    protected String getId(FaceletContext ctx) {
        if (this.id != null) {
            return this.id.getValue(ctx);
        }
        return ctx.generateUniqueId(this.tagId);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.ignore("binding").ignore("id");
        m.addRule((MetaRule)ComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule((MetaRule)ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule((MetaRule)ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule((MetaRule)EditableValueHolderRule.Instance);
            }
        }
        return m;
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        AjaxBehavior ajaxBehavior;
        String facesEventType = this.getFacesEventType(c);
        if (facesEventType == null) {
            return;
        }
        AjaxBehaviors ajaxBehaviors = (AjaxBehaviors)ctx.getFacesContext().getAttributes().get("javax.faces.component.AjaxBehaviors");
        if (ajaxBehaviors != null && (ajaxBehavior = ajaxBehaviors.getBehaviorForEvent(facesEventType)) != null) {
            c.getAttributes().put("javax.faces.component.AjaxBehavior", ajaxBehavior);
        }
    }

    protected String getFacesEventType(UIComponent c) {
        String event = null;
        if (c instanceof EditableValueHolder) {
            event = "valueChange";
        } else if (c instanceof ActionSource) {
            event = "action";
        }
        return event;
    }

    protected void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.nextHandler.apply(ctx, c);
    }
}

