package rmws.wsimpl.client;

import java.net.URI;

import javax.websocket.ClientEndpoint;
import javax.websocket.ContainerProvider;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public class RMWSClient {
	public static void main(String[] args) {
		WebSocketContainer container = null;
		Session session = null;
		try {
			container = ContainerProvider.getWebSocketContainer();

			session = container.connectToServer(RMWSClient.class, URI
					.create("ws://localhost:8080/RMWEBSOCKET_SERVER/resmanep"));

			session.getBasicRemote().sendText("this is a websocket call");
		} catch (Throwable e) {
			e.printStackTrace();
		} finally {
			if (session != null) {
				try {
					session.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}
}
