/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.frame;

import java.nio.ByteBuffer;
import java.util.Locale;
import org.glassfish.tyrus.core.ProtocolException;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.frame.BinaryFrame;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.PingFrame;
import org.glassfish.tyrus.core.frame.PongFrame;
import org.glassfish.tyrus.core.frame.TextFrame;

public abstract class TyrusFrame
extends Frame {
    protected TyrusFrame(Frame frame) {
        super(frame);
    }

    public abstract void respond(TyrusWebSocket var1);

    public static TyrusFrame wrap(Frame frame, byte inFragmentedType, ByteBuffer remainder) {
        switch (frame.getOpcode()) {
            case 0: {
                if ((inFragmentedType & 1) == 1) {
                    return new TextFrame(frame, remainder, true);
                }
                return new BinaryFrame(frame, true);
            }
            case 1: {
                return new TextFrame(frame, remainder);
            }
            case 2: {
                return new BinaryFrame(frame);
            }
            case 8: {
                return new CloseFrame(frame);
            }
            case 9: {
                return new PingFrame(frame);
            }
            case 10: {
                return new PongFrame(frame);
            }
        }
        throw new ProtocolException(String.format("Unknown wrappedFrame type: %s", Integer.toHexString(frame.getOpcode()).toUpperCase(Locale.US)));
    }
}

