/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientSocket;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyWriter;
import org.glassfish.tyrus.container.grizzly.client.HttpCodecFilter;
import org.glassfish.tyrus.container.grizzly.client.TaskProcessor;
import org.glassfish.tyrus.core.CloseReasons;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

class GrizzlyClientFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(GrizzlyClientFilter.class);
    private static final Attribute<org.glassfish.tyrus.spi.Connection> TYRUS_CONNECTION = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyClientFilter.class.getName() + ".Connection");
    private static final Attribute<UpgradeRequest> UPGRADE_REQUEST = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyClientFilter.class.getName() + ".UpgradeRequest");
    private final boolean proxy;
    private final Filter sslFilter;
    private final HttpCodecFilter httpCodecFilter;
    private final ClientEngine engine;
    private final URI uri;
    private final ClientEngine.TimeoutHandler timeoutHandler;
    private final boolean sharedTransport;
    private final Queue<TaskProcessor.Task> taskQueue = new ConcurrentLinkedQueue<TaskProcessor.Task>();

    GrizzlyClientFilter(ClientEngine engine, boolean proxy, Filter sslFilter, HttpCodecFilter httpCodecFilter, URI uri, ClientEngine.TimeoutHandler timeoutHandler, boolean sharedTransport) {
        this.engine = engine;
        this.proxy = proxy;
        this.sslFilter = sslFilter;
        this.httpCodecFilter = httpCodecFilter;
        this.uri = uri;
        this.timeoutHandler = timeoutHandler;
        this.sharedTransport = sharedTransport;
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) {
        LOGGER.log(Level.FINEST, "handleConnect");
        UpgradeRequest upgradeRequest = this.engine.createUpgradeRequest(this.uri, this.timeoutHandler);
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
        if (this.proxy) {
            UPGRADE_REQUEST.set(ctx.getConnection(), upgradeRequest);
            URI requestURI = URI.create(upgradeRequest.getRequestUri());
            int requestPort = requestURI.getPort() == -1 ? (requestURI.getScheme().equals("wss") ? 443 : 80) : requestURI.getPort();
            builder = builder.uri(String.format("%s:%d", requestURI.getHost(), requestPort));
            builder = (HttpRequestPacket.Builder)builder.protocol(Protocol.HTTP_1_1);
            builder = builder.method(Method.CONNECT);
            builder = (HttpRequestPacket.Builder)builder.header(Header.Host, requestURI.getHost());
            builder = (HttpRequestPacket.Builder)builder.header(Header.ProxyConnection, "keep-alive");
            builder = (HttpRequestPacket.Builder)builder.header(Header.Connection, "keep-alive");
            ctx.write(HttpContent.builder(builder.build()).build());
            ctx.flush(null);
        } else {
            ctx.write(this.getHttpContent(upgradeRequest));
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        org.glassfish.tyrus.spi.Connection connection = TYRUS_CONNECTION.get(ctx.getConnection());
        if (connection != null) {
            this.taskQueue.add(new CloseTask(connection, CloseReasons.CLOSED_ABNORMALLY.getCloseReason(), ctx.getConnection()));
            TaskProcessor.processQueue(this.taskQueue, null);
        }
        return ctx.getStopAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        HttpContent message = (HttpContent)ctx.getMessage();
        Connection grizzlyConnection = ctx.getConnection();
        org.glassfish.tyrus.spi.Connection tyrusConnection = TYRUS_CONNECTION.get(grizzlyConnection);
        HttpHeader header = message.getHttpHeader();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{tyrusConnection, message.getContent().remaining(), header});
        }
        if (tyrusConnection != null) {
            if (message.getContent().hasRemaining()) {
                Buffer buffer = message.getContent();
                ByteBuffer webSocketBuffer = buffer.toByteBuffer();
                message.recycle();
                ReadHandler readHandler = tyrusConnection.getReadHandler();
                this.taskQueue.add(new ProcessTask(webSocketBuffer, readHandler));
                TaskProcessor.processQueue(this.taskQueue, null);
            }
            return ctx.getStopAction();
        }
        HttpStatus httpStatus = ((HttpResponsePacket)message.getHttpHeader()).getHttpStatus();
        if (httpStatus.getStatusCode() != 101 && this.proxy) {
            if (httpStatus == HttpStatus.OK_200) {
                if (this.sslFilter != null) {
                    ((GrizzlyClientSocket.FilterWrapper)this.sslFilter).enable();
                }
            } else {
                throw new IOException(String.format("Proxy error. %s: %s", httpStatus.getStatusCode(), new String(httpStatus.getReasonPhraseBytes(), "UTF-8")));
            }
            this.httpCodecFilter.resetResponseProcessing(grizzlyConnection);
            UpgradeRequest upgradeRequest = UPGRADE_REQUEST.get(grizzlyConnection);
            ctx.write(this.getHttpContent(upgradeRequest));
            UPGRADE_REQUEST.remove(grizzlyConnection);
            return ctx.getInvokeAction();
        }
        if (!"websocket".equalsIgnoreCase(header.getUpgrade()) && message.getHttpHeader().isRequest()) {
            return ctx.getInvokeAction();
        }
        String ATTR_NAME = "org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED";
        AttributeHolder attributeHolder = ctx.getAttributes();
        if (attributeHolder != null) {
            Object attribute = attributeHolder.getAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED");
            if (attribute != null) {
                return ctx.getInvokeAction();
            }
            attributeHolder.setAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED", true);
        }
        return this.handleHandshake(ctx, message);
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) {
        final GrizzlyWriter grizzlyWriter = new GrizzlyWriter(ctx.getConnection()){

            @Override
            public void close() {
                super.close();
                try {
                    if (GrizzlyClientFilter.this.sharedTransport) {
                        this.connection.close();
                    } else {
                        this.connection.getTransport().shutdownNow();
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(GrizzlyClientFilter.class.getName()).log(Level.INFO, "Exception thrown during shutdown.", e);
                }
            }
        };
        org.glassfish.tyrus.spi.Connection tyrusConnection = this.engine.processResponse(GrizzlyClientFilter.getUpgradeResponse((HttpResponsePacket)content.getHttpHeader()), grizzlyWriter, new Connection.CloseListener(){

            @Override
            public void close(CloseReason reason) {
                grizzlyWriter.close();
            }
        });
        if (tyrusConnection == null) {
            return ctx.getStopAction();
        }
        TYRUS_CONNECTION.set(ctx.getConnection(), tyrusConnection);
        if (content.getContent().hasRemaining()) {
            return ctx.getRerunFilterAction();
        }
        content.recycle();
        return ctx.getStopAction();
    }

    private static UpgradeResponse getUpgradeResponse(HttpResponsePacket httpResponsePacket) {
        TyrusUpgradeResponse tyrusUpgradeResponse = new TyrusUpgradeResponse();
        for (String name : httpResponsePacket.getHeaders().names()) {
            List<String> values = tyrusUpgradeResponse.getHeaders().get(name);
            if (values == null) {
                tyrusUpgradeResponse.getHeaders().put(name, Utils.parseHeaderValue(httpResponsePacket.getHeader(name)));
                continue;
            }
            values.addAll(Utils.parseHeaderValue(httpResponsePacket.getHeader(name)));
        }
        tyrusUpgradeResponse.setStatus(httpResponsePacket.getStatus());
        return tyrusUpgradeResponse;
    }

    private HttpContent getHttpContent(UpgradeRequest request) {
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
        builder = (HttpRequestPacket.Builder)builder.protocol(Protocol.HTTP_1_1);
        builder = builder.method(Method.GET);
        StringBuilder sb = new StringBuilder();
        URI uri = URI.create(request.getRequestUri());
        sb.append(uri.getPath());
        String query = uri.getQuery();
        if (query != null) {
            sb.append('?').append(query);
        }
        if (sb.length() == 0) {
            sb.append('/');
        }
        builder = builder.uri(sb.toString());
        for (Map.Entry<String, List<String>> headerEntry : request.getHeaders().entrySet()) {
            StringBuilder finalHeaderValue = new StringBuilder();
            for (String headerValue : headerEntry.getValue()) {
                if (finalHeaderValue.length() != 0) {
                    finalHeaderValue.append(", ");
                }
                finalHeaderValue.append(headerValue);
            }
            builder.header(headerEntry.getKey(), finalHeaderValue.toString());
        }
        return HttpContent.builder(builder.build()).build();
    }

    private class CloseTask
    extends TaskProcessor.Task {
        private final org.glassfish.tyrus.spi.Connection connection;
        private final CloseReason closeReason;
        private final Connection grizzlyConnection;

        private CloseTask(org.glassfish.tyrus.spi.Connection connection, CloseReason closeReason, Connection grizzlyConnection) {
            this.connection = connection;
            this.closeReason = closeReason;
            this.grizzlyConnection = grizzlyConnection;
        }

        @Override
        public void execute() {
            this.connection.close(this.closeReason);
            TYRUS_CONNECTION.remove(this.grizzlyConnection);
        }
    }

    private class ProcessTask
    extends TaskProcessor.Task {
        private final ByteBuffer buffer;
        private final ReadHandler readHandler;

        private ProcessTask(ByteBuffer buffer, ReadHandler readHandler) {
            this.buffer = buffer;
            this.readHandler = readHandler;
        }

        @Override
        public void execute() {
            this.readHandler.handle(this.buffer);
        }
    }
}

