/**
 */
package de.uni.due.swe.dataFlowDiagramPattern;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternFactory
 * @model kind="package"
 * @generated
 */
public interface DataFlowDiagramPatternPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "dataFlowDiagramPattern";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://de/uni/due/swe/dfdp";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "de.uni.due.swe.dfdp";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DataFlowDiagramPatternPackage eINSTANCE = de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ComponentImpl <em>Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ComponentImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getComponent()
	 * @generated
	 */
	int COMPONENT = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__NAME = 0;

	/**
	 * The feature id for the '<em><b>Contained Data Flows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__CONTAINED_DATA_FLOWS = 1;

	/**
	 * The feature id for the '<em><b>Is Asset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__IS_ASSET = 2;

	/**
	 * The feature id for the '<em><b>External Dependency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__EXTERNAL_DEPENDENCY = 3;

	/**
	 * The feature id for the '<em><b>Security Assumptions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__SECURITY_ASSUMPTIONS = 4;

	/**
	 * The feature id for the '<em><b>Security Notes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__SECURITY_NOTES = 5;

	/**
	 * The feature id for the '<em><b>Elicitation Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__ELICITATION_REASONING = 6;

	/**
	 * The feature id for the '<em><b>Contained By Privilege Boundary</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__CONTAINED_BY_PRIVILEGE_BOUNDARY = 7;

	/**
	 * The feature id for the '<em><b>Contained Vulnerabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__CONTAINED_VULNERABILITIES = 8;

	/**
	 * The feature id for the '<em><b>Possible Attackers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__POSSIBLE_ATTACKERS = 9;

	/**
	 * The feature id for the '<em><b>Contained Assets</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__CONTAINED_ASSETS = 10;

	/**
	 * The number of structural features of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.DataStoreImpl <em>Data Store</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataStoreImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getDataStore()
	 * @generated
	 */
	int DATA_STORE = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__NAME = COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Contained Data Flows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__CONTAINED_DATA_FLOWS = COMPONENT__CONTAINED_DATA_FLOWS;

	/**
	 * The feature id for the '<em><b>Is Asset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__IS_ASSET = COMPONENT__IS_ASSET;

	/**
	 * The feature id for the '<em><b>External Dependency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__EXTERNAL_DEPENDENCY = COMPONENT__EXTERNAL_DEPENDENCY;

	/**
	 * The feature id for the '<em><b>Security Assumptions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__SECURITY_ASSUMPTIONS = COMPONENT__SECURITY_ASSUMPTIONS;

	/**
	 * The feature id for the '<em><b>Security Notes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__SECURITY_NOTES = COMPONENT__SECURITY_NOTES;

	/**
	 * The feature id for the '<em><b>Elicitation Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__ELICITATION_REASONING = COMPONENT__ELICITATION_REASONING;

	/**
	 * The feature id for the '<em><b>Contained By Privilege Boundary</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__CONTAINED_BY_PRIVILEGE_BOUNDARY = COMPONENT__CONTAINED_BY_PRIVILEGE_BOUNDARY;

	/**
	 * The feature id for the '<em><b>Contained Vulnerabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__CONTAINED_VULNERABILITIES = COMPONENT__CONTAINED_VULNERABILITIES;

	/**
	 * The feature id for the '<em><b>Possible Attackers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__POSSIBLE_ATTACKERS = COMPONENT__POSSIBLE_ATTACKERS;

	/**
	 * The feature id for the '<em><b>Contained Assets</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE__CONTAINED_ASSETS = COMPONENT__CONTAINED_ASSETS;

	/**
	 * The number of structural features of the '<em>Data Store</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Data Store</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STORE_OPERATION_COUNT = COMPONENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ComplexProcessImpl <em>Complex Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ComplexProcessImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getComplexProcess()
	 * @generated
	 */
	int COMPLEX_PROCESS = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__NAME = COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Contained Data Flows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__CONTAINED_DATA_FLOWS = COMPONENT__CONTAINED_DATA_FLOWS;

	/**
	 * The feature id for the '<em><b>Is Asset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__IS_ASSET = COMPONENT__IS_ASSET;

	/**
	 * The feature id for the '<em><b>External Dependency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__EXTERNAL_DEPENDENCY = COMPONENT__EXTERNAL_DEPENDENCY;

	/**
	 * The feature id for the '<em><b>Security Assumptions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__SECURITY_ASSUMPTIONS = COMPONENT__SECURITY_ASSUMPTIONS;

	/**
	 * The feature id for the '<em><b>Security Notes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__SECURITY_NOTES = COMPONENT__SECURITY_NOTES;

	/**
	 * The feature id for the '<em><b>Elicitation Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__ELICITATION_REASONING = COMPONENT__ELICITATION_REASONING;

	/**
	 * The feature id for the '<em><b>Contained By Privilege Boundary</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__CONTAINED_BY_PRIVILEGE_BOUNDARY = COMPONENT__CONTAINED_BY_PRIVILEGE_BOUNDARY;

	/**
	 * The feature id for the '<em><b>Contained Vulnerabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__CONTAINED_VULNERABILITIES = COMPONENT__CONTAINED_VULNERABILITIES;

	/**
	 * The feature id for the '<em><b>Possible Attackers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__POSSIBLE_ATTACKERS = COMPONENT__POSSIBLE_ATTACKERS;

	/**
	 * The feature id for the '<em><b>Contained Assets</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS__CONTAINED_ASSETS = COMPONENT__CONTAINED_ASSETS;

	/**
	 * The number of structural features of the '<em>Complex Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Complex Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_PROCESS_OPERATION_COUNT = COMPONENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ExternalEntityImpl <em>External Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ExternalEntityImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getExternalEntity()
	 * @generated
	 */
	int EXTERNAL_ENTITY = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__NAME = COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Contained Data Flows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__CONTAINED_DATA_FLOWS = COMPONENT__CONTAINED_DATA_FLOWS;

	/**
	 * The feature id for the '<em><b>Is Asset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__IS_ASSET = COMPONENT__IS_ASSET;

	/**
	 * The feature id for the '<em><b>External Dependency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__EXTERNAL_DEPENDENCY = COMPONENT__EXTERNAL_DEPENDENCY;

	/**
	 * The feature id for the '<em><b>Security Assumptions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__SECURITY_ASSUMPTIONS = COMPONENT__SECURITY_ASSUMPTIONS;

	/**
	 * The feature id for the '<em><b>Security Notes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__SECURITY_NOTES = COMPONENT__SECURITY_NOTES;

	/**
	 * The feature id for the '<em><b>Elicitation Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__ELICITATION_REASONING = COMPONENT__ELICITATION_REASONING;

	/**
	 * The feature id for the '<em><b>Contained By Privilege Boundary</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__CONTAINED_BY_PRIVILEGE_BOUNDARY = COMPONENT__CONTAINED_BY_PRIVILEGE_BOUNDARY;

	/**
	 * The feature id for the '<em><b>Contained Vulnerabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__CONTAINED_VULNERABILITIES = COMPONENT__CONTAINED_VULNERABILITIES;

	/**
	 * The feature id for the '<em><b>Possible Attackers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__POSSIBLE_ATTACKERS = COMPONENT__POSSIBLE_ATTACKERS;

	/**
	 * The feature id for the '<em><b>Contained Assets</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY__CONTAINED_ASSETS = COMPONENT__CONTAINED_ASSETS;

	/**
	 * The number of structural features of the '<em>External Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>External Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENTITY_OPERATION_COUNT = COMPONENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowImpl <em>Data Flow</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getDataFlow()
	 * @generated
	 */
	int DATA_FLOW = 3;

	/**
	 * The feature id for the '<em><b>Source</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW__SOURCE = 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW__TARGET = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW__NAME = 2;

	/**
	 * The feature id for the '<em><b>Elicitation Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW__ELICITATION_REASONING = 3;

	/**
	 * The feature id for the '<em><b>Contained Vulnerabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW__CONTAINED_VULNERABILITIES = 4;

	/**
	 * The feature id for the '<em><b>Possible Attackers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW__POSSIBLE_ATTACKERS = 5;

	/**
	 * The number of structural features of the '<em>Data Flow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Data Flow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ProcessImpl <em>Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ProcessImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getProcess()
	 * @generated
	 */
	int PROCESS = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__NAME = COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Contained Data Flows</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__CONTAINED_DATA_FLOWS = COMPONENT__CONTAINED_DATA_FLOWS;

	/**
	 * The feature id for the '<em><b>Is Asset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__IS_ASSET = COMPONENT__IS_ASSET;

	/**
	 * The feature id for the '<em><b>External Dependency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__EXTERNAL_DEPENDENCY = COMPONENT__EXTERNAL_DEPENDENCY;

	/**
	 * The feature id for the '<em><b>Security Assumptions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__SECURITY_ASSUMPTIONS = COMPONENT__SECURITY_ASSUMPTIONS;

	/**
	 * The feature id for the '<em><b>Security Notes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__SECURITY_NOTES = COMPONENT__SECURITY_NOTES;

	/**
	 * The feature id for the '<em><b>Elicitation Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__ELICITATION_REASONING = COMPONENT__ELICITATION_REASONING;

	/**
	 * The feature id for the '<em><b>Contained By Privilege Boundary</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__CONTAINED_BY_PRIVILEGE_BOUNDARY = COMPONENT__CONTAINED_BY_PRIVILEGE_BOUNDARY;

	/**
	 * The feature id for the '<em><b>Contained Vulnerabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__CONTAINED_VULNERABILITIES = COMPONENT__CONTAINED_VULNERABILITIES;

	/**
	 * The feature id for the '<em><b>Possible Attackers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__POSSIBLE_ATTACKERS = COMPONENT__POSSIBLE_ATTACKERS;

	/**
	 * The feature id for the '<em><b>Contained Assets</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__CONTAINED_ASSETS = COMPONENT__CONTAINED_ASSETS;

	/**
	 * The number of structural features of the '<em>Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_OPERATION_COUNT = COMPONENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramImpl <em>Data Flow Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getDataFlowDiagram()
	 * @generated
	 */
	int DATA_FLOW_DIAGRAM = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW_DIAGRAM__NAME = 0;

	/**
	 * The feature id for the '<em><b>Contained Components</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW_DIAGRAM__CONTAINED_COMPONENTS = 1;

	/**
	 * The feature id for the '<em><b>Contained Privilege Boundaries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW_DIAGRAM__CONTAINED_PRIVILEGE_BOUNDARIES = 2;

	/**
	 * The number of structural features of the '<em>Data Flow Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW_DIAGRAM_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Data Flow Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FLOW_DIAGRAM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.PrivilegeBoundaryImpl <em>Privilege Boundary</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.PrivilegeBoundaryImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getPrivilegeBoundary()
	 * @generated
	 */
	int PRIVILEGE_BOUNDARY = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVILEGE_BOUNDARY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Componets Within</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVILEGE_BOUNDARY__COMPONETS_WITHIN = 1;

	/**
	 * The number of structural features of the '<em>Privilege Boundary</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVILEGE_BOUNDARY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Privilege Boundary</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVILEGE_BOUNDARY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ContainedAssetImpl <em>Contained Asset</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ContainedAssetImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getContainedAsset()
	 * @generated
	 */
	int CONTAINED_ASSET = 8;

	/**
	 * The feature id for the '<em><b>Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINED_ASSET__REASONING = 0;

	/**
	 * The feature id for the '<em><b>Component Asset</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINED_ASSET__COMPONENT_ASSET = 1;

	/**
	 * The number of structural features of the '<em>Contained Asset</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINED_ASSET_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Contained Asset</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINED_ASSET_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.VulnerabilityImpl <em>Vulnerability</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.VulnerabilityImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getVulnerability()
	 * @generated
	 */
	int VULNERABILITY = 9;

	/**
	 * The feature id for the '<em><b>Threat Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VULNERABILITY__THREAT_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Attacker Type</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VULNERABILITY__ATTACKER_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VULNERABILITY__REASONING = 2;

	/**
	 * The number of structural features of the '<em>Vulnerability</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VULNERABILITY_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Vulnerability</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VULNERABILITY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.AttackerImpl <em>Attacker</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.AttackerImpl
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getAttacker()
	 * @generated
	 */
	int ATTACKER = 10;

	/**
	 * The feature id for the '<em><b>Component Target</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTACKER__COMPONENT_TARGET = 0;

	/**
	 * The feature id for the '<em><b>Attacker Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTACKER__ATTACKER_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Data Flow Target</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTACKER__DATA_FLOW_TARGET = 2;

	/**
	 * The feature id for the '<em><b>Reasoning</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTACKER__REASONING = 3;

	/**
	 * The number of structural features of the '<em>Attacker</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTACKER_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Attacker</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTACKER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.STRIDEThreats <em>STRIDE Threats</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.STRIDEThreats
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getSTRIDEThreats()
	 * @generated
	 */
	int STRIDE_THREATS = 11;

	/**
	 * The meta object id for the '{@link de.uni.due.swe.dataFlowDiagramPattern.AttackerType <em>Attacker Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.uni.due.swe.dataFlowDiagramPattern.AttackerType
	 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getAttackerType()
	 * @generated
	 */
	int ATTACKER_TYPE = 12;


	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.DataStore <em>Data Store</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Store</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataStore
	 * @generated
	 */
	EClass getDataStore();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.ComplexProcess <em>Complex Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Complex Process</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.ComplexProcess
	 * @generated
	 */
	EClass getComplexProcess();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.ExternalEntity <em>External Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Entity</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.ExternalEntity
	 * @generated
	 */
	EClass getExternalEntity();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow <em>Data Flow</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Flow</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlow
	 * @generated
	 */
	EClass getDataFlow();

	/**
	 * Returns the meta object for the container reference '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Source</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getSource()
	 * @see #getDataFlow()
	 * @generated
	 */
	EReference getDataFlow_Source();

	/**
	 * Returns the meta object for the reference '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getTarget()
	 * @see #getDataFlow()
	 * @generated
	 */
	EReference getDataFlow_Target();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getName()
	 * @see #getDataFlow()
	 * @generated
	 */
	EAttribute getDataFlow_Name();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getElicitationReasoning <em>Elicitation Reasoning</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Elicitation Reasoning</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getElicitationReasoning()
	 * @see #getDataFlow()
	 * @generated
	 */
	EAttribute getDataFlow_ElicitationReasoning();

	/**
	 * Returns the meta object for the containment reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getContainedVulnerabilities <em>Contained Vulnerabilities</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contained Vulnerabilities</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getContainedVulnerabilities()
	 * @see #getDataFlow()
	 * @generated
	 */
	EReference getDataFlow_ContainedVulnerabilities();

	/**
	 * Returns the meta object for the containment reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getPossibleAttackers <em>Possible Attackers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Possible Attackers</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getPossibleAttackers()
	 * @see #getDataFlow()
	 * @generated
	 */
	EReference getDataFlow_PossibleAttackers();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.Process <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Process
	 * @generated
	 */
	EClass getProcess();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram <em>Data Flow Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Flow Diagram</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram
	 * @generated
	 */
	EClass getDataFlowDiagram();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram#getName()
	 * @see #getDataFlowDiagram()
	 * @generated
	 */
	EAttribute getDataFlowDiagram_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram#getContainedComponents <em>Contained Components</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contained Components</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram#getContainedComponents()
	 * @see #getDataFlowDiagram()
	 * @generated
	 */
	EReference getDataFlowDiagram_ContainedComponents();

	/**
	 * Returns the meta object for the containment reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram#getContainedPrivilegeBoundaries <em>Contained Privilege Boundaries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contained Privilege Boundaries</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram#getContainedPrivilegeBoundaries()
	 * @see #getDataFlowDiagram()
	 * @generated
	 */
	EReference getDataFlowDiagram_ContainedPrivilegeBoundaries();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.Component <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component
	 * @generated
	 */
	EClass getComponent();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getName()
	 * @see #getComponent()
	 * @generated
	 */
	EAttribute getComponent_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedDataFlows <em>Contained Data Flows</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contained Data Flows</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedDataFlows()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_ContainedDataFlows();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#isIsAsset <em>Is Asset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Asset</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#isIsAsset()
	 * @see #getComponent()
	 * @generated
	 */
	EAttribute getComponent_IsAsset();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getExternalDependency <em>External Dependency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>External Dependency</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getExternalDependency()
	 * @see #getComponent()
	 * @generated
	 */
	EAttribute getComponent_ExternalDependency();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getSecurityAssumptions <em>Security Assumptions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Security Assumptions</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getSecurityAssumptions()
	 * @see #getComponent()
	 * @generated
	 */
	EAttribute getComponent_SecurityAssumptions();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getSecurityNotes <em>Security Notes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Security Notes</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getSecurityNotes()
	 * @see #getComponent()
	 * @generated
	 */
	EAttribute getComponent_SecurityNotes();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getElicitationReasoning <em>Elicitation Reasoning</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Elicitation Reasoning</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getElicitationReasoning()
	 * @see #getComponent()
	 * @generated
	 */
	EAttribute getComponent_ElicitationReasoning();

	/**
	 * Returns the meta object for the reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedByPrivilegeBoundary <em>Contained By Privilege Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Contained By Privilege Boundary</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedByPrivilegeBoundary()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_ContainedByPrivilegeBoundary();

	/**
	 * Returns the meta object for the containment reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedVulnerabilities <em>Contained Vulnerabilities</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contained Vulnerabilities</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedVulnerabilities()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_ContainedVulnerabilities();

	/**
	 * Returns the meta object for the containment reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getPossibleAttackers <em>Possible Attackers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Possible Attackers</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getPossibleAttackers()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_PossibleAttackers();

	/**
	 * Returns the meta object for the containment reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedAssets <em>Contained Assets</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contained Assets</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedAssets()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_ContainedAssets();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary <em>Privilege Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Privilege Boundary</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary
	 * @generated
	 */
	EClass getPrivilegeBoundary();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary#getName()
	 * @see #getPrivilegeBoundary()
	 * @generated
	 */
	EAttribute getPrivilegeBoundary_Name();

	/**
	 * Returns the meta object for the reference list '{@link de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary#getComponetsWithin <em>Componets Within</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Componets Within</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary#getComponetsWithin()
	 * @see #getPrivilegeBoundary()
	 * @generated
	 */
	EReference getPrivilegeBoundary_ComponetsWithin();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset <em>Contained Asset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Contained Asset</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset
	 * @generated
	 */
	EClass getContainedAsset();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset#getReasoning <em>Reasoning</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reasoning</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset#getReasoning()
	 * @see #getContainedAsset()
	 * @generated
	 */
	EAttribute getContainedAsset_Reasoning();

	/**
	 * Returns the meta object for the reference '{@link de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset#getComponentAsset <em>Component Asset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component Asset</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset#getComponentAsset()
	 * @see #getContainedAsset()
	 * @generated
	 */
	EReference getContainedAsset_ComponentAsset();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.Vulnerability <em>Vulnerability</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Vulnerability</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Vulnerability
	 * @generated
	 */
	EClass getVulnerability();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Vulnerability#getThreatType <em>Threat Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Threat Type</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Vulnerability#getThreatType()
	 * @see #getVulnerability()
	 * @generated
	 */
	EAttribute getVulnerability_ThreatType();

	/**
	 * Returns the meta object for the attribute list '{@link de.uni.due.swe.dataFlowDiagramPattern.Vulnerability#getAttackerType <em>Attacker Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Attacker Type</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Vulnerability#getAttackerType()
	 * @see #getVulnerability()
	 * @generated
	 */
	EAttribute getVulnerability_AttackerType();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Vulnerability#getReasoning <em>Reasoning</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reasoning</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Vulnerability#getReasoning()
	 * @see #getVulnerability()
	 * @generated
	 */
	EAttribute getVulnerability_Reasoning();

	/**
	 * Returns the meta object for class '{@link de.uni.due.swe.dataFlowDiagramPattern.Attacker <em>Attacker</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attacker</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Attacker
	 * @generated
	 */
	EClass getAttacker();

	/**
	 * Returns the meta object for the container reference '{@link de.uni.due.swe.dataFlowDiagramPattern.Attacker#getComponentTarget <em>Component Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Component Target</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Attacker#getComponentTarget()
	 * @see #getAttacker()
	 * @generated
	 */
	EReference getAttacker_ComponentTarget();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Attacker#getAttackerType <em>Attacker Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Attacker Type</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Attacker#getAttackerType()
	 * @see #getAttacker()
	 * @generated
	 */
	EAttribute getAttacker_AttackerType();

	/**
	 * Returns the meta object for the container reference '{@link de.uni.due.swe.dataFlowDiagramPattern.Attacker#getDataFlowTarget <em>Data Flow Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Data Flow Target</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Attacker#getDataFlowTarget()
	 * @see #getAttacker()
	 * @generated
	 */
	EReference getAttacker_DataFlowTarget();

	/**
	 * Returns the meta object for the attribute '{@link de.uni.due.swe.dataFlowDiagramPattern.Attacker#getReasoning <em>Reasoning</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reasoning</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Attacker#getReasoning()
	 * @see #getAttacker()
	 * @generated
	 */
	EAttribute getAttacker_Reasoning();

	/**
	 * Returns the meta object for enum '{@link de.uni.due.swe.dataFlowDiagramPattern.STRIDEThreats <em>STRIDE Threats</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>STRIDE Threats</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.STRIDEThreats
	 * @generated
	 */
	EEnum getSTRIDEThreats();

	/**
	 * Returns the meta object for enum '{@link de.uni.due.swe.dataFlowDiagramPattern.AttackerType <em>Attacker Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Attacker Type</em>'.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.AttackerType
	 * @generated
	 */
	EEnum getAttackerType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DataFlowDiagramPatternFactory getDataFlowDiagramPatternFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.DataStoreImpl <em>Data Store</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataStoreImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getDataStore()
		 * @generated
		 */
		EClass DATA_STORE = eINSTANCE.getDataStore();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ComplexProcessImpl <em>Complex Process</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ComplexProcessImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getComplexProcess()
		 * @generated
		 */
		EClass COMPLEX_PROCESS = eINSTANCE.getComplexProcess();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ExternalEntityImpl <em>External Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ExternalEntityImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getExternalEntity()
		 * @generated
		 */
		EClass EXTERNAL_ENTITY = eINSTANCE.getExternalEntity();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowImpl <em>Data Flow</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getDataFlow()
		 * @generated
		 */
		EClass DATA_FLOW = eINSTANCE.getDataFlow();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_FLOW__SOURCE = eINSTANCE.getDataFlow_Source();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_FLOW__TARGET = eINSTANCE.getDataFlow_Target();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_FLOW__NAME = eINSTANCE.getDataFlow_Name();

		/**
		 * The meta object literal for the '<em><b>Elicitation Reasoning</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_FLOW__ELICITATION_REASONING = eINSTANCE.getDataFlow_ElicitationReasoning();

		/**
		 * The meta object literal for the '<em><b>Contained Vulnerabilities</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_FLOW__CONTAINED_VULNERABILITIES = eINSTANCE.getDataFlow_ContainedVulnerabilities();

		/**
		 * The meta object literal for the '<em><b>Possible Attackers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_FLOW__POSSIBLE_ATTACKERS = eINSTANCE.getDataFlow_PossibleAttackers();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ProcessImpl <em>Process</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ProcessImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getProcess()
		 * @generated
		 */
		EClass PROCESS = eINSTANCE.getProcess();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramImpl <em>Data Flow Diagram</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getDataFlowDiagram()
		 * @generated
		 */
		EClass DATA_FLOW_DIAGRAM = eINSTANCE.getDataFlowDiagram();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_FLOW_DIAGRAM__NAME = eINSTANCE.getDataFlowDiagram_Name();

		/**
		 * The meta object literal for the '<em><b>Contained Components</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_FLOW_DIAGRAM__CONTAINED_COMPONENTS = eINSTANCE.getDataFlowDiagram_ContainedComponents();

		/**
		 * The meta object literal for the '<em><b>Contained Privilege Boundaries</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_FLOW_DIAGRAM__CONTAINED_PRIVILEGE_BOUNDARIES = eINSTANCE.getDataFlowDiagram_ContainedPrivilegeBoundaries();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ComponentImpl <em>Component</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ComponentImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getComponent()
		 * @generated
		 */
		EClass COMPONENT = eINSTANCE.getComponent();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT__NAME = eINSTANCE.getComponent_Name();

		/**
		 * The meta object literal for the '<em><b>Contained Data Flows</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__CONTAINED_DATA_FLOWS = eINSTANCE.getComponent_ContainedDataFlows();

		/**
		 * The meta object literal for the '<em><b>Is Asset</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT__IS_ASSET = eINSTANCE.getComponent_IsAsset();

		/**
		 * The meta object literal for the '<em><b>External Dependency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT__EXTERNAL_DEPENDENCY = eINSTANCE.getComponent_ExternalDependency();

		/**
		 * The meta object literal for the '<em><b>Security Assumptions</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT__SECURITY_ASSUMPTIONS = eINSTANCE.getComponent_SecurityAssumptions();

		/**
		 * The meta object literal for the '<em><b>Security Notes</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT__SECURITY_NOTES = eINSTANCE.getComponent_SecurityNotes();

		/**
		 * The meta object literal for the '<em><b>Elicitation Reasoning</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT__ELICITATION_REASONING = eINSTANCE.getComponent_ElicitationReasoning();

		/**
		 * The meta object literal for the '<em><b>Contained By Privilege Boundary</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__CONTAINED_BY_PRIVILEGE_BOUNDARY = eINSTANCE.getComponent_ContainedByPrivilegeBoundary();

		/**
		 * The meta object literal for the '<em><b>Contained Vulnerabilities</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__CONTAINED_VULNERABILITIES = eINSTANCE.getComponent_ContainedVulnerabilities();

		/**
		 * The meta object literal for the '<em><b>Possible Attackers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__POSSIBLE_ATTACKERS = eINSTANCE.getComponent_PossibleAttackers();

		/**
		 * The meta object literal for the '<em><b>Contained Assets</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__CONTAINED_ASSETS = eINSTANCE.getComponent_ContainedAssets();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.PrivilegeBoundaryImpl <em>Privilege Boundary</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.PrivilegeBoundaryImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getPrivilegeBoundary()
		 * @generated
		 */
		EClass PRIVILEGE_BOUNDARY = eINSTANCE.getPrivilegeBoundary();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRIVILEGE_BOUNDARY__NAME = eINSTANCE.getPrivilegeBoundary_Name();

		/**
		 * The meta object literal for the '<em><b>Componets Within</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRIVILEGE_BOUNDARY__COMPONETS_WITHIN = eINSTANCE.getPrivilegeBoundary_ComponetsWithin();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.ContainedAssetImpl <em>Contained Asset</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.ContainedAssetImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getContainedAsset()
		 * @generated
		 */
		EClass CONTAINED_ASSET = eINSTANCE.getContainedAsset();

		/**
		 * The meta object literal for the '<em><b>Reasoning</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTAINED_ASSET__REASONING = eINSTANCE.getContainedAsset_Reasoning();

		/**
		 * The meta object literal for the '<em><b>Component Asset</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTAINED_ASSET__COMPONENT_ASSET = eINSTANCE.getContainedAsset_ComponentAsset();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.VulnerabilityImpl <em>Vulnerability</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.VulnerabilityImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getVulnerability()
		 * @generated
		 */
		EClass VULNERABILITY = eINSTANCE.getVulnerability();

		/**
		 * The meta object literal for the '<em><b>Threat Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VULNERABILITY__THREAT_TYPE = eINSTANCE.getVulnerability_ThreatType();

		/**
		 * The meta object literal for the '<em><b>Attacker Type</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VULNERABILITY__ATTACKER_TYPE = eINSTANCE.getVulnerability_AttackerType();

		/**
		 * The meta object literal for the '<em><b>Reasoning</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VULNERABILITY__REASONING = eINSTANCE.getVulnerability_Reasoning();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.impl.AttackerImpl <em>Attacker</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.AttackerImpl
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getAttacker()
		 * @generated
		 */
		EClass ATTACKER = eINSTANCE.getAttacker();

		/**
		 * The meta object literal for the '<em><b>Component Target</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTACKER__COMPONENT_TARGET = eINSTANCE.getAttacker_ComponentTarget();

		/**
		 * The meta object literal for the '<em><b>Attacker Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTACKER__ATTACKER_TYPE = eINSTANCE.getAttacker_AttackerType();

		/**
		 * The meta object literal for the '<em><b>Data Flow Target</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTACKER__DATA_FLOW_TARGET = eINSTANCE.getAttacker_DataFlowTarget();

		/**
		 * The meta object literal for the '<em><b>Reasoning</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTACKER__REASONING = eINSTANCE.getAttacker_Reasoning();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.STRIDEThreats <em>STRIDE Threats</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.STRIDEThreats
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getSTRIDEThreats()
		 * @generated
		 */
		EEnum STRIDE_THREATS = eINSTANCE.getSTRIDEThreats();

		/**
		 * The meta object literal for the '{@link de.uni.due.swe.dataFlowDiagramPattern.AttackerType <em>Attacker Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.uni.due.swe.dataFlowDiagramPattern.AttackerType
		 * @see de.uni.due.swe.dataFlowDiagramPattern.impl.DataFlowDiagramPatternPackageImpl#getAttackerType()
		 * @generated
		 */
		EEnum ATTACKER_TYPE = eINSTANCE.getAttackerType();

	}

} //DataFlowDiagramPatternPackage
