/**
 */
package de.uni.due.swe.dataFlowDiagramPattern;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Data Flow</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getSource <em>Source</em>}</li>
 *   <li>{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getTarget <em>Target</em>}</li>
 *   <li>{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getName <em>Name</em>}</li>
 *   <li>{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getElicitationReasoning <em>Elicitation Reasoning</em>}</li>
 *   <li>{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getContainedVulnerabilities <em>Contained Vulnerabilities</em>}</li>
 *   <li>{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getPossibleAttackers <em>Possible Attackers</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage#getDataFlow()
 * @model
 * @generated
 */
public interface DataFlow extends EObject {
	/**
	 * Returns the value of the '<em><b>Source</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedDataFlows <em>Contained Data Flows</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Source</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Source</em>' container reference.
	 * @see #setSource(Component)
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage#getDataFlow_Source()
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Component#getContainedDataFlows
	 * @model opposite="containedDataFlows" transient="false"
	 * @generated
	 */
	Component getSource();

	/**
	 * Sets the value of the '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getSource <em>Source</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source</em>' container reference.
	 * @see #getSource()
	 * @generated
	 */
	void setSource(Component value);

	/**
	 * Returns the value of the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Target</em>' reference.
	 * @see #setTarget(Component)
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage#getDataFlow_Target()
	 * @model
	 * @generated
	 */
	Component getTarget();

	/**
	 * Sets the value of the '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getTarget <em>Target</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target</em>' reference.
	 * @see #getTarget()
	 * @generated
	 */
	void setTarget(Component value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage#getDataFlow_Name()
	 * @model default=""
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Elicitation Reasoning</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Elicitation Reasoning</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Elicitation Reasoning</em>' attribute.
	 * @see #setElicitationReasoning(String)
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage#getDataFlow_ElicitationReasoning()
	 * @model default=""
	 * @generated
	 */
	String getElicitationReasoning();

	/**
	 * Sets the value of the '{@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow#getElicitationReasoning <em>Elicitation Reasoning</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Elicitation Reasoning</em>' attribute.
	 * @see #getElicitationReasoning()
	 * @generated
	 */
	void setElicitationReasoning(String value);

	/**
	 * Returns the value of the '<em><b>Contained Vulnerabilities</b></em>' containment reference list.
	 * The list contents are of type {@link de.uni.due.swe.dataFlowDiagramPattern.Vulnerability}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Contained Vulnerabilities</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Contained Vulnerabilities</em>' containment reference list.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage#getDataFlow_ContainedVulnerabilities()
	 * @model containment="true"
	 * @generated
	 */
	EList<Vulnerability> getContainedVulnerabilities();

	/**
	 * Returns the value of the '<em><b>Possible Attackers</b></em>' containment reference list.
	 * The list contents are of type {@link de.uni.due.swe.dataFlowDiagramPattern.Attacker}.
	 * It is bidirectional and its opposite is '{@link de.uni.due.swe.dataFlowDiagramPattern.Attacker#getDataFlowTarget <em>Data Flow Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Possible Attackers</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Possible Attackers</em>' containment reference list.
	 * @see de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage#getDataFlow_PossibleAttackers()
	 * @see de.uni.due.swe.dataFlowDiagramPattern.Attacker#getDataFlowTarget
	 * @model opposite="dataFlowTarget" containment="true"
	 * @generated
	 */
	EList<Attacker> getPossibleAttackers();

} // DataFlow
