/**
 */
package de.uni.due.swe.dataFlowDiagramPattern.provider;

import de.uni.due.swe.dataFlowDiagramPattern.util.DataFlowDiagramPatternAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DataFlowDiagramPatternItemProviderAdapterFactory extends DataFlowDiagramPatternAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataFlowDiagramPatternItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.DataStore} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataStoreItemProvider dataStoreItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.DataStore}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataStoreAdapter() {
		if (dataStoreItemProvider == null) {
			dataStoreItemProvider = new DataStoreItemProvider(this);
		}

		return dataStoreItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.ComplexProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComplexProcessItemProvider complexProcessItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.ComplexProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComplexProcessAdapter() {
		if (complexProcessItemProvider == null) {
			complexProcessItemProvider = new ComplexProcessItemProvider(this);
		}

		return complexProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.ExternalEntity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalEntityItemProvider externalEntityItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.ExternalEntity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExternalEntityAdapter() {
		if (externalEntityItemProvider == null) {
			externalEntityItemProvider = new ExternalEntityItemProvider(this);
		}

		return externalEntityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataFlowItemProvider dataFlowItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.DataFlow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataFlowAdapter() {
		if (dataFlowItemProvider == null) {
			dataFlowItemProvider = new DataFlowItemProvider(this);
		}

		return dataFlowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.Process} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessItemProvider processItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.Process}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessAdapter() {
		if (processItemProvider == null) {
			processItemProvider = new ProcessItemProvider(this);
		}

		return processItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataFlowDiagramItemProvider dataFlowDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataFlowDiagramAdapter() {
		if (dataFlowDiagramItemProvider == null) {
			dataFlowDiagramItemProvider = new DataFlowDiagramItemProvider(this);
		}

		return dataFlowDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrivilegeBoundaryItemProvider privilegeBoundaryItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrivilegeBoundaryAdapter() {
		if (privilegeBoundaryItemProvider == null) {
			privilegeBoundaryItemProvider = new PrivilegeBoundaryItemProvider(this);
		}

		return privilegeBoundaryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContainedAssetItemProvider containedAssetItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContainedAssetAdapter() {
		if (containedAssetItemProvider == null) {
			containedAssetItemProvider = new ContainedAssetItemProvider(this);
		}

		return containedAssetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.Vulnerability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VulnerabilityItemProvider vulnerabilityItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.Vulnerability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVulnerabilityAdapter() {
		if (vulnerabilityItemProvider == null) {
			vulnerabilityItemProvider = new VulnerabilityItemProvider(this);
		}

		return vulnerabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uni.due.swe.dataFlowDiagramPattern.Attacker} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttackerItemProvider attackerItemProvider;

	/**
	 * This creates an adapter for a {@link de.uni.due.swe.dataFlowDiagramPattern.Attacker}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttackerAdapter() {
		if (attackerItemProvider == null) {
			attackerItemProvider = new AttackerItemProvider(this);
		}

		return attackerItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (dataStoreItemProvider != null) dataStoreItemProvider.dispose();
		if (complexProcessItemProvider != null) complexProcessItemProvider.dispose();
		if (externalEntityItemProvider != null) externalEntityItemProvider.dispose();
		if (dataFlowItemProvider != null) dataFlowItemProvider.dispose();
		if (processItemProvider != null) processItemProvider.dispose();
		if (dataFlowDiagramItemProvider != null) dataFlowDiagramItemProvider.dispose();
		if (privilegeBoundaryItemProvider != null) privilegeBoundaryItemProvider.dispose();
		if (containedAssetItemProvider != null) containedAssetItemProvider.dispose();
		if (vulnerabilityItemProvider != null) vulnerabilityItemProvider.dispose();
		if (attackerItemProvider != null) attackerItemProvider.dispose();
	}

}
