package de.uni.due.swe.dfdp.design.views;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.uni.due.swe.dataFlowDiagramPattern.AttackerType;
import de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternFactory;
import de.uni.due.swe.dataFlowDiagramPattern.STRIDEThreats;
import de.uni.due.swe.dataFlowDiagramPattern.Vulnerability;

public class VulnerabilityDialog extends Dialog {
	private DataBindingContext m_bindingContext;
	private Text texVulnerability;
	private Vulnerability vulnerability;
	private Button btnSpoofing;
	private Button btnTampering;
	private Button btnInformationDisclosure;
	private Button btnDenialOfServices;
	private Button btnElevationOfPrivilege;
	private Button btnRedudiation;
	private Button btnNetworkAttacker;
	private Button btnPhysicalAttacker;
	private Button btnSoftwareAttacker;
	private Button btnSocialAttacker;

	/* Custom Variables */
	// TODO: Data bounding for these
	private boolean hasSpoofing;
	private boolean hasTampering;
	private boolean hasRepudiation;
	private boolean hasInformationDisclosure;
	private boolean hasDenialofService;
	private boolean hasElevationofPrivileges;

	private boolean hasNetworkAttacker;
	private boolean hasSoftwareAttacker;
	private boolean hasPhysicalAttacker;
	private boolean hasSocialAttacker;

	/**
	 * Create the dialog.
	 * 
	 * @param parentShell
	 * @wbp.parser.constructor
	 */
	public VulnerabilityDialog(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.TITLE | SWT.APPLICATION_MODAL);

		setVulnerability(DataFlowDiagramPatternFactory.eINSTANCE
				.createVulnerability());
	}

	/**
	 * Create the dialog.
	 * 
	 * @param parentShell
	 * @param vulnerability
	 */
	public VulnerabilityDialog(Shell parentShell, Vulnerability vul) {
		super(parentShell);
		setShellStyle(SWT.TITLE | SWT.APPLICATION_MODAL);

		setVulnerability(vul);
		initialPrivateVaules();
	}

	// protected void configureShell(Shell shell) {
	// super.configureShell(shell);
	// shell.setText("Vulnerability");
	// }

	private void initialPrivateVaules() {
		hasSpoofing = vulnerability.getThreatType().equals(
				STRIDEThreats.SPOOFING);
		hasTampering = vulnerability.getThreatType().equals(
				STRIDEThreats.TAMPERING);
		hasRepudiation = vulnerability.getThreatType().equals(
				STRIDEThreats.REPUDIATION);
		hasInformationDisclosure = vulnerability.getThreatType().equals(
				STRIDEThreats.INFORMATION_DISCLOSURE);
		hasDenialofService = vulnerability.getThreatType().equals(
				STRIDEThreats.DENIALOF_SERVICES);
		hasElevationofPrivileges = vulnerability.getThreatType().equals(
				STRIDEThreats.ELEVATIONOF_PRIVILEGES);

		hasNetworkAttacker = vulnerability.getAttackerType().contains(
				AttackerType.NETWORK_ATTACKER);
		hasSoftwareAttacker = vulnerability.getAttackerType().contains(
				AttackerType.SOFTWARE_ATTACKER);
		hasPhysicalAttacker = vulnerability.getAttackerType().contains(
				AttackerType.PHYSICAL_ATTACKER);
		hasSocialAttacker = vulnerability.getAttackerType().contains(
				AttackerType.SOCIAL_ATTACKER);
	}

	/**
	 * Create contents of the dialog.
	 * 
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(null);

		Group grpThreatType = new Group(container, SWT.NONE);
		grpThreatType.setText("Threat Type");
		grpThreatType.setBounds(10, 10, 493, 71);

		btnSpoofing = new Button(grpThreatType, SWT.RADIO);
		btnSpoofing.setBounds(10, 23, 90, 16);
		btnSpoofing.setText("Spoofing");

		btnTampering = new Button(grpThreatType, SWT.RADIO);
		btnTampering.setBounds(10, 45, 90, 16);
		btnTampering.setText("Tampering");

		btnRedudiation = new Button(grpThreatType, SWT.RADIO);
		btnRedudiation.setBounds(352, 45, 90, 16);
		btnRedudiation.setText("Redudiation");

		btnInformationDisclosure = new Button(grpThreatType, SWT.RADIO);
		btnInformationDisclosure.setBounds(172, 23, 141, 16);
		btnInformationDisclosure.setText("Information Disclosure");

		btnElevationOfPrivilege = new Button(grpThreatType, SWT.RADIO);
		btnElevationOfPrivilege.setBounds(352, 23, 131, 16);
		btnElevationOfPrivilege.setText("Elevation of Privilege");

		btnDenialOfServices = new Button(grpThreatType, SWT.RADIO);
		btnDenialOfServices.setBounds(172, 45, 141, 16);
		btnDenialOfServices.setText("Denial of Services");

		Group grpAttackerType = new Group(container, SWT.NONE);
		grpAttackerType.setText("Attacker Type");
		grpAttackerType.setBounds(10, 90, 493, 71);

		btnNetworkAttacker = new Button(grpAttackerType, SWT.CHECK);
		btnNetworkAttacker.setBounds(10, 21, 124, 16);
		btnNetworkAttacker.setText("Network Attacker");

		btnSoftwareAttacker = new Button(grpAttackerType, SWT.CHECK);
		btnSoftwareAttacker.setBounds(10, 43, 124, 16);
		btnSoftwareAttacker.setText("Software Attacker");

		btnPhysicalAttacker = new Button(grpAttackerType, SWT.CHECK);
		btnPhysicalAttacker.setBounds(171, 21, 111, 16);
		btnPhysicalAttacker.setText("Physical Attacker");

		btnSocialAttacker = new Button(grpAttackerType, SWT.CHECK);
		btnSocialAttacker.setBounds(171, 43, 111, 16);
		btnSocialAttacker.setText("Social Attacker");

		Group grpReasoning = new Group(container, SWT.NONE);
		grpReasoning.setText("Reasoning");
		grpReasoning.setBounds(10, 167, 493, 175);

		texVulnerability = new Text(grpReasoning, SWT.BORDER | SWT.MULTI);
		texVulnerability.setBounds(10, 21, 473, 144);

		/* Begin of Custom Code */

		btnSpoofing.setSelection(hasSpoofing);
		btnTampering.setSelection(hasTampering);
		btnRedudiation.setSelection(hasRepudiation);
		btnInformationDisclosure.setSelection(hasInformationDisclosure);
		btnElevationOfPrivilege.setSelection(hasElevationofPrivileges);
		btnDenialOfServices.setSelection(hasDenialofService);

		btnNetworkAttacker.setSelection(hasNetworkAttacker);
		btnSoftwareAttacker.setSelection(hasSoftwareAttacker);
		btnPhysicalAttacker.setSelection(hasPhysicalAttacker);
		btnSocialAttacker.setSelection(hasSocialAttacker);

		/* End of Custom Code */
		return container;
	}

	/**
	 * Create contents of the button bar.
	 * 
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		Button button = createButton(parent, IDialogConstants.OK_ID,
				IDialogConstants.OK_LABEL, true);
		button.setText("Save");
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
		m_bindingContext = initDataBindings();
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(519, 421);
	}

	/**
	 * @return the vulnerability
	 */
	public Vulnerability getVulnerability() {
		return vulnerability;
	}

	/**
	 * @param vulnerability
	 *            the vulnerability to set
	 */
	public void setVulnerability(Vulnerability vulnerability) {
		this.vulnerability = vulnerability;
	}

	private void saveInput() {
		if (btnSpoofing.getSelection()) {
			vulnerability.setThreatType(STRIDEThreats.SPOOFING);
		} else if (btnTampering.getSelection()) {
			vulnerability.setThreatType(STRIDEThreats.TAMPERING);
		} else if (btnInformationDisclosure.getSelection()) {
			vulnerability.setThreatType(STRIDEThreats.INFORMATION_DISCLOSURE);
		} else if (btnDenialOfServices.getSelection()) {
			vulnerability.setThreatType(STRIDEThreats.DENIALOF_SERVICES);
		} else if (btnElevationOfPrivilege.getSelection()) {
			vulnerability.setThreatType(STRIDEThreats.ELEVATIONOF_PRIVILEGES);
		} else if (btnRedudiation.getSelection()) {
			vulnerability.setThreatType(STRIDEThreats.REPUDIATION);
		}

		if (btnNetworkAttacker.getSelection() & !hasNetworkAttacker) {
			vulnerability.getAttackerType().add(AttackerType.NETWORK_ATTACKER);
		} else if (!btnNetworkAttacker.getSelection() & hasNetworkAttacker) {
			vulnerability.getAttackerType().remove(
					AttackerType.NETWORK_ATTACKER_VALUE);
		}

		if (btnSoftwareAttacker.getSelection() & !hasSoftwareAttacker) {
			vulnerability.getAttackerType().add(AttackerType.SOFTWARE_ATTACKER);
		} else if (!btnSoftwareAttacker.getSelection() & hasSoftwareAttacker) {
			vulnerability.getAttackerType().remove(
					AttackerType.SOFTWARE_ATTACKER);
		}

		if (btnPhysicalAttacker.getSelection() & !hasPhysicalAttacker) {
			vulnerability.getAttackerType().add(AttackerType.PHYSICAL_ATTACKER);
		} else if (!btnPhysicalAttacker.getSelection() & hasPhysicalAttacker) {
			vulnerability.getAttackerType().remove(
					AttackerType.PHYSICAL_ATTACKER);
		}

		if (btnSocialAttacker.getSelection() & !hasSocialAttacker) {
			vulnerability.getAttackerType().add(AttackerType.SOCIAL_ATTACKER);
		} else if (!btnSocialAttacker.getSelection() & hasSocialAttacker) {
			vulnerability.getAttackerType()
					.remove(AttackerType.SOCIAL_ATTACKER);
		}

	}

	@Override
	protected void okPressed() {
		saveInput();
		super.okPressed();
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTexVulnerabilityObserveWidget = WidgetProperties
				.text(SWT.Modify).observe(texVulnerability);
		IObservableValue reasoningVulnerabilityObserveValue = PojoProperties
				.value("reasoning").observe(vulnerability);
		bindingContext.bindValue(observeTextTexVulnerabilityObserveWidget,
				reasoningVulnerabilityObserveValue, null, null);
		//
		return bindingContext;
	}
}
