package de.uni.due.swe.dfdp.design.views;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

import de.uni.due.swe.dataFlowDiagramPattern.Attacker;
import de.uni.due.swe.dataFlowDiagramPattern.Component;
import de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage;
import de.uni.due.swe.dataFlowDiagramPattern.Vulnerability;

public class EditComponentView {
	private Text textComponentName;
	private Text textExternalDependency;
	private Text textSecurityAssumptions;
	private Text textSecurityNotes;
	private Table tableContainAssets;

	private Component component;
	private Button btnCBComponentIsAsset;
	private TableViewer tableViewerAttackers;
	private Table tableAttackers;
	private Table tableVulnerabilities;
	private TableViewer tableViewerVulnerabilities;
	private TableViewer tableViewerContainedAssets;

	/**
	 * Launch the application.
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		Display display = Display.getDefault();
		Realm.runWithDefault(SWTObservables.getRealm(display), new Runnable() {
			public void run() {
				try {
					EditComponentView window = new EditComponentView();
					window.open();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Constructor with parameter
	 * 
	 * @param Component
	 *            comp
	 * 
	 */
	public EditComponentView(Component comp) {
		component = comp;
		// Add Component Listener
		component.eAdapters().add(componentObserver);
	}

	/**
	 * Default Constructor
	 * */
	public EditComponentView() {

	}

	EContentAdapter componentObserver = new EContentAdapter() {
		public void notifyChanged(Notification notification) {
			// System.out
			// .println("Notfication received from the data model. Data model has changed!!!");
			// Update TableViewer
			tableViewerAttackers.refresh();
			tableViewerVulnerabilities.refresh();
			tableViewerContainedAssets.refresh();
		}
	};

	/**
	 * The content provider class is responsible for providing objects to the
	 * view. It can wrap existing objects in adapters or simply return objects
	 * as-is. These objects may be sensitive to the current input of the view,
	 * or ignore it and always show the same content (like Task List, for
	 * example).
	 */
	class ContainedAssetsTableViewContentProvider implements
			IStructuredContentProvider {
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}

		public void dispose() {
		}

		public Object[] getElements(Object parent) {
			if (parent instanceof Component) {
				// Contained assets will shown in the TableView
				return ((Component) parent).getContainedAssets().toArray();
			}
			return new Object[0];
		}
	}

	class ContainedAssetsTableViewLabelProvider extends LabelProvider implements
			ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
			if (obj instanceof Component) {
				// Component ce = (Component) obj;
				if (index == 0) {
					return ((Component) obj).getName();
				}
			}
			return null;
		}

		public Image getColumnImage(Object obj, int index) {
			return getImage(obj);
		}

		public Image getImage(Object obj) {
			// return PlatformUI.getWorkbench().getSharedImages()
			// .getImage(ISharedImages.IMG_OBJ_ELEMENT);
			return null;
		}
	}

	class ContainedVulnerabilitiesTableViewContentProvider implements
			IStructuredContentProvider {
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}

		public void dispose() {
		}

		public Object[] getElements(Object parent) {
			if (parent instanceof Component) {
				// Contained assets will shown in the TableView
				return ((Component) parent).getContainedVulnerabilities()
						.toArray();
			}
			return new Object[0];
		}
	}

	class ContainedVulnerabilitiesTableViewLabelProvider extends LabelProvider
			implements ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
			if (obj instanceof Vulnerability) {
				// Component ce = (Component) obj;
				if (index == 0) { /* First Column is Threat Type */
					return ((Vulnerability) obj).getThreatType().getLiteral();
				} else if (index == 1) { /* Second Column is Attacker Type */
					return ((Vulnerability) obj).getAttackerType().toString();
				} else if (index == 2) { /* Third Column is Reasoning */
					return ((Vulnerability) obj).getReasoning();
				}
			}
			return null;
		}

		public Image getColumnImage(Object obj, int index) {
			return getImage(obj);
		}

		public Image getImage(Object obj) {
			// return PlatformUI.getWorkbench().getSharedImages()
			// .getImage(ISharedImages.IMG_OBJ_ELEMENT);
			return null;
		}
	}

	class AttackersTableViewContentProvider implements
			IStructuredContentProvider {
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}

		public void dispose() {
		}

		public Object[] getElements(Object parent) {
			if (parent instanceof Component) {
				// Contained assets will shown in the TableView
				return ((Component) parent).getPossibleAttackers().toArray();
			}
			return new Object[0];
		}
	}

	class AttackersTableViewLabelProvider extends LabelProvider implements
			ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
			if (obj instanceof Attacker) {
				// Component ce = (Component) obj;
				if (index == 0) { /* First Column is Attacker Type */
					return ((Attacker) obj).getAttackerType().getLiteral();
				} else if (index == 1) { /* Second Column is Reasoning */
					return ((Attacker) obj).getReasoning();
				}
			}
			return null;
		}

		public Image getColumnImage(Object obj, int index) {
			return getImage(obj);
		}

		public Image getImage(Object obj) {
			// return PlatformUI.getWorkbench().getSharedImages()
			// .getImage(ISharedImages.IMG_OBJ_ELEMENT);
			return null;
		}
	}

	/**
	 * Open the window.
	 */
	public void open() {
		Display display = Display.getDefault();
		final Shell shlEditComponet = new Shell();
		shlEditComponet.setSize(599, 623);
		shlEditComponet.setText("Edit Componet");
		shlEditComponet.setLayout(null);

		Button btnCancel = new Button(shlEditComponet, SWT.NONE);
		btnCancel.setBounds(487, 550, 75, 25);
		btnCancel.setText("Cancel");

		Button btnSave = new Button(shlEditComponet, SWT.NONE);
		btnSave.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// Delete Component Listener
				// component.eAdapters().clear();
				SaveInput();
				// shlEditComponet.close();
			}
		});
		btnSave.setBounds(406, 550, 75, 25);
		btnSave.setText("Save");

		Label lblName = new Label(shlEditComponet, SWT.NONE);
		lblName.setBounds(10, 10, 40, 15);
		lblName.setText("Name:");

		textComponentName = new Text(shlEditComponet, SWT.BORDER);
		textComponentName.setBounds(56, 7, 127, 21);

		btnCBComponentIsAsset = new Button(shlEditComponet, SWT.CHECK);
		btnCBComponentIsAsset.setBounds(10, 46, 68, 16);
		btnCBComponentIsAsset.setText("Is Asset ?");

		Label label = new Label(shlEditComponet, SWT.SEPARATOR | SWT.HORIZONTAL);
		label.setBounds(1, 531, 582, 2);

		CTabFolder tabFolder = new CTabFolder(shlEditComponet, SWT.NONE);
		tabFolder.setBounds(10, 84, 563, 441);
		tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(
				SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));

		CTabItem tbtmExternalDependency = new CTabItem(tabFolder, SWT.NONE);
		tbtmExternalDependency.setText("External Dependency");

		textExternalDependency = new Text(tabFolder, SWT.BORDER | SWT.V_SCROLL
				| SWT.MULTI);
		tbtmExternalDependency.setControl(textExternalDependency);

		CTabItem tbtmSecurityAssumptions = new CTabItem(tabFolder, SWT.NONE);
		tbtmSecurityAssumptions.setText("Security Assumptions");

		textSecurityAssumptions = new Text(tabFolder, SWT.BORDER | SWT.V_SCROLL
				| SWT.MULTI);
		tbtmSecurityAssumptions.setControl(textSecurityAssumptions);

		CTabItem tbtmSecurityNotes = new CTabItem(tabFolder, SWT.NONE);
		tbtmSecurityNotes.setText("Security Notes");

		textSecurityNotes = new Text(tabFolder, SWT.BORDER);
		tbtmSecurityNotes.setControl(textSecurityNotes);

		CTabItem tbtmAsset = new CTabItem(tabFolder, SWT.NONE);
		tbtmAsset.setText("Asset");

		Composite compositeAsset = new Composite(tabFolder, SWT.NONE);
		tbtmAsset.setControl(compositeAsset);

		Group groupContainedAssets = new Group(compositeAsset, SWT.NONE);
		groupContainedAssets.setText("Contained Assets");
		groupContainedAssets.setToolTipText("Contained Assets");
		groupContainedAssets.setBounds(0, 10, 549, 393);

		tableViewerContainedAssets = new TableViewer(groupContainedAssets,
				SWT.BORDER | SWT.FULL_SELECTION);
		tableContainAssets = tableViewerContainedAssets.getTable();
		tableContainAssets.setLinesVisible(true);
		tableContainAssets.setHeaderVisible(true);
		tableContainAssets.setLocation(10, 23);
		tableContainAssets.setSize(453, 190);

		TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(
				tableViewerContainedAssets, SWT.NONE);
		TableColumn tblclmnAssetReasoning = tableViewerColumn_6.getColumn();
		tblclmnAssetReasoning.setWidth(243);
		tblclmnAssetReasoning.setText("Reasoning");

		Button btnAddAsset = new Button(groupContainedAssets, SWT.NONE);
		btnAddAsset.setBounds(469, 23, 75, 25);
		btnAddAsset.setText("Add");

		Button btnDeleteAsset = new Button(groupContainedAssets, SWT.NONE);
		btnDeleteAsset.setBounds(469, 54, 75, 25);
		btnDeleteAsset.setText("Delete");

		Button btnEditAsset = new Button(groupContainedAssets, SWT.NONE);
		btnEditAsset.setBounds(469, 84, 75, 25);
		btnEditAsset.setText("Edit");

		CTabItem tbtmVulnerabilities = new CTabItem(tabFolder, SWT.NONE);
		tbtmVulnerabilities.setText("Vulnerabilities");

		Composite compositeVulnerabilities = new Composite(tabFolder, SWT.NONE);
		tbtmVulnerabilities.setControl(compositeVulnerabilities);

		tableViewerVulnerabilities = new TableViewer(compositeVulnerabilities,
				SWT.BORDER | SWT.FULL_SELECTION);
		tableVulnerabilities = tableViewerVulnerabilities.getTable();
		tableVulnerabilities.setLinesVisible(true);
		tableVulnerabilities.setHeaderVisible(true);
		tableVulnerabilities.setBounds(0, 0, 471, 413);

		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(
				tableViewerVulnerabilities, SWT.NONE);
		TableColumn tblclmnThreatType = tableViewerColumn_1.getColumn();
		tblclmnThreatType.setWidth(100);
		tblclmnThreatType.setText("Threat Type");

		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(
				tableViewerVulnerabilities, SWT.NONE);
		TableColumn tblclmnAttackerType = tableViewerColumn_2.getColumn();
		tblclmnAttackerType.setWidth(100);
		tblclmnAttackerType.setText("Attacker Type");

		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(
				tableViewerVulnerabilities, SWT.NONE);
		TableColumn tblclmnReasoning = tableViewerColumn_3.getColumn();
		tblclmnReasoning.setWidth(100);
		tblclmnReasoning.setText("Reasoning");

		Button btnAddVulnerability = new Button(compositeVulnerabilities,
				SWT.NONE);
		btnAddVulnerability.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (component != null) {
					VulnerabilityDialog VulDlg = new VulnerabilityDialog(
							shlEditComponet);
					VulDlg.create();
					if (VulDlg.open() == Window.OK) {
						if (VulDlg.getVulnerability() != null) {
							component.getContainedVulnerabilities().add(
									VulDlg.getVulnerability());
						}
					}
				}
			}
		});
		btnAddVulnerability.setBounds(477, 10, 75, 25);
		btnAddVulnerability.setText("Add");

		Button btnDeleteVulnerability = new Button(compositeVulnerabilities,
				SWT.NONE);
		btnDeleteVulnerability.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] itemlist = tableVulnerabilities.getSelection();
				for (TableItem item : itemlist) {
					if (item.getData() instanceof Vulnerability) {
						removeVulnerability((Vulnerability) item.getData());
					}
				}
			}
		});
		btnDeleteVulnerability.setBounds(477, 41, 75, 25);
		btnDeleteVulnerability.setText("Delete");

		Button btnEditVulnerability = new Button(compositeVulnerabilities,
				SWT.NONE);
		btnEditVulnerability.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] itemlist = tableVulnerabilities.getSelection();
				for (TableItem item : itemlist) {
					if (item.getData() instanceof Vulnerability) {
						VulnerabilityDialog VulDlg = new VulnerabilityDialog(
								shlEditComponet, (Vulnerability) item.getData());
						VulDlg.create();
						if (VulDlg.open() == Window.OK) {
							// if (VulDlg.getVulnerability() != null) {
							// item.setData(VulDlg.getVulnerability());
							// }
						}
					}
				}
			}
		});
		btnEditVulnerability.setBounds(477, 72, 75, 25);
		btnEditVulnerability.setText("Edit");

		CTabItem tbtmAttackers = new CTabItem(tabFolder, SWT.NONE);
		tbtmAttackers.setText("Attackers");

		Composite compositeAttackers = new Composite(tabFolder, SWT.NONE);
		tbtmAttackers.setControl(compositeAttackers);

		tableViewerAttackers = new TableViewer(compositeAttackers, SWT.BORDER
				| SWT.FULL_SELECTION);
		tableAttackers = tableViewerAttackers.getTable();
		tableAttackers.setLinesVisible(true);
		tableAttackers.setHeaderVisible(true);
		tableAttackers.setBounds(0, 0, 471, 413);

		TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(
				tableViewerAttackers, SWT.NONE);
		TableColumn tblclmnAttackerType_1 = tableViewerColumn_4.getColumn();
		tblclmnAttackerType_1.setWidth(147);
		tblclmnAttackerType_1.setText("Attacker Type");

		TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(
				tableViewerAttackers, SWT.NONE);
		TableColumn tblclmnReasoning_1 = tableViewerColumn_5.getColumn();
		tblclmnReasoning_1.setMoveable(true);
		tblclmnReasoning_1.setWidth(314);
		tblclmnReasoning_1.setText("Reasoning");

		Button btnAddAttacker = new Button(compositeAttackers, SWT.NONE);
		btnAddAttacker.setBounds(477, 10, 75, 25);
		btnAddAttacker.setText("Add");

		Button btnDeleteAttacker = new Button(compositeAttackers, SWT.NONE);
		btnDeleteAttacker.setBounds(477, 41, 75, 25);
		btnDeleteAttacker.setText("Delete");

		/* Begin Custom Initialization Code */

		textComponentName.setText(component.getName());
		btnCBComponentIsAsset.setSelection(component.isIsAsset());
		textExternalDependency.setText(component.getExternalDependency());
		textSecurityAssumptions.setText(component.getSecurityAssumptions());
		textSecurityNotes.setText(component.getSecurityNotes());

		InitialTableView();

		/* End Custom Initialization Code */

		shlEditComponet.open();
		shlEditComponet.layout();
		while (!shlEditComponet.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	private void InitialTableView() {
		tableViewerContainedAssets
				.setLabelProvider(new ContainedAssetsTableViewLabelProvider());
		tableViewerContainedAssets
				.setContentProvider(new ContainedAssetsTableViewContentProvider());
		tableViewerContainedAssets.setInput(component);

		tableViewerVulnerabilities
				.setLabelProvider(new ContainedVulnerabilitiesTableViewLabelProvider());
		tableViewerVulnerabilities
				.setContentProvider(new ContainedVulnerabilitiesTableViewContentProvider());
		tableViewerVulnerabilities.setInput(component);

		tableViewerAttackers
				.setLabelProvider(new AttackersTableViewLabelProvider());
		tableViewerAttackers
				.setContentProvider(new AttackersTableViewContentProvider());
		tableViewerAttackers.setInput(component);
	}

	private void removeVulnerability(Vulnerability vul) {
		// remove a Vulnerability from a component using a Command

		EditingDomain editingDomain = AdapterFactoryEditingDomain
				.getEditingDomainFor(component);
		Command command = RemoveCommand.create(editingDomain, component,
				DataFlowDiagramPatternPackage.eINSTANCE
						.getComponent_ContainedVulnerabilities(), vul);
		editingDomain.getCommandStack().execute(command);
	}

	private void SaveInput() {
		component.setName(textComponentName.getText());
		component.setIsAsset(btnCBComponentIsAsset.getSelection());
		component.setExternalDependency(textExternalDependency.getText());
		component.setSecurityAssumptions(textSecurityAssumptions.getText());
		component.setSecurityNotes(textSecurityNotes.getText());
	}
}
