package de.uni.due.swe.dfdp.design.views;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

import de.uni.due.swe.dataFlowDiagramPattern.Attacker;
import de.uni.due.swe.dataFlowDiagramPattern.Component;
import de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset;
import de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram;
import de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternPackage;
import de.uni.due.swe.dataFlowDiagramPattern.Vulnerability;

public class ComponentDialog extends Dialog {
	private Text textComponentName;
	private Text textExternalDependency;
	private Text textSecurityAssumptions;
	private Text textSecurityNotes;
	private Table tableVulnerabilities;
	private Table tableAttackers;
	private Table tableContainedAssets;
	private TableViewer tableViewerVulnerabilities;
	private TableViewer tableViewerAttackers;
	private TableViewer tableViewerContainedAssets;
	private Button btnComponentIsAsset;

	private Component component;
	private Shell localShell;
	private EList<Component> allComponents;

	/**
	 * @return the component
	 */
	public Component getComponent() {
		return component;
	}

	/**
	 * @param component
	 *            the component to set
	 */
	public void setComponent(Component component) {
		this.component = component;

		/*
		 * A dirty way to get all the Components in the current Data Flow
		 * Diagram
		 */
		allComponents = ((DataFlowDiagram) component.eContainer())
				.getContainedComponents();
	}

	/**
	 * Create the dialog.
	 * 
	 * @param parentShell
	 * @wbp.parser.constructor
	 */
	public ComponentDialog(Shell parentShell) {
		super(parentShell);
		localShell = parentShell;
	}

	/*
	 * Create the dialog with extra parameter
	 */
	public ComponentDialog(Shell parentShell, Component component) {
		super(parentShell);
		localShell = parentShell;
		setComponent(component);
		// Add Component Listener
		// getComponent().eAdapters().add(componentObserver);
	}

	EContentAdapter componentObserver = new EContentAdapter() {
		public void notifyChanged(Notification notification) {
			// Update TableViewer
			// tableViewerAttackers.refresh();
			tableViewerVulnerabilities.refresh();
			// tableViewerContainedAssets.refresh();
		}
	};

	/**
	 * The content provider class is responsible for providing objects to the
	 * view. It can wrap existing objects in adapters or simply return objects
	 * as-is. These objects may be sensitive to the current input of the view,
	 * or ignore it and always show the same content (like Task List, for
	 * example).
	 */
	class ContainedAssetsTableViewContentProvider implements
			IStructuredContentProvider {
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}

		public void dispose() {
		}

		public Object[] getElements(Object parent) {
			if (parent instanceof Component) {
				// Contained assets will shown in the TableView
				return ((Component) parent).getContainedAssets().toArray();
			}
			return new Object[0];
		}
	}

	class ContainedAssetsTableViewLabelProvider extends LabelProvider implements
			ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
			if (obj instanceof ContainedAsset) {
				// Component ce = (Component) obj;
				if (index == 0) {
					return ((ContainedAsset) obj).getComponentAsset().getName();
				} else if (index == 1) {
					return ((ContainedAsset) obj).getReasoning();
				}
			}
			return null;
		}

		public Image getColumnImage(Object obj, int index) {
			return getImage(obj);
		}

		public Image getImage(Object obj) {
			// return PlatformUI.getWorkbench().getSharedImages()
			// .getImage(ISharedImages.IMG_OBJ_ELEMENT);
			return null;
		}
	}

	class ContainedVulnerabilitiesTableViewContentProvider implements
			IStructuredContentProvider {
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}

		public void dispose() {
		}

		public Object[] getElements(Object parent) {
			if (parent instanceof Component) {
				// Contained assets will shown in the TableView
				return ((Component) parent).getContainedVulnerabilities()
						.toArray();
			}
			return new Object[0];
		}
	}

	class ContainedVulnerabilitiesTableViewLabelProvider extends LabelProvider
			implements ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
			if (obj instanceof Vulnerability) {
				// Component ce = (Component) obj;
				if (index == 0) { /* First Column is Threat Type */
					return ((Vulnerability) obj).getThreatType().getLiteral();
				} else if (index == 1) { /* Second Column is Attacker Type */
					return ((Vulnerability) obj).getAttackerType().toString();
				} else if (index == 2) { /* Third Column is Reasoning */
					return ((Vulnerability) obj).getReasoning();
				}
			}
			return null;
		}

		public Image getColumnImage(Object obj, int index) {
			return getImage(obj);
		}

		public Image getImage(Object obj) {
			// return PlatformUI.getWorkbench().getSharedImages()
			// .getImage(ISharedImages.IMG_OBJ_ELEMENT);
			return null;
		}
	}

	class AttackersTableViewContentProvider implements
			IStructuredContentProvider {
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}

		public void dispose() {
		}

		public Object[] getElements(Object parent) {
			if (parent instanceof Component) {
				// Contained assets will shown in the TableView
				return ((Component) parent).getPossibleAttackers().toArray();
			}
			return new Object[0];
		}
	}

	class AttackersTableViewLabelProvider extends LabelProvider implements
			ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
			if (obj instanceof Attacker) {
				// Component ce = (Component) obj;
				if (index == 0) { /* First Column is Attacker Type */
					return ((Attacker) obj).getAttackerType().getLiteral();
				} else if (index == 1) { /* Second Column is Reasoning */
					return ((Attacker) obj).getReasoning();
				}
			}
			return null;
		}

		public Image getColumnImage(Object obj, int index) {
			return getImage(obj);
		}

		public Image getImage(Object obj) {
			// return PlatformUI.getWorkbench().getSharedImages()
			// .getImage(ISharedImages.IMG_OBJ_ELEMENT);
			return null;
		}
	}

	/**
	 * Create contents of the dialog.
	 * 
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(null);

		Label lblComponentName = new Label(container, SWT.NONE);
		lblComponentName.setBounds(10, 13, 40, 15);
		lblComponentName.setText("Name:");

		textComponentName = new Text(container, SWT.BORDER);
		textComponentName.setBounds(54, 10, 150, 21);

		btnComponentIsAsset = new Button(container, SWT.CHECK);
		btnComponentIsAsset.setBounds(10, 39, 93, 16);
		btnComponentIsAsset.setText("Is Asset ?");

		CTabFolder tabFolder = new CTabFolder(container, SWT.BORDER);
		tabFolder.setBounds(0, 61, 723, 461);
		tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(
				SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));

		CTabItem tbtmExternalDependency = new CTabItem(tabFolder, SWT.NONE);
		tbtmExternalDependency.setText("External Dependency");

		textExternalDependency = new Text(tabFolder, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.CANCEL | SWT.MULTI);
		tbtmExternalDependency.setControl(textExternalDependency);

		CTabItem tbtmSecurityAssumptions = new CTabItem(tabFolder, SWT.NONE);
		tbtmSecurityAssumptions.setText("Security Assumptions");

		textSecurityAssumptions = new Text(tabFolder, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.CANCEL | SWT.MULTI);
		tbtmSecurityAssumptions.setControl(textSecurityAssumptions);

		CTabItem tbtmSecurityNotes = new CTabItem(tabFolder, SWT.NONE);
		tbtmSecurityNotes.setText("Security Notes");

		textSecurityNotes = new Text(tabFolder, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.CANCEL | SWT.MULTI);
		tbtmSecurityNotes.setControl(textSecurityNotes);

		CTabItem tbtmVulnerabilities = new CTabItem(tabFolder, SWT.NONE);
		tbtmVulnerabilities.setText("Vulnerabilities");

		Composite compositeVulnerability = new Composite(tabFolder, SWT.NONE);
		tbtmVulnerabilities.setControl(compositeVulnerability);

		tableViewerVulnerabilities = new TableViewer(compositeVulnerability,
				SWT.BORDER | SWT.FULL_SELECTION);
		tableVulnerabilities = tableViewerVulnerabilities.getTable();
		tableVulnerabilities.setLinesVisible(true);
		tableVulnerabilities.setHeaderVisible(true);
		tableVulnerabilities.setBounds(0, 0, 629, 432);

		TableViewerColumn tableViewerColumn = new TableViewerColumn(
				tableViewerVulnerabilities, SWT.NONE);
		TableColumn tblclmnVulnerabilityThreatType = tableViewerColumn
				.getColumn();
		tblclmnVulnerabilityThreatType.setWidth(100);
		tblclmnVulnerabilityThreatType.setText("Threat Type");

		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(
				tableViewerVulnerabilities, SWT.NONE);
		TableColumn tblclmnVulnerabilityAttackerType = tableViewerColumn_1
				.getColumn();
		tblclmnVulnerabilityAttackerType.setWidth(100);
		tblclmnVulnerabilityAttackerType.setText("Attacker Type");

		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(
				tableViewerVulnerabilities, SWT.NONE);
		TableColumn tblclmnVulnerabilityReasoning = tableViewerColumn_2
				.getColumn();
		tblclmnVulnerabilityReasoning.setWidth(100);
		tblclmnVulnerabilityReasoning.setText("Reasoning");

		Button btnAddVulnerability = new Button(compositeVulnerability,
				SWT.NONE);
		btnAddVulnerability.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (getComponent() != null) {
					VulnerabilityDialog VulDlg = new VulnerabilityDialog(
							localShell);
					VulDlg.create();
					if (VulDlg.open() == Window.OK) {
						if (VulDlg.getVulnerability() != null) {
							getComponent().getContainedVulnerabilities().add(
									VulDlg.getVulnerability());
							UpdateTableViewVulnerabilities();
						}
					}
				}
			}
		});
		btnAddVulnerability.setBounds(635, 10, 75, 25);
		btnAddVulnerability.setText("Add");

		Button btnEditVulnerability = new Button(compositeVulnerability,
				SWT.NONE);
		btnEditVulnerability.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] itemlist = tableVulnerabilities.getSelection();
				for (TableItem item : itemlist) {
					if (item.getData() instanceof Vulnerability) {
						VulnerabilityDialog VulDlg = new VulnerabilityDialog(
								localShell, (Vulnerability) item.getData());
						VulDlg.create();
						if (VulDlg.open() == Window.OK) {
							UpdateTableViewVulnerabilities();
						}
					}
				}
			}
		});
		btnEditVulnerability.setBounds(635, 41, 75, 25);
		btnEditVulnerability.setText("Edit");

		Button btnDeleteVulnerability = new Button(compositeVulnerability,
				SWT.NONE);
		btnDeleteVulnerability.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] itemlist = tableVulnerabilities.getSelection();
				for (TableItem item : itemlist) {
					if (item.getData() instanceof Vulnerability) {
						removeVulnerability((Vulnerability) item.getData());
						UpdateTableViewVulnerabilities();
					}
				}
			}
		});
		btnDeleteVulnerability.setBounds(635, 72, 75, 25);
		btnDeleteVulnerability.setText("Delete");

		CTabItem tbtmAttackers = new CTabItem(tabFolder, SWT.NONE);
		tbtmAttackers.setText("Attackers");

		Composite compositeAttackers = new Composite(tabFolder, SWT.NONE);
		tbtmAttackers.setControl(compositeAttackers);

		tableViewerAttackers = new TableViewer(compositeAttackers, SWT.BORDER
				| SWT.FULL_SELECTION);
		tableAttackers = tableViewerAttackers.getTable();
		tableAttackers.setLinesVisible(true);
		tableAttackers.setHeaderVisible(true);
		tableAttackers.setBounds(0, 0, 629, 432);

		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(
				tableViewerAttackers, SWT.NONE);
		TableColumn tblclmnAttackerType = tableViewerColumn_3.getColumn();
		tblclmnAttackerType.setWidth(155);
		tblclmnAttackerType.setText("Attacker Type");

		TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(
				tableViewerAttackers, SWT.NONE);
		TableColumn tblclmnAttackerReasoning = tableViewerColumn_4.getColumn();
		tblclmnAttackerReasoning.setWidth(100);
		tblclmnAttackerReasoning.setText("Reasoning");

		Button btnAddAttacker = new Button(compositeAttackers, SWT.NONE);
		btnAddAttacker.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (getComponent() != null) {
					AttackerDialog AttDlg = new AttackerDialog(localShell);
					AttDlg.create();
					if (AttDlg.open() == Window.OK) {
						if (AttDlg.getAttacker() != null) {
							getComponent().getPossibleAttackers().add(
									AttDlg.getAttacker());
							UpdateTableViewAttackers();
						}
					}
				}
			}
		});
		btnAddAttacker.setBounds(635, 10, 75, 25);
		btnAddAttacker.setText("Add");

		Button btnEditAttacker = new Button(compositeAttackers, SWT.NONE);
		btnEditAttacker.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] itemlist = tableAttackers.getSelection();
				for (TableItem item : itemlist) {
					if (item.getData() instanceof Attacker) {
						AttackerDialog AttDlg = new AttackerDialog(localShell,
								(Attacker) item.getData());
						AttDlg.create();
						if (AttDlg.open() == Window.OK) {
							UpdateTableViewAttackers();
						}
					}
				}
			}
		});
		btnEditAttacker.setBounds(635, 41, 75, 25);
		btnEditAttacker.setText("Edit");

		Button btnDeleteAttacker = new Button(compositeAttackers, SWT.NONE);
		btnDeleteAttacker.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] itemlist = tableAttackers.getSelection();
				for (TableItem item : itemlist) {
					if (item.getData() instanceof Attacker) {
						removeAttacker((Attacker) item.getData());
						UpdateTableViewAttackers();
					}
				}
			}
		});
		btnDeleteAttacker.setBounds(635, 72, 75, 25);
		btnDeleteAttacker.setText("Delete");

		CTabItem tbtmContainedAssets = new CTabItem(tabFolder, SWT.NONE);
		tbtmContainedAssets.setText("Contained Assets");

		Composite compositeContainedAssets = new Composite(tabFolder, SWT.NONE);
		tbtmContainedAssets.setControl(compositeContainedAssets);

		tableViewerContainedAssets = new TableViewer(compositeContainedAssets,
				SWT.BORDER | SWT.FULL_SELECTION);
		tableContainedAssets = tableViewerContainedAssets.getTable();
		tableContainedAssets.setLinesVisible(true);
		tableContainedAssets.setHeaderVisible(true);
		tableContainedAssets.setBounds(0, 0, 629, 432);

		TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(
				tableViewerContainedAssets, SWT.NONE);
		TableColumn tblclmnAssetComponent = tableViewerColumn_5.getColumn();
		tblclmnAssetComponent.setWidth(176);
		tblclmnAssetComponent.setText("Component");

		TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(
				tableViewerContainedAssets, SWT.NONE);
		TableColumn tblclmnAssetReasoning = tableViewerColumn_6.getColumn();
		tblclmnAssetReasoning.setWidth(100);
		tblclmnAssetReasoning.setText("Reasoning");

		Button btnAddAsset = new Button(compositeContainedAssets, SWT.NONE);
		btnAddAsset.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (getComponent() != null) {
					AssetDialog AssDlg = new AssetDialog(localShell,
							allComponents);
					AssDlg.create();
					if (AssDlg.open() == Window.OK) {
						if (AssDlg.getContainedAsset() != null) {
							getComponent().getContainedAssets().add(
									AssDlg.getContainedAsset());
							UpdateTableViewContainedAssets();
						}
					}
				}
			}
		});
		btnAddAsset.setBounds(635, 10, 75, 25);
		btnAddAsset.setText("Add");

		Button btnEditAsset = new Button(compositeContainedAssets, SWT.NONE);
		btnEditAsset.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] itemlist = tableContainedAssets.getSelection();
				for (TableItem item : itemlist) {
					if (item.getData() instanceof ContainedAsset) {
						AssetDialog AssDlg = new AssetDialog(localShell,
								(ContainedAsset) item.getData(), allComponents);
						AssDlg.create();
						if (AssDlg.open() == Window.OK) {
							UpdateTableViewContainedAssets();
						}
					}
				}
			}
		});
		btnEditAsset.setBounds(635, 41, 75, 25);
		btnEditAsset.setText("Edit");

		Button btnDeleteAsset = new Button(compositeContainedAssets, SWT.NONE);
		btnDeleteAsset.setBounds(635, 72, 75, 25);
		btnDeleteAsset.setText("Delete");

		/* Begin Custom Initialization Code */

		textComponentName.setText(getComponent().getName());
		btnComponentIsAsset.setSelection(getComponent().isIsAsset());
		textExternalDependency.setText(getComponent().getExternalDependency());
		textSecurityAssumptions
				.setText(getComponent().getSecurityAssumptions());
		textSecurityNotes.setText(getComponent().getSecurityNotes());

		InitialTableView();

		/* End Custom Initialization Code */

		return container;
	}

	private void InitialTableView() {
		tableViewerContainedAssets
				.setLabelProvider(new ContainedAssetsTableViewLabelProvider());
		tableViewerContainedAssets
				.setContentProvider(new ContainedAssetsTableViewContentProvider());
		tableViewerContainedAssets.setInput(getComponent());

		tableViewerVulnerabilities
				.setLabelProvider(new ContainedVulnerabilitiesTableViewLabelProvider());
		tableViewerVulnerabilities
				.setContentProvider(new ContainedVulnerabilitiesTableViewContentProvider());
		tableViewerVulnerabilities.setInput(getComponent());

		tableViewerAttackers
				.setLabelProvider(new AttackersTableViewLabelProvider());
		tableViewerAttackers
				.setContentProvider(new AttackersTableViewContentProvider());
		tableViewerAttackers.setInput(getComponent());
	}

	private void removeVulnerability(Vulnerability vul) {
		// remove a Vulnerability from a component using a Command

		EditingDomain editingDomain = AdapterFactoryEditingDomain
				.getEditingDomainFor(getComponent());
		Command command = RemoveCommand.create(editingDomain, getComponent(),
				DataFlowDiagramPatternPackage.eINSTANCE
						.getComponent_ContainedVulnerabilities(), vul);
		editingDomain.getCommandStack().execute(command);
	}

	private void removeAttacker(Attacker attacker) {
		// remove a Attacker from a component using a Command

		EditingDomain editingDomain = AdapterFactoryEditingDomain
				.getEditingDomainFor(getComponent());
		Command command = RemoveCommand.create(editingDomain, getComponent(),
				DataFlowDiagramPatternPackage.eINSTANCE
						.getComponent_PossibleAttackers(), attacker);
		editingDomain.getCommandStack().execute(command);
	}

	/**
	 * Create contents of the button bar.
	 * 
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		Button button = createButton(parent, IDialogConstants.OK_ID,
				IDialogConstants.OK_LABEL, true);
		button.setText("Save");
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(729, 601);
	}

	@Override
	protected void okPressed() {
		// Delete Component Listener
		// getComponent().eAdapters().clear();
		saveInput();
		super.okPressed();
	}

	private void saveInput() {
		getComponent().setName(textComponentName.getText());
		getComponent().setIsAsset(btnComponentIsAsset.getSelection());
		getComponent().setExternalDependency(textExternalDependency.getText());
		getComponent()
				.setSecurityAssumptions(textSecurityAssumptions.getText());
		getComponent().setSecurityNotes(textSecurityNotes.getText());
	}

	private void UpdateTableViewVulnerabilities() {
		tableViewerVulnerabilities.refresh();
	}

	private void UpdateTableViewAttackers() {
		tableViewerAttackers.refresh();
	}

	private void UpdateTableViewContainedAssets() {
		tableViewerContainedAssets.refresh();
	}
}
