package de.uni.due.swe.dfdp.design.views;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.uni.due.swe.dataFlowDiagramPattern.Attacker;
import de.uni.due.swe.dataFlowDiagramPattern.AttackerType;
import de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternFactory;

public class AttackerDialog extends Dialog {
	private DataBindingContext m_bindingContext;
	private Text textAttackerReasoning;

	/* Custom Code */
	private boolean hasNetworkAttacker;
	private boolean hasSoftwareAttacker;
	private boolean hasPhysicalAttacker;
	private boolean hasSocialAttacker;

	private Attacker attacker;
	private Button btnNetworkAttacker;
	private Button btnSoftwareAttacker;
	private Button btnPhysicalAttacker;
	private Button btnSocialAttacker;

	/**
	 * Create the dialog.
	 * 
	 * @wbp.parser.constructor
	 * 
	 * @param parentShell
	 */
	public AttackerDialog(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.TITLE | SWT.APPLICATION_MODAL);
		setAttacker(DataFlowDiagramPatternFactory.eINSTANCE.createAttacker());
	}

	public AttackerDialog(Shell parentShell, Attacker attacker) {
		super(parentShell);
		setShellStyle(SWT.TITLE | SWT.APPLICATION_MODAL);
		setAttacker(attacker);
		initialPrivateVaules();
	}

	private void initialPrivateVaules() {
		hasNetworkAttacker = getAttacker().getAttackerType().equals(
				AttackerType.NETWORK_ATTACKER);
		hasSoftwareAttacker = getAttacker().getAttackerType().equals(
				AttackerType.SOFTWARE_ATTACKER);
		hasPhysicalAttacker = getAttacker().getAttackerType().equals(
				AttackerType.PHYSICAL_ATTACKER);
		hasSocialAttacker = getAttacker().getAttackerType().equals(
				AttackerType.SOCIAL_ATTACKER);

	}

	/**
	 * Create contents of the dialog.
	 * 
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(null);

		Group grpAttackerType = new Group(container, SWT.NONE);
		grpAttackerType.setText("Attacker Type");
		grpAttackerType.setBounds(10, 10, 375, 67);

		btnNetworkAttacker = new Button(grpAttackerType, SWT.RADIO);
		btnNetworkAttacker.setBounds(10, 20, 113, 16);
		btnNetworkAttacker.setText("Network Attacker");

		btnSocialAttacker = new Button(grpAttackerType, SWT.RADIO);
		btnSocialAttacker.setBounds(10, 41, 113, 16);
		btnSocialAttacker.setText("Social Attacker");

		btnSoftwareAttacker = new Button(grpAttackerType, SWT.RADIO);
		btnSoftwareAttacker.setBounds(126, 20, 113, 16);
		btnSoftwareAttacker.setText("Software Attacker");

		btnPhysicalAttacker = new Button(grpAttackerType, SWT.RADIO);
		btnPhysicalAttacker.setBounds(245, 20, 113, 16);
		btnPhysicalAttacker.setText("Physical Attacker");

		Group groupAttackerReasoning = new Group(container, SWT.NONE);
		groupAttackerReasoning.setText("Reasoning");
		groupAttackerReasoning.setBounds(10, 83, 375, 200);

		textAttackerReasoning = new Text(groupAttackerReasoning, SWT.BORDER
				| SWT.H_SCROLL | SWT.V_SCROLL | SWT.CANCEL | SWT.MULTI);
		textAttackerReasoning.setBounds(10, 22, 355, 168);

		/* Custom Initial */

		btnNetworkAttacker.setSelection(hasNetworkAttacker);
		btnSoftwareAttacker.setSelection(hasSoftwareAttacker);
		btnPhysicalAttacker.setSelection(hasPhysicalAttacker);
		btnSocialAttacker.setSelection(hasSocialAttacker);

		return container;
	}

	/**
	 * Create contents of the button bar.
	 * 
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
		m_bindingContext = initDataBindings();
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(401, 372);
	}

	/**
	 * @return the attacker
	 */
	public Attacker getAttacker() {
		return attacker;
	}

	/**
	 * @param attacker
	 *            the attacker to set
	 */
	public void setAttacker(Attacker attacker) {
		this.attacker = attacker;
	}

	@Override
	protected void okPressed() {
		saveInput();
		super.okPressed();
	}

	private void saveInput() {

		if (btnNetworkAttacker.getSelection()) {
			getAttacker().setAttackerType(AttackerType.NETWORK_ATTACKER);
		} else if (btnSoftwareAttacker.getSelection()) {
			getAttacker().setAttackerType(AttackerType.SOFTWARE_ATTACKER);
		} else if (btnPhysicalAttacker.getSelection()) {
			getAttacker().setAttackerType(AttackerType.PHYSICAL_ATTACKER);
		} else if (btnSocialAttacker.getSelection()) {
			getAttacker().setAttackerType(AttackerType.SOCIAL_ATTACKER);
		}
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTextAttackerReasoningObserveWidget = WidgetProperties
				.text(SWT.Modify).observe(textAttackerReasoning);
		IObservableValue reasoningAttackerObserveValue = PojoProperties.value(
				"reasoning").observe(attacker);
		bindingContext.bindValue(observeTextTextAttackerReasoningObserveWidget,
				reasoningAttackerObserveValue, null, null);
		//
		return bindingContext;
	}
}
