package de.uni.due.swe.dfdp.design.views;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.uni.due.swe.dataFlowDiagramPattern.Component;
import de.uni.due.swe.dataFlowDiagramPattern.ContainedAsset;
import de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagramPatternFactory;

public class AssetDialog extends Dialog {
	private DataBindingContext m_bindingContext;
	private Text textAssetReasoning;
	private Combo comboAssetComponent;

	private ContainedAsset containedAsset;
	private EList<Component> allComponents;

	/**
	 * Create the dialog.
	 * 
	 * @param parentShell
	 * 
	 * @wbp.parser.constructor
	 */
	public AssetDialog(Shell parentShell, EList<Component> com) {
		super(parentShell);
		setShellStyle(SWT.TITLE | SWT.APPLICATION_MODAL);

		setContainedAsset(DataFlowDiagramPatternFactory.eINSTANCE
				.createContainedAsset());
		setAllComponents(com);
	}

	public AssetDialog(Shell parentShell, ContainedAsset ca,
			EList<Component> com) {
		super(parentShell);
		setShellStyle(SWT.TITLE | SWT.APPLICATION_MODAL);

		setContainedAsset(ca);
		initialPrivateVaules();
		setAllComponents(com);
	}

	private void initialPrivateVaules() {

	}

	/**
	 * Create contents of the dialog.
	 * 
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(null);

		comboAssetComponent = new Combo(container, SWT.READ_ONLY);
		comboAssetComponent.setBounds(89, 15, 137, 23);

		Label lblComponent = new Label(container, SWT.NONE);
		lblComponent.setBounds(10, 18, 73, 15);
		lblComponent.setText("Component:");

		Group groupAssetReasoning = new Group(container, SWT.NONE);
		groupAssetReasoning.setText("Reasoning");
		groupAssetReasoning.setBounds(10, 49, 424, 322);

		textAssetReasoning = new Text(groupAssetReasoning, SWT.BORDER
				| SWT.H_SCROLL | SWT.V_SCROLL | SWT.CANCEL | SWT.MULTI);
		textAssetReasoning.setBounds(10, 19, 404, 293);

		/* Start of Custom Code */

		LoadCombComponents();
		SetCombComponent();

		/* End of Custom Code */

		return container;
	}

	private void SetCombComponent() {
		if (containedAsset.getComponentAsset() == null) {
			comboAssetComponent.select(1);
		} else {
			comboAssetComponent.select(getAllComponents().indexOf(
					containedAsset.getComponentAsset()));
		}
	}

	private void LoadCombComponents() {
		for (Component c : getAllComponents()) {
			comboAssetComponent.add(c.getName());
			comboAssetComponent.setData(c.getName(), c);
		}
	}

	/**
	 * Create contents of the button bar.
	 * 
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		Button button = createButton(parent, IDialogConstants.OK_ID,
				IDialogConstants.OK_LABEL, true);
		button.setText("Save");
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
		m_bindingContext = initDataBindings();
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(461, 460);
	}

	@Override
	protected void okPressed() {
		SaveInput();
		super.okPressed();
	}

	private void SaveInput() {
		if (comboAssetComponent.getSelectionIndex() != -1) {
			getContainedAsset().setComponentAsset(
					(Component) comboAssetComponent.getData(comboAssetComponent
							.getText()));
		}
	}

	/**
	 * @return the containedAsset
	 */
	public ContainedAsset getContainedAsset() {
		return containedAsset;
	}

	/**
	 * @param containedAsset
	 *            the containedAsset to set
	 */
	public void setContainedAsset(ContainedAsset containedAsset) {
		this.containedAsset = containedAsset;
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTextAssetReasoningObserveWidget = WidgetProperties
				.text(SWT.Modify).observe(textAssetReasoning);
		IObservableValue reasoningContainedAssetObserveValue = PojoProperties
				.value("reasoning").observe(containedAsset);
		bindingContext.bindValue(observeTextTextAssetReasoningObserveWidget,
				reasoningContainedAssetObserveValue, null, null);
		//
		return bindingContext;
	}

	/**
	 * @return the allComponents
	 */
	public EList<Component> getAllComponents() {
		return allComponents;
	}

	/**
	 * @param allComponents
	 *            the allComponents to set
	 */
	public void setAllComponents(EList<Component> allComponents) {
		this.allComponents = allComponents;
	}
}
