package de.uni.due.swe.dfdp.design.services;

import java.util.Arrays;
import java.util.List;

import javax.swing.JOptionPane;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

import de.uni.due.swe.dataFlowDiagramPattern.Component;
import de.uni.due.swe.dataFlowDiagramPattern.DataFlowDiagram;
import de.uni.due.swe.dataFlowDiagramPattern.PrivilegeBoundary;

public class HelperServices {

	// public List<EObject> printContextType(EObject eo) {
	// System.out.println("HelperServices::printContextType():" +
	// eo.toString());
	// List<EObject> result=new ArrayList<EObject>();
	// result.add(eo);
	// return result;
	// }

	public EObject printContextType(EObject eo) {
		System.out.println("HelperServices::printContextType():"
				+ eo.eClass().toString());
		// DDiagramElement n = (DNode)eo;
		return eo;
	}

	public Boolean IsMovingComponent(EObject eo) {
		Object[] options = { "Move", // YES_OPTION
				"Copy" // NO_OPTION
		};
		int n = JOptionPane.showOptionDialog(null,
				"Move or copy the selected components into the container?",
				"Move or copy", JOptionPane.YES_NO_CANCEL_OPTION,
				JOptionPane.QUESTION_MESSAGE, null, // do not use a custom Icon
				options, // the titles of buttons
				options[1] // default button title
				);
		if (n == 0) {
			return true;
		} else {
			return false;
		}
	}

	public boolean isValidEdge(EObject eo, DSemanticDecorator sourceView,
			DSemanticDecorator targetView) {

		if (sourceView.eContainer().equals(targetView.eContainer())) {
			return true;
		} else {
			Component source = (Component) sourceView.getTarget();
			Component target = (Component) targetView.getTarget();
			
			List<Component> componentsPair =  Arrays.asList(source, target);
			
			EList<PrivilegeBoundary> sourceContentedPrivilegeBoundary = source.getContainedByPrivilegeBoundary();
			EList<PrivilegeBoundary> targetContentedPrivilegeBoundary = target.getContainedByPrivilegeBoundary();
			
			PrivilegeBoundary sourcecontainer = (PrivilegeBoundary) ((DSemanticDecorator) sourceView
					.eContainer()).getTarget();
			PrivilegeBoundary targetcontainer = (PrivilegeBoundary) ((DSemanticDecorator) targetView
					.eContainer()).getTarget();
			for (Component c : targetcontainer.getComponetsWithin()) {
				if (c.equals(source)) {
					return false;
				}
			}
			
			for (Component c : sourcecontainer.getComponetsWithin()) {
				if (c.equals(target)) {
					return false;
				}
			}
			
			for(PrivilegeBoundary pb : sourceContentedPrivilegeBoundary) {
				if(pb.getComponetsWithin().containsAll(componentsPair)) {
					return false;
				}
			}
			
			for(PrivilegeBoundary pb : targetContentedPrivilegeBoundary) {
				if(pb.getComponetsWithin().containsAll(componentsPair)) {
					return false;
				}
			}
		}

		return true;

	}
	
	
}
