package de.uni.due.swe.dfdp.design.actions;

import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.window.Window;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import de.uni.due.swe.dataFlowDiagramPattern.Component;
import de.uni.due.swe.dfdp.design.views.ComponentDialog;

public class EditComponentProperty implements IExternalJavaAction {

	private Shell shell;

	/**
	 * @return the shell
	 */
	private Shell getShell() {
		if (shell == null) {
			shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
					.getShell();
		}
		return shell;
	}

	/**
	 * @param shell
	 *            the shell to set
	 */
	private void setShell(Shell shell) {
		this.shell = shell;
	}

	/**
	 * 
	 */
	public EditComponentProperty() {

	}

	@Override
	public void execute(Collection<? extends EObject> selections,
			Map<String, Object> parameters) {
		if (selections.size() != 1) {
			// TODO: display error with a popup
			System.err
					.println("EditComponentProperty::execute() exactly one element must be selected");
			return;
		}

		for (EObject eo : selections) {
			if (eo instanceof Component) {
				Component comp = (Component) eo;
				try {
					ComponentDialog comDlg = new ComponentDialog(getShell(),
							comp);
					comDlg.create();
					if (comDlg.open() == Window.OK) {
					}
					// Display display = Display.getCurrent();
					// Realm.runWithDefault(SWTObservables.getRealm(display),
					// new Runnable() {
					// public void run() {
					// try {
					// EditComponentView window = new EditComponentView(
					// comp);
					// window.open();
					// } catch (Exception e) {
					// e.printStackTrace();
					// }
					// }
					// });

				} catch (Exception e) {
					e.printStackTrace();
				}

			}
		}
	}

	@Override
	public boolean canExecute(Collection<? extends EObject> selections) {
		// TODO define precondition
		return true;
	}

}
