package org.xtext.example.mydsl.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.xtext.example.mydsl.getterSetter.GetterSetterPackage;
import org.xtext.example.mydsl.getterSetter.Import;
import org.xtext.example.mydsl.getterSetter.Model;
import org.xtext.example.mydsl.getterSetter.Operation;
import org.xtext.example.mydsl.getterSetter.Setter;
import org.xtext.example.mydsl.services.GetterSetterGrammarAccess;

@SuppressWarnings("all")
public class GetterSetterSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private GetterSetterGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == GetterSetterPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case GetterSetterPackage.IMPORT:
				if(context == grammarAccess.getImportRule()) {
					sequence_Import(context, (Import) semanticObject); 
					return; 
				}
				else break;
			case GetterSetterPackage.MODEL:
				if(context == grammarAccess.getModelRule()) {
					sequence_Model(context, (Model) semanticObject); 
					return; 
				}
				else break;
			case GetterSetterPackage.OPERATION:
				if(context == grammarAccess.getGreetingRule() ||
				   context == grammarAccess.getOperationRule()) {
					sequence_Operation(context, (Operation) semanticObject); 
					return; 
				}
				else break;
			case GetterSetterPackage.SETTER:
				if(context == grammarAccess.getGreetingRule() ||
				   context == grammarAccess.getSetterRule()) {
					sequence_Setter(context, (Setter) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     importURI=STRING
	 */
	protected void sequence_Import(EObject context, Import semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, GetterSetterPackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GetterSetterPackage.Literals.IMPORT__IMPORT_URI));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0(), semanticObject.getImportURI());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (imports+=Import* greetings+=Greeting*)
	 */
	protected void sequence_Model(EObject context, Model semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (c=[EClass|FQN] op=[EOperation|ID])
	 */
	protected void sequence_Operation(EObject context, Operation semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, GetterSetterPackage.Literals.GREETING__C) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GetterSetterPackage.Literals.GREETING__C));
			if(transientValues.isValueTransient(semanticObject, GetterSetterPackage.Literals.OPERATION__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GetterSetterPackage.Literals.OPERATION__OP));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getOperationAccess().getCEClassFQNParserRuleCall_1_0_1(), semanticObject.getC());
		feeder.accept(grammarAccess.getOperationAccess().getOpEOperationIDTerminalRuleCall_3_0_1(), semanticObject.getOp());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (c=[EClass|FQN] feature=[EStructuralFeature|ID])
	 */
	protected void sequence_Setter(EObject context, Setter semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, GetterSetterPackage.Literals.GREETING__C) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GetterSetterPackage.Literals.GREETING__C));
			if(transientValues.isValueTransient(semanticObject, GetterSetterPackage.Literals.SETTER__FEATURE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GetterSetterPackage.Literals.SETTER__FEATURE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getSetterAccess().getCEClassFQNParserRuleCall_1_0_1(), semanticObject.getC());
		feeder.accept(grammarAccess.getSetterAccess().getFeatureEStructuralFeatureIDTerminalRuleCall_3_0_1(), semanticObject.getFeature());
		feeder.finish();
	}
}
