/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.pool;

import com.esotericsoftware.kryo.Kryo;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KryoPool {
    private Queue<Kryo> queue;
    private KryoFactory factory;

    public KryoPool(KryoFactory factory) {
        this.factory = factory;
        this.queue = new ConcurrentLinkedQueue<Kryo>();
    }

    public int size() {
        return this.queue.size();
    }

    public Kryo borrow() {
        Kryo t = this.queue.poll();
        if (t == null) {
            t = this.factory.create();
        }
        return t;
    }

    public void release(Kryo kryo) {
        this.queue.offer(kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(KryoCallback<T> callback) {
        Kryo kryo = this.borrow();
        try {
            T t = callback.execute(kryo);
            return t;
        }
        finally {
            this.release(kryo);
        }
    }

    public static interface KryoFactory {
        public Kryo create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KryoCallback<T> {
        public T execute(Kryo var1);
    }
}

