/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import impl.org.controlsfx.i18n.Localization;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Window;
import org.controlsfx.control.ButtonBar;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.dialog.DialogAction;
import org.controlsfx.dialog.FXDialog;
import org.controlsfx.dialog.HeavyweightDialog;
import org.controlsfx.dialog.LightweightDialog;
import org.controlsfx.tools.Utils;

@Deprecated
public class Dialog {
    public static final String STYLE_CLASS_NATIVE = "native";
    public static final String STYLE_CLASS_CROSS_PLATFORM = "cross-platform";
    public static final String STYLE_CLASS_UNDECORATED = "undecorated";
    public static final Action ACTION_CANCEL = new DialogAction(Localization.asKey("dlg.cancel.button"), ButtonBar.ButtonType.CANCEL_CLOSE){
        {
            this.lock();
        }

        public String toString() {
            return "DialogAction.CANCEL";
        }
    };
    public static final Action ACTION_CLOSE = new DialogAction(Localization.asKey("dlg.close.button"), ButtonBar.ButtonType.CANCEL_CLOSE){
        {
            this.lock();
        }

        public String toString() {
            return "DialogAction.CLOSE";
        }
    };
    public static final Action ACTION_NO = new DialogAction(Localization.asKey("dlg.no.button"), ButtonBar.ButtonType.NO){
        {
            this.lock();
        }

        public String toString() {
            return "DialogAction.NO";
        }
    };
    public static final Action ACTION_OK = new DialogAction(Localization.asKey("dlg.ok.button"), ButtonBar.ButtonType.OK_DONE, false, true, true){
        {
            this.lock();
        }

        public String toString() {
            return "DialogAction.OK";
        }
    };
    public static final Action ACTION_YES = new DialogAction(Localization.asKey("dlg.yes.button"), ButtonBar.ButtonType.YES, false, true, true){
        {
            this.lock();
        }

        public String toString() {
            return "DialogAction.YES";
        }
    };
    private static final boolean DEBUG = false;
    static int MIN_DIALOG_WIDTH = 426;
    private final FXDialog dialog;
    Action result = ACTION_CANCEL;
    private GridPane contentPane;
    private boolean isDefaultMasthead = false;
    private final ObjectProperty<Node> graphicProperty = new SimpleObjectProperty<Node>(){

        protected void invalidated() {
            Dialog.this.updateGraphic();
        }
    };
    private final ObjectProperty<Node> masthead = new SimpleObjectProperty<Node>(){

        protected void invalidated() {
            Dialog.this.isDefaultMasthead = false;
        }
    };
    private final ObjectProperty<Node> content = new SimpleObjectProperty<Node>(){

        protected void invalidated() {
            Node contentNode = Dialog.this.getContent();
            if (contentNode != null) {
                contentNode.getStyleClass().addAll((Object[])new String[]{"content"});
            }
            if (Dialog.this.dialog.getWindow().isShowing()) {
                Dialog.this.updateDialogContent();
            }
        }
    };
    private final ObjectProperty<Node> expandableContentProperty = new SimpleObjectProperty();
    private final ObservableList<Action> actions = FXCollections.observableArrayList();
    private final ObjectProperty<Effect> backgroundEffectProperty = new SimpleObjectProperty<Effect>(){

        protected void invalidated() {
            Dialog.this.dialog.setEffect((Effect)this.getValue());
        }
    };
    static String buttonBarOrder = null;
    private static final PseudoClass MASTHEAD_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"masthead");
    private static final PseudoClass NO_MASTHEAD_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"no-masthead");

    public Dialog(Object owner, String title) {
        this(owner, title, false);
    }

    public Dialog(Object owner, String title, boolean lightweight) {
        if (lightweight) {
            this.dialog = new LightweightDialog(title, owner);
        } else {
            Window window = Utils.getWindow(owner);
            this.dialog = new HeavyweightDialog(title, window);
            this.dialog.setModal(true);
        }
        this.updateStyleClasses((List<String>)this.dialog.getStyleClass(), false);
        this.getActions().addListener(c -> {
            if (this.dialog.getWindow().isShowing()) {
                this.updateDialogContent();
            }
        });
    }

    void updateStyleClasses(List<String> styleClasses, boolean addUnique) {
        if (styleClasses == null) {
            return;
        }
        for (String styleClass : styleClasses) {
            if (!addUnique || this.dialog.getStyleClass().contains((Object)styleClass)) continue;
            this.dialog.getStyleClass().add((Object)styleClass);
        }
    }

    public Action show() {
        try {
            this.updateDialogContent();
            this.dialog.show();
            return this.result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return ACTION_CANCEL;
        }
    }

    public void hide() {
        this.dialog.hide();
    }

    public void shake() {
        this.dialog.shake();
    }

    public void setResult(Action result) {
        DialogAction dlgAction;
        this.result = result;
        if (result instanceof DialogAction && ((dlgAction = (DialogAction)result).isCancel() || dlgAction.isClosing())) {
            this.hide();
        }
    }

    public ObservableList<String> getStylesheets() {
        return this.dialog.getStylesheets();
    }

    public ObservableList<String> getStyleClass() {
        return this.dialog.getStyleClass();
    }

    public BooleanProperty resizableProperty() {
        return this.dialog.resizableProperty();
    }

    public final boolean isResizable() {
        return this.resizableProperty().get();
    }

    public final void setResizable(boolean resizable) {
        this.resizableProperty().set(resizable);
    }

    public void setIconifiable(boolean iconifiable) {
        this.dialog.setIconifiable(iconifiable);
    }

    public void setClosable(boolean closable) {
        this.dialog.setClosable(closable);
    }

    public ObjectProperty<Node> graphicProperty() {
        return this.graphicProperty;
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty.get();
    }

    public final void setGraphic(Node graphic) {
        this.graphicProperty.set((Object)graphic);
    }

    public final Node getMasthead() {
        return (Node)this.masthead.get();
    }

    public final void setMasthead(Node masthead) {
        this.masthead.setValue((Object)masthead);
    }

    public final void setMasthead(String mastheadText) {
        if (mastheadText == null) {
            return;
        }
        BorderPane mastheadPanel = new BorderPane();
        mastheadPanel.getStyleClass().add((Object)"masthead-panel");
        Label mastheadLabel = new Label(mastheadText);
        mastheadLabel.setWrapText(true);
        mastheadLabel.setAlignment(Pos.CENTER_LEFT);
        mastheadLabel.setMaxWidth((double)MIN_DIALOG_WIDTH);
        mastheadPanel.setLeft((Node)mastheadLabel);
        BorderPane.setAlignment((Node)mastheadLabel, (Pos)Pos.CENTER_LEFT);
        this.setMasthead((Node)mastheadPanel);
        this.isDefaultMasthead = true;
        this.updateGraphic();
    }

    private void updateGraphic() {
        Node graphic = this.getGraphic();
        Node masthead = this.getMasthead();
        if (masthead != null && this.isDefaultMasthead) {
            BorderPane mastheadBorderPane = (BorderPane)masthead;
            if (graphic == null) {
                mastheadBorderPane.setRight(null);
            } else {
                StackPane pane = new StackPane(new Node[]{graphic});
                pane.getStyleClass().add((Object)"graphic-container");
                mastheadBorderPane.setRight((Node)pane);
            }
        }
    }

    public ObjectProperty<Node> mastheadProperty() {
        return this.masthead;
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final void setContent(Node content) {
        this.content.setValue((Object)content);
    }

    public final void setContent(String contentText) {
        if (contentText == null) {
            return;
        }
        Label label = new Label(contentText);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.setMaxWidth(360.0);
        label.setWrapText(true);
        this.setContent((Node)label);
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public ObjectProperty<Node> expandableContentProperty() {
        return this.expandableContentProperty;
    }

    public final Node getExpandableContent() {
        return (Node)this.expandableContentProperty.get();
    }

    public final void setExpandableContent(Node content) {
        this.expandableContentProperty.set((Object)content);
    }

    ReadOnlyDoubleProperty widthProperty() {
        return this.dialog.widthProperty();
    }

    public final double getWidth() {
        return this.widthProperty().get();
    }

    ReadOnlyDoubleProperty heightProperty() {
        return this.dialog.heightProperty();
    }

    public final double getHeight() {
        return this.heightProperty().get();
    }

    public final ObservableList<Action> getActions() {
        return this.actions;
    }

    public StringProperty titleProperty() {
        return this.dialog.titleProperty();
    }

    public String getTitle() {
        return (String)this.dialog.titleProperty().get();
    }

    public void setTitle(String title) {
        this.dialog.titleProperty().set((Object)title);
    }

    public ObjectProperty<Effect> backgroundEffectProperty() {
        return this.backgroundEffectProperty;
    }

    public final Effect getBackgroundEffect() {
        return (Effect)this.backgroundEffectProperty.get();
    }

    public final void setBackgroundEffect(Effect effect) {
        this.backgroundEffectProperty.set((Object)effect);
    }

    void sizeToScene() {
        this.dialog.sizeToScene();
    }

    static void setMacOS(boolean b) {
        if (b) {
            buttonBarOrder = "L_HE+U+FBIX_NCYOA_R";
        }
    }

    static void setWindows(boolean b) {
        if (b) {
            buttonBarOrder = "L_E+U+FBXI_YNOCAH_R";
        }
    }

    static void setLinux(boolean b) {
        if (b) {
            buttonBarOrder = "L_HE+UNYACBXIO_R";
        }
    }

    private boolean hasMasthead() {
        return this.getMasthead() != null;
    }

    private boolean hasExpandableContent() {
        return this.getExpandableContent() != null;
    }

    private void updateDialogContent() {
        this.contentPane = new GridPane();
        this.contentPane.getStyleClass().add((Object)"content-pane");
        this.contentPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        int row = 0;
        boolean hasMasthead = this.hasMasthead();
        if (hasMasthead) {
            Node masthead = this.getMasthead();
            this.contentPane.add(masthead, 0, row++);
        }
        this.createCenterPanel(row);
        Node root = this.dialog.getRoot();
        root.pseudoClassStateChanged(MASTHEAD_PSEUDO_CLASS, hasMasthead);
        root.pseudoClassStateChanged(NO_MASTHEAD_PSEUDO_CLASS, !hasMasthead);
        ColumnConstraints leftColumn = new ColumnConstraints();
        ColumnConstraints rightColumn = new ColumnConstraints();
        rightColumn.setFillWidth(true);
        rightColumn.setHgrow(Priority.ALWAYS);
        if (!hasMasthead) {
            this.contentPane.getColumnConstraints().add((Object)leftColumn);
        }
        this.contentPane.getColumnConstraints().add((Object)rightColumn);
        if (!this.contentPane.minWidthProperty().isBound()) {
            this.contentPane.setMinWidth((double)MIN_DIALOG_WIDTH);
        }
        this.contentPane.setGridLinesVisible(false);
        this.dialog.setContentPane((Pane)this.contentPane);
    }

    private void createCenterPanel(int startRow) {
        boolean hasMasthead = this.hasMasthead();
        final Node content = this.getContent();
        if (content != null) {
            content.getStyleClass().add((Object)"center");
            this.contentPane.add(content, hasMasthead ? 0 : 1, startRow);
            GridPane.setVgrow((Node)content, (Priority)Priority.SOMETIMES);
            GridPane.setValignment((Node)content, (VPos)VPos.TOP);
            GridPane.setHgrow((Node)content, (Priority)Priority.ALWAYS);
            if (content instanceof Region) {
                this.contentPane.minWidthProperty().bind((ObservableValue)new DoubleBinding(){
                    {
                        this.bind(new Observable[]{((Region)content).minWidthProperty()});
                    }

                    protected double computeValue() {
                        return Math.max((double)MIN_DIALOG_WIDTH, ((Region)content).getMinWidth());
                    }
                });
            }
        }
        Node graphic = this.getGraphic();
        if (!hasMasthead && graphic != null) {
            Pane graphicPane = new Pane(new Node[]{graphic});
            double w = graphic.getLayoutBounds().getWidth();
            double h = graphic.getLayoutBounds().getHeight();
            graphicPane.setMinSize(w, h);
            graphicPane.getStyleClass().add((Object)"graphic");
            this.contentPane.add((Node)graphicPane, 0, startRow);
            GridPane.setValignment((Node)graphicPane, (VPos)VPos.TOP);
            GridPane.setMargin((Node)graphicPane, (Insets)new Insets(0.0, 8.0, 0.0, 0.0));
        }
        if (this.hasExpandableContent()) {
            Node ec = this.getExpandableContent();
            ec.getStyleClass().add((Object)"expandable-content");
            this.contentPane.add(ec, 0, startRow + 1, 2, 1);
            ec.setVisible(false);
            ec.managedProperty().bind((ObservableValue)ec.visibleProperty());
            GridPane.setHgrow((Node)ec, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)ec, (Priority)Priority.ALWAYS);
        }
        if (!this.getActions().isEmpty() || this.hasExpandableContent()) {
            this.createButtonPanel(startRow + 2);
        }
    }

    private void createButtonPanel(int startRow) {
        ButtonBar buttonBar = new ButtonBar();
        if (buttonBarOrder != null) {
            buttonBar.setButtonOrder(buttonBarOrder);
        }
        if (this.hasExpandableContent()) {
            buttonBar.addSizeIndependentButton((ButtonBase)this.createDetailsButton(), ButtonBar.ButtonType.HELP_2);
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        boolean hasDefault = false;
        for (Action cmd : this.getActions()) {
            Button b = this.createButton(cmd, !hasDefault);
            if (b instanceof Button) {
                hasDefault |= b.isDefaultButton();
            }
            buttons.add(b);
        }
        buttonBar.getButtons().addAll(buttons);
        this.contentPane.add((Node)buttonBar, 0, startRow, 2, 1);
        GridPane.setHgrow((Node)buttonBar, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)buttonBar, (Priority)Priority.NEVER);
        GridPane.setMargin((Node)buttonBar, (Insets)new Insets(14.0, 0.0, 14.0, 0.0));
    }

    private Hyperlink createDetailsButton() {
        final Hyperlink detailsButton = new Hyperlink();
        detailsButton.getStyleClass().setAll((Object[])new String[]{"details-button", "more"});
        final String moreText = Localization.getString("dlg.detail.button.more");
        final String lessText = Localization.getString("dlg.detail.button.less");
        detailsButton.setText(moreText);
        detailsButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ae) {
                Node content = Dialog.this.getExpandableContent();
                Dialog.this.setResizable(!content.isVisible());
                content.setVisible(!content.isVisible());
                detailsButton.setText(content.isVisible() ? lessText : moreText);
                detailsButton.getStyleClass().setAll((Object[])new String[]{"details-button", content.isVisible() ? "less" : "more"});
                Dialog.this.dialog.sizeToScene();
            }
        });
        return detailsButton;
    }

    private Button createButton(final Action action, boolean keepDefault) {
        Button button = ActionUtils.createButton(action);
        if (action instanceof DialogAction) {
            DialogAction dlgAction = (DialogAction)action;
            button.setDefaultButton(keepDefault && dlgAction.isDefault());
            button.setCancelButton(dlgAction.isCancel());
        }
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ae) {
                action.handle(new ActionEvent((Object)Dialog.this, ae.getTarget()));
                Dialog.this.result = action;
            }
        });
        return button;
    }
}

