/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.FocusModelListener;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.SpreadsheetViewSelectionModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.GridBase;
import org.controlsfx.control.spreadsheet.GridChange;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.tools.Utils;

public class SpreadsheetView
extends Control {
    private static final double DEFAULT_ROW_HEADER_WIDTH = 30.0;
    private final SpreadsheetGridView cellsView;
    private SimpleObjectProperty<Grid> gridProperty = new SimpleObjectProperty();
    private DataFormat fmt;
    private final ObservableList<Integer> fixedRows = FXCollections.observableArrayList();
    private final ObservableList<SpreadsheetColumn> fixedColumns = FXCollections.observableArrayList();
    private final BooleanProperty fixingRowsAllowedProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty fixingColumnsAllowedProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty showColumnHeader = new SimpleBooleanProperty((Object)true, "showColumnHeader", true);
    private final BooleanProperty showRowHeader = new SimpleBooleanProperty((Object)true, "showRowHeader", true);
    private BitSet rowFix;
    private final ObservableList<Integer> rowPickers = FXCollections.observableArrayList();
    private Callback<Integer, Void> rowPickerCallback = DEFAULT_CALLBACK;
    private final ObservableList<Integer> columnPickers = FXCollections.observableArrayList();
    private Callback<Integer, Void> columnPickerCallback = DEFAULT_CALLBACK;
    private ObservableList<SpreadsheetColumn> columns = FXCollections.observableArrayList();
    private Map<SpreadsheetCellType<?>, SpreadsheetCellEditor> editors = new IdentityHashMap();
    private final DoubleProperty rowHeaderWidth = new SimpleDoubleProperty(30.0);
    final SpreadsheetHandle handle = new SpreadsheetHandle(){

        @Override
        protected SpreadsheetView getView() {
            return SpreadsheetView.this;
        }

        @Override
        protected GridViewSkin getCellsViewSkin() {
            return SpreadsheetView.this.getCellsViewSkin();
        }

        @Override
        protected SpreadsheetGridView getGridView() {
            return SpreadsheetView.this.getCellsView();
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> c) {
            while (c.next()) {
                if (c.wasAdded()) {
                    List newRows = c.getAddedSubList();
                    if (!SpreadsheetView.this.areRowsFixable(newRows)) {
                        throw new IllegalArgumentException(SpreadsheetView.this.computeReason(newRows));
                    }
                    FXCollections.sort((ObservableList)SpreadsheetView.this.fixedRows);
                }
                if (!c.wasRemoved()) continue;
            }
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> c) {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                List newColumns = c.getAddedSubList();
                for (SpreadsheetColumn column : newColumns) {
                    if (column.isColumnFixable()) continue;
                    throw new IllegalArgumentException(this.computeReason(column));
                }
            }
        }

        private String computeReason(SpreadsheetColumn element) {
            int indexColumn = SpreadsheetView.this.getColumns().indexOf((Object)element);
            String reason = "\n This column cannot be fixed.";
            for (ObservableList row : SpreadsheetView.this.getGrid().getRows()) {
                int columnSpan = ((SpreadsheetCell)row.get(indexColumn)).getColumnSpan();
                if (columnSpan <= 1) continue;
                reason = reason + "The cell situated at line " + ((SpreadsheetCell)row.get(indexColumn)).getRow() + " and column " + indexColumn + "\n has a rowSpan or a ColumnSpan superior to 1, it must be 1.";
                return reason;
            }
            return reason;
        }
    };
    private static final Callback<Integer, Void> DEFAULT_CALLBACK = new Callback<Integer, Void>(){

        public Void call(Integer p) {
            return null;
        }
    };
    private final ChangeListener<ContextMenu> contextMenuChangeListener = new ChangeListener<ContextMenu>(){

        public void changed(ObservableValue<? extends ContextMenu> arg0, ContextMenu oldContextMenu, ContextMenu newContextMenu) {
            if (oldContextMenu != null) {
                oldContextMenu.setOnShowing(null);
            }
            if (newContextMenu != null) {
                newContextMenu.setOnShowing((EventHandler)new WeakEventHandler(SpreadsheetView.this.hideContextMenuEventHandler));
            }
        }
    };
    private final EventHandler<WindowEvent> hideContextMenuEventHandler = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent arg0) {
            if (SpreadsheetView.this.getEditingCell() != null) {
                Platform.runLater(() -> SpreadsheetView.this.getContextMenu().hide());
            }
        }
    };

    final GridViewSkin getCellsViewSkin() {
        return (GridViewSkin)this.cellsView.getSkin();
    }

    final SpreadsheetGridView getCellsView() {
        return this.cellsView;
    }

    public SpreadsheetView() {
        this(SpreadsheetView.getSampleGrid());
        for (SpreadsheetColumn column : this.getColumns()) {
            column.setPrefWidth(100.0);
        }
    }

    public SpreadsheetView(final Grid grid) {
        this.getStyleClass().add((Object)"SpreadsheetView");
        this.setSkin((Skin)new Skin<SpreadsheetView>(){

            public Node getNode() {
                return SpreadsheetView.this.getCellsView();
            }

            public SpreadsheetView getSkinnable() {
                return SpreadsheetView.this;
            }

            public void dispose() {
            }
        });
        this.cellsView = new SpreadsheetGridView(this.handle);
        this.getChildren().add((Object)this.cellsView);
        SpreadsheetViewSelectionModel selectionModel = new SpreadsheetViewSelectionModel(this, this.cellsView);
        this.cellsView.setSelectionModel(selectionModel);
        selectionModel.setCellSelectionEnabled(true);
        selectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        this.cellsView.getFocusModel().focusedCellProperty().addListener((ChangeListener)new FocusModelListener(this, this.cellsView));
        this.cellsView.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (SpreadsheetView.this.getEditingCell() == null && !keyEvent.isShiftDown() && keyEvent.getCode() == KeyCode.ENTER) {
                    int nextRow;
                    SpreadsheetView.this.cellsView.setEditWithEnter(true);
                    TablePosition position = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                    if (position != null && (nextRow = FocusModelListener.getNextRowNumber(position, SpreadsheetView.this.getCellsView())) < grid.getRowCount()) {
                        SpreadsheetView.this.cellsView.getSelectionModel().clearAndSelect(nextRow, position.getTableColumn());
                    }
                } else if (keyEvent.getCode() == KeyCode.DELETE) {
                    SpreadsheetView.this.deleteSelectedCells();
                } else if ((keyEvent.getCode().isLetterKey() || keyEvent.getCode().isDigitKey() || keyEvent.getCode().isKeypadKey()) && !keyEvent.isShortcutDown() && !keyEvent.getCode().isArrowKey()) {
                    TablePosition position = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                    SpreadsheetView.this.cellsView.setEditWithKey(true);
                    SpreadsheetView.this.cellsView.edit(position.getRow(), position.getTableColumn());
                }
            }
        });
        this.contextMenuProperty().addListener((ChangeListener)new WeakChangeListener(this.contextMenuChangeListener));
        CellView.getValue(() -> this.setContextMenu(this.getSpreadsheetViewContextMenu()));
        this.setGrid(grid);
        this.setEditable(true);
        this.fixedRows.addListener(this.fixedRowsListener);
        this.fixedColumns.addListener(this.fixedColumnsListener);
    }

    public final void setGrid(Grid grid) {
        this.gridProperty.set((Object)grid);
        this.initRowFix(grid);
        ArrayList<Integer> newFixedRows = new ArrayList<Integer>();
        for (Object rowFixed : this.getFixedRows()) {
            if (!this.isRowFixable((Integer)rowFixed)) continue;
            newFixedRows.add((Integer)rowFixed);
        }
        this.getFixedRows().setAll(newFixedRows);
        ArrayList<Integer> columnsFixed = new ArrayList<Integer>();
        for (Object column : this.getFixedColumns()) {
            columnsFixed.add(this.getColumns().indexOf(column));
        }
        this.getFixedColumns().clear();
        ArrayList<Double> widthColumns = new ArrayList<Double>();
        for (SpreadsheetColumn column : this.columns) {
            widthColumns.add(column.getWidth());
        }
        if (grid.getRows() != null) {
            ObservableList observableRows = FXCollections.observableArrayList(grid.getRows());
            this.cellsView.getItems().clear();
            this.cellsView.setItems(observableRows);
            int columnCount = grid.getColumnCount();
            this.columns.clear();
            for (int i = 0; i < columnCount; ++i) {
                final int col = i;
                String columnHeader = grid.getColumnHeaders().size() > i ? (String)grid.getColumnHeaders().get(i) : Utils.getExcelLetterFromNumber(i);
                TableColumn column = new TableColumn(columnHeader);
                column.setEditable(true);
                column.setSortable(false);
                column.impl_setReorderable(false);
                column.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList<SpreadsheetCell>, SpreadsheetCell>, ObservableValue<SpreadsheetCell>>(){

                    public ObservableValue<SpreadsheetCell> call(TableColumn.CellDataFeatures<ObservableList<SpreadsheetCell>, SpreadsheetCell> p) {
                        return new ReadOnlyObjectWrapper(((ObservableList)p.getValue()).get(col));
                    }
                });
                column.setCellFactory((Callback)new Callback<TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell>, TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell>>(){

                    public TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell> call(TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> p) {
                        return new CellView(SpreadsheetView.this.handle);
                    }
                });
                SpreadsheetColumn spreadsheetColumn = new SpreadsheetColumn((TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell>)column, this, i);
                if (widthColumns.size() > i) {
                    spreadsheetColumn.setPrefWidth((Double)widthColumns.get(i));
                }
                this.columns.add((Object)spreadsheetColumn);
                if (!columnsFixed.contains(i) || !spreadsheetColumn.isColumnFixable()) continue;
                spreadsheetColumn.setFixed(true);
            }
        }
        CellView.getValue(() -> {
            this.cellsView.getColumns().clear();
            for (SpreadsheetColumn spreadsheetColumn : this.columns) {
                this.cellsView.getColumns().add(spreadsheetColumn.column);
            }
        });
    }

    public TablePosition<ObservableList<SpreadsheetCell>, ?> getEditingCell() {
        return this.cellsView.getEditingCell();
    }

    public final ObservableList<SpreadsheetColumn> getColumns() {
        return this.columns;
    }

    public final Grid getGrid() {
        return (Grid)this.gridProperty.get();
    }

    public final ReadOnlyObjectProperty<Grid> gridProperty() {
        return this.gridProperty;
    }

    public ObservableList<Integer> getFixedRows() {
        return this.fixedRows;
    }

    public boolean isRowFixable(int row) {
        return row < this.rowFix.size() && this.isFixingRowsAllowed() ? this.rowFix.get(row) : false;
    }

    public boolean areRowsFixable(List<? extends Integer> list) {
        for (Integer n : list) {
            if (this.isRowFixable(n)) continue;
            int maxSpan = 1;
            List gridRow = (List)this.getGrid().getRows().get(n.intValue());
            for (SpreadsheetCell cell : gridRow) {
                if (!list.contains(cell.getRow())) {
                    return false;
                }
                if (cell.getRowSpan() <= maxSpan || cell.getRow() != n.intValue()) continue;
                maxSpan = cell.getRowSpan();
            }
            int count = n + maxSpan - 1;
            for (int index = n + 1; index < count; ++index) {
                if (list.contains(index)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFixingRowsAllowed() {
        return this.fixingRowsAllowedProperty.get();
    }

    public void setFixingRowsAllowed(boolean b) {
        this.fixingRowsAllowedProperty.set(b);
    }

    public ReadOnlyBooleanProperty fixingRowsAllowedProperty() {
        return this.fixingRowsAllowedProperty;
    }

    public ObservableList<SpreadsheetColumn> getFixedColumns() {
        return this.fixedColumns;
    }

    public boolean isColumnFixable(int columnIndex) {
        return columnIndex < this.getColumns().size() ? Boolean.valueOf(((SpreadsheetColumn)this.getColumns().get(columnIndex)).isColumnFixable()) : null;
    }

    public boolean isFixingColumnsAllowed() {
        return this.fixingColumnsAllowedProperty.get();
    }

    public void setFixingColumnsAllowed(boolean b) {
        this.fixingColumnsAllowedProperty.set(b);
    }

    public ReadOnlyBooleanProperty fixingColumnsAllowedProperty() {
        return this.fixingColumnsAllowedProperty;
    }

    public final void setShowColumnHeader(boolean b) {
        this.showColumnHeader.setValue(Boolean.valueOf(b));
    }

    public final boolean isShowColumnHeader() {
        return this.showColumnHeader.get();
    }

    public final BooleanProperty showColumnHeaderProperty() {
        return this.showColumnHeader;
    }

    public final void setShowRowHeader(boolean b) {
        this.showRowHeader.setValue(Boolean.valueOf(b));
    }

    public final boolean isShowRowHeader() {
        return this.showRowHeader.get();
    }

    public final BooleanProperty showRowHeaderProperty() {
        return this.showRowHeader;
    }

    public final DoubleProperty rowHeaderWidthProperty() {
        return this.rowHeaderWidth;
    }

    public final void setRowHeaderWidth(double value) {
        this.rowHeaderWidth.setValue((Number)value);
    }

    public final double getRowHeaderWidth() {
        return this.rowHeaderWidth.get();
    }

    public ObservableList<Integer> getRowPickers() {
        return this.rowPickers;
    }

    public void setRowPickerCallback(Callback<Integer, Void> callback) {
        this.rowPickerCallback = callback;
    }

    public Callback<Integer, Void> getRowPickerCallback() {
        return this.rowPickerCallback;
    }

    public ObservableList<Integer> getColumnPickers() {
        return this.columnPickers;
    }

    public void setColumnPickerCallback(Callback<Integer, Void> callback) {
        this.columnPickerCallback = callback;
    }

    public Callback<Integer, Void> getColumnPickerCallback() {
        return this.columnPickerCallback;
    }

    public void resizeRowsToFitContent() {
        this.getCellsViewSkin().resizeRowsToFitContent();
    }

    public void resizeRowsToMaximum() {
        this.getCellsViewSkin().resizeRowsToMaximum();
    }

    public void resizeRowsToDefault() {
        this.getCellsViewSkin().resizeRowsToDefault();
    }

    public double getRowHeight(int row) {
        if (this.getCellsViewSkin() == null) {
            return this.getGrid().getRowHeight(row);
        }
        return this.getCellsViewSkin().getRowHeight(row);
    }

    public TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> getSelectionModel() {
        return this.cellsView.getSelectionModel();
    }

    public final Optional<SpreadsheetCellEditor> getEditor(SpreadsheetCellType<?> cellType) {
        SpreadsheetCellEditor cellEditor = this.editors.get(cellType);
        if (cellEditor == null) {
            cellEditor = cellType.createEditor(this);
            if (cellEditor == null) {
                return Optional.empty();
            }
            this.editors.put(cellType, cellEditor);
        }
        return Optional.of(cellEditor);
    }

    public final void setEditable(boolean b) {
        this.cellsView.setEditable(b);
    }

    public final boolean isEditable() {
        return this.cellsView.isEditable();
    }

    public final BooleanProperty editableProperty() {
        return this.cellsView.editableProperty();
    }

    public void copyClipboard() {
        this.checkFormat();
        ArrayList<GridChange> list = new ArrayList<GridChange>();
        ObservableList posList = this.getSelectionModel().getSelectedCells();
        for (TablePosition p : posList) {
            SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(p.getRow())).get(p.getColumn());
            list.add(new GridChange(cell.getRow(), cell.getColumn(), null, cell.getItem()));
        }
        ClipboardContent content = new ClipboardContent();
        content.put((Object)this.fmt, list);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public void pasteClipboard() {
        if (!this.isEditable()) {
            return;
        }
        this.checkFormat();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.getContent(this.fmt) != null) {
            ArrayList list = (ArrayList)clipboard.getContent(this.fmt);
            if (list.size() == 1) {
                GridChange change = (GridChange)list.get(0);
                for (TablePosition position : this.getSelectionModel().getSelectedCells()) {
                    SpreadsheetCell cell;
                    boolean succeed;
                    SpanType type = this.getSpanType(position.getRow(), position.getColumn());
                    if (type != SpanType.NORMAL_CELL && type != SpanType.ROW_VISIBLE || !(succeed = (cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(position.getRow())).get(position.getColumn())).getCellType().match(change.getNewValue()))) continue;
                    this.getGrid().setCellValue(cell.getRow(), cell.getColumn(), cell.getCellType().convertValue(change.getNewValue()));
                }
            } else {
                int minRow = this.getGrid().getRowCount();
                int minCol = this.getGrid().getColumnCount();
                int maxRow = 0;
                int maxCol = 0;
                for (GridChange p : list) {
                    int tempcol = p.getColumn();
                    int temprow = p.getRow();
                    if (tempcol < minCol) {
                        minCol = tempcol;
                    }
                    if (tempcol > maxCol) {
                        maxCol = tempcol;
                    }
                    if (temprow < minRow) {
                        minRow = temprow;
                    }
                    if (temprow <= maxRow) continue;
                    maxRow = temprow;
                }
                TablePosition p = this.cellsView.getFocusModel().getFocusedCell();
                int offsetRow = p.getRow() - minRow;
                int offsetCol = p.getColumn() - minCol;
                for (GridChange change : list) {
                    SpreadsheetCell cell;
                    boolean succeed;
                    SpanType type;
                    int row = change.getRow();
                    int column = change.getColumn();
                    if (row + offsetRow >= this.getGrid().getRowCount() || column + offsetCol >= this.getGrid().getColumnCount() || row + offsetRow < 0 || column + offsetCol < 0 || (type = this.getSpanType(row + offsetRow, column + offsetCol)) != SpanType.NORMAL_CELL && type != SpanType.ROW_VISIBLE || !(succeed = (cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(row + offsetRow)).get(column + offsetCol)).getCellType().match(change.getNewValue()))) continue;
                    this.getGrid().setCellValue(cell.getRow(), cell.getColumn(), cell.getCellType().convertValue(change.getNewValue()));
                }
            }
        } else if (clipboard.hasString()) {
            // empty if block
        }
    }

    public ContextMenu getSpreadsheetViewContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem copyItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.copy")));
        copyItem.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("copySpreadsheetView.png"))));
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copyItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SpreadsheetView.this.copyClipboard();
            }
        });
        MenuItem pasteItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.paste")));
        pasteItem.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("pasteSpreadsheetView.png"))));
        pasteItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        pasteItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SpreadsheetView.this.pasteClipboard();
            }
        });
        Menu cornerMenu = new Menu(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment")));
        cornerMenu.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("comment.png"))));
        MenuItem topLeftItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.top-left")));
        topLeftItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(pos.getRow())).get(pos.getColumn());
                cell.activateCorner(SpreadsheetCell.CornerPosition.TOP_LEFT);
            }
        });
        MenuItem topRightItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.top-right")));
        topRightItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(pos.getRow())).get(pos.getColumn());
                cell.activateCorner(SpreadsheetCell.CornerPosition.TOP_RIGHT);
            }
        });
        MenuItem bottomRightItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.bottom-right")));
        bottomRightItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(pos.getRow())).get(pos.getColumn());
                cell.activateCorner(SpreadsheetCell.CornerPosition.BOTTOM_RIGHT);
            }
        });
        MenuItem bottomLeftItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.bottom-left")));
        bottomLeftItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(pos.getRow())).get(pos.getColumn());
                cell.activateCorner(SpreadsheetCell.CornerPosition.BOTTOM_LEFT);
            }
        });
        cornerMenu.getItems().addAll((Object[])new MenuItem[]{topLeftItem, topRightItem, bottomRightItem, bottomLeftItem});
        contextMenu.getItems().addAll((Object[])new MenuItem[]{copyItem, pasteItem, cornerMenu});
        return contextMenu;
    }

    public void deleteSelectedCells() {
        for (TablePosition position : this.getSelectionModel().getSelectedCells()) {
            this.getGrid().setCellValue(position.getRow(), position.getColumn(), null);
        }
    }

    public SpanType getSpanType(int row, int column) {
        if (this.getGrid() == null) {
            return SpanType.NORMAL_CELL;
        }
        return this.getGrid().getSpanType(this, row, column);
    }

    private static Grid getSampleGrid() {
        GridBase gridBase = new GridBase(100, 15);
        ObservableList rows = FXCollections.observableArrayList();
        for (int row = 0; row < gridBase.getRowCount(); ++row) {
            ObservableList currentRow = FXCollections.observableArrayList();
            for (int column = 0; column < gridBase.getColumnCount(); ++column) {
                currentRow.add((Object)SpreadsheetCellType.STRING.createCell(row, column, 1, 1, ""));
            }
            rows.add(currentRow);
        }
        gridBase.setRows((Collection<ObservableList<SpreadsheetCell>>)rows);
        return gridBase;
    }

    private void initRowFix(Grid grid) {
        ObservableList<ObservableList<SpreadsheetCell>> rows = grid.getRows();
        this.rowFix = new BitSet(rows.size());
        block0: for (int r = 0; r < rows.size(); ++r) {
            ObservableList row = (ObservableList)rows.get(r);
            for (SpreadsheetCell cell : row) {
                if (cell.getRowSpan() <= 1) continue;
                continue block0;
            }
            this.rowFix.set(r);
        }
    }

    private void verifyGrid(Grid grid) {
        this.verifyColumnSpan(grid);
    }

    private void verifyColumnSpan(Grid grid) {
        for (int i = 0; i < grid.getRows().size(); ++i) {
            ObservableList row = (ObservableList)grid.getRows().get(i);
            int count = 0;
            for (int j = 0; j < row.size(); ++j) {
                if (((SpreadsheetCell)row.get(j)).getColumnSpan() == 1) {
                    ++count;
                    continue;
                }
                if (((SpreadsheetCell)row.get(j)).getColumnSpan() > 1) {
                    ++count;
                    SpreadsheetCell currentCell = (SpreadsheetCell)row.get(j);
                    for (int k = j + 1; k < currentCell.getColumn() + currentCell.getColumnSpan(); ++k) {
                        if (!((SpreadsheetCell)row.get(k)).equals(currentCell)) {
                            throw new IllegalStateException("\n At row " + i + " and column " + j + ": this cell is in the range of a columnSpan but is different. \n" + "Every cell in a range of a ColumnSpan must be of the same instance.");
                        }
                        ++count;
                        ++j;
                    }
                    continue;
                }
                throw new IllegalStateException("\n At row " + i + " and column " + j + ": this cell has a negative columnSpan");
            }
            if (count == grid.getColumnCount()) continue;
            throw new IllegalStateException("The row" + i + " has a number of cells different of the columnCount declared in the grid.");
        }
    }

    private void checkFormat() {
        this.fmt = DataFormat.lookupMimeType((String)"SpreadsheetView");
        if (this.fmt == null) {
            this.fmt = new DataFormat(new String[]{"SpreadsheetView"});
        }
    }

    private String computeReason(List<? extends Integer> list) {
        String reason = "\n A row cannot be fixed. \n";
        for (Integer n : list) {
            if (this.isRowFixable(n)) continue;
            int maxSpan = 1;
            List gridRow = (List)this.getGrid().getRows().get(n.intValue());
            for (SpreadsheetCell cell : gridRow) {
                if (!list.contains(cell.getRow())) {
                    reason = reason + "The row " + n + " is inside a row span and the starting row " + cell.getRow() + " is not fixed.\n";
                }
                if (cell.getRowSpan() <= maxSpan || cell.getRow() != n.intValue()) continue;
                maxSpan = cell.getRowSpan();
            }
            int count = n + maxSpan - 1;
            for (int index = n + 1; index < count; ++index) {
                if (list.contains(index)) continue;
                reason = reason + "One cell on the row " + n + " has a row span of " + maxSpan + ". " + "But the row " + index + " contained within that span is not fixed.\n";
            }
        }
        return reason;
    }

    public static enum SpanType {
        NORMAL_CELL,
        COLUMN_SPAN_INVISIBLE,
        ROW_SPAN_INVISIBLE,
        ROW_VISIBLE,
        BOTH_INVISIBLE;

    }
}

