/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import com.sun.javafx.event.EventHandlerManager;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.GridChange;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridBase
implements Grid,
EventTarget {
    private ObservableList<ObservableList<SpreadsheetCell>> rows;
    private int rowCount;
    private int columnCount;
    private Callback<Integer, Double> rowHeightFactory;
    private final BooleanProperty locked;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private final ObservableList<String> rowsHeader;
    private final ObservableList<String> columnsHeader;

    public GridBase(int rowCount, int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.rowsHeader = FXCollections.observableArrayList();
        this.columnsHeader = FXCollections.observableArrayList();
        this.locked = new SimpleBooleanProperty(false);
        this.rowHeightFactory = new MapBasedRowHeightFactory(new HashMap<Integer, Double>());
    }

    @Override
    public ObservableList<ObservableList<SpreadsheetCell>> getRows() {
        return this.rows;
    }

    @Override
    public void setCellValue(int row, int column, Object value) {
        if (row < this.rowCount && column < this.columnCount && !this.isLocked()) {
            SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getRows().get(row)).get(column);
            Object previousItem = cell.getItem();
            Object convertedValue = cell.getCellType().convertValue(value);
            cell.setItem(convertedValue);
            if (!Objects.equals(previousItem, cell.getItem())) {
                GridChange cellChange = new GridChange(row, column, previousItem, convertedValue);
                Event.fireEvent((EventTarget)this, (Event)cellChange);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public SpreadsheetView.SpanType getSpanType(SpreadsheetView spv, int row, int column) {
        if (row < 0 || column < 0) {
            return SpreadsheetView.SpanType.NORMAL_CELL;
        }
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getRows().get(row)).get(column);
        int cellColumn = cell.getColumn();
        int cellRow = cell.getRow();
        int cellRowSpan = cell.getRowSpan();
        if (cellColumn == column && cellRow == row && cellRowSpan == 1) {
            return SpreadsheetView.SpanType.NORMAL_CELL;
        }
        int cellColumnSpan = cell.getColumnSpan();
        boolean containsRowMinusOne = spv.getCellsViewSkin().containsRow(row - 1);
        if (containsRowMinusOne && cellColumnSpan > 1 && cellColumn != column && cellRowSpan > 1 && cellRow != row) {
            return SpreadsheetView.SpanType.BOTH_INVISIBLE;
        }
        if (cellRowSpan > 1 && cellColumn == column) {
            if (cellRow == row || !containsRowMinusOne) {
                return SpreadsheetView.SpanType.ROW_VISIBLE;
            }
            return SpreadsheetView.SpanType.ROW_SPAN_INVISIBLE;
        }
        if (!(cellColumnSpan <= 1 || cellColumn == column || cellRow != row && containsRowMinusOne)) {
            return SpreadsheetView.SpanType.COLUMN_SPAN_INVISIBLE;
        }
        return SpreadsheetView.SpanType.NORMAL_CELL;
    }

    @Override
    public double getRowHeight(int row) {
        return (Double)this.rowHeightFactory.call((Object)row);
    }

    public void setRowHeightCallback(Callback<Integer, Double> rowHeight) {
        this.rowHeightFactory = rowHeight;
    }

    @Override
    public ObservableList<String> getRowHeaders() {
        return this.rowsHeader;
    }

    @Override
    public ObservableList<String> getColumnHeaders() {
        return this.columnsHeader;
    }

    public BooleanProperty lockedProperty() {
        return this.locked;
    }

    public boolean isLocked() {
        return this.locked.get();
    }

    public void setLocked(Boolean lock) {
        this.locked.setValue(lock);
    }

    @Override
    public void spanRow(int count, int rowIndex, int colIndex) {
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.rows.get(rowIndex)).get(colIndex);
        int colSpan = cell.getColumnSpan();
        int rowSpan = count;
        cell.setRowSpan(rowSpan);
        for (int row = rowIndex; row < rowIndex + rowSpan && row < this.rowCount; ++row) {
            for (int col = colIndex; col < colIndex + colSpan && col < this.columnCount; ++col) {
                if (row == rowIndex && col == colIndex) continue;
                ((ObservableList)this.rows.get(row)).set(col, (Object)cell);
            }
        }
    }

    @Override
    public void spanColumn(int count, int rowIndex, int colIndex) {
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.rows.get(rowIndex)).get(colIndex);
        int colSpan = count;
        int rowSpan = cell.getRowSpan();
        cell.setColumnSpan(colSpan);
        for (int row = rowIndex; row < rowIndex + rowSpan && row < this.rowCount; ++row) {
            for (int col = colIndex; col < colIndex + colSpan && col < this.columnCount; ++col) {
                if (row == rowIndex && col == colIndex) continue;
                ((ObservableList)this.rows.get(row)).set(col, (Object)cell);
            }
        }
    }

    @Override
    public void setRows(Collection<ObservableList<SpreadsheetCell>> rows) {
        this.rows = rows instanceof ObservableList ? (ObservableList)rows : FXCollections.observableArrayList(rows);
        this.setRowCount(rows.size());
        this.setColumnCount(this.rowCount == 0 ? 0 : ((ObservableList)this.rows.get(0)).size());
    }

    @Override
    public <E extends GridChange> void addEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    @Override
    public <E extends GridChange> void removeEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.append((EventDispatcher)this.eventHandlerManager);
    }

    private void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    private void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public static class MapBasedRowHeightFactory
    implements Callback<Integer, Double> {
        private final Map<Integer, Double> rowHeightMap;

        public MapBasedRowHeightFactory(Map<Integer, Double> rowHeightMap) {
            this.rowHeightMap = rowHeightMap;
        }

        public Double call(Integer index) {
            Double value = this.rowHeightMap.get(index);
            return value == null ? GridViewSkin.DEFAULT_CELL_HEIGHT : value;
        }
    }
}

