/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.MasterDetailPaneSkin;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import org.controlsfx.control.ControlsFXControl;

public class MasterDetailPane
extends ControlsFXControl {
    private final ObjectProperty<Side> detailSide = new SimpleObjectProperty((Object)this, "detailSide", (Object)Side.RIGHT);
    private final BooleanProperty showDetailNode = new SimpleBooleanProperty((Object)this, "showDetailNode", true);
    private final ObjectProperty<Node> masterNode = new SimpleObjectProperty((Object)this, "masterNode");
    private final ObjectProperty<Node> detailNode = new SimpleObjectProperty((Object)this, "detailNode");
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", true);
    private DoubleProperty dividerPosition = new SimpleDoubleProperty((Object)this, "dividerPosition", 0.33);

    public MasterDetailPane(Side side, Node masterNode, Node detailNode, boolean showDetail) {
        Objects.requireNonNull(side);
        Objects.requireNonNull(masterNode);
        Objects.requireNonNull(detailNode);
        this.getStyleClass().add((Object)"master-detail-pane");
        this.setDetailSide(side);
        this.setMasterNode(masterNode);
        this.setDetailNode(detailNode);
        this.setShowDetailNode(showDetail);
        switch (side) {
            case BOTTOM: 
            case RIGHT: {
                this.setDividerPosition(0.8);
                break;
            }
            case TOP: 
            case LEFT: {
                this.setDividerPosition(0.2);
                break;
            }
        }
    }

    public MasterDetailPane(Side pos, boolean showDetail) {
        this(pos, (Node)new Placeholder(true), (Node)new Placeholder(false), showDetail);
    }

    public MasterDetailPane(Side pos) {
        this(pos, (Node)new Placeholder(true), (Node)new Placeholder(false), true);
    }

    public MasterDetailPane() {
        this(Side.RIGHT, (Node)new Placeholder(true), (Node)new Placeholder(false), true);
    }

    protected Skin<?> createDefaultSkin() {
        return new MasterDetailPaneSkin(this);
    }

    public final ObjectProperty<Side> detailSideProperty() {
        return this.detailSide;
    }

    public final Side getDetailSide() {
        return (Side)this.detailSideProperty().get();
    }

    public final void setDetailSide(Side side) {
        Objects.requireNonNull(side);
        this.detailSideProperty().set((Object)side);
    }

    public final BooleanProperty showDetailNodeProperty() {
        return this.showDetailNode;
    }

    public final boolean isShowDetailNode() {
        return this.showDetailNodeProperty().get();
    }

    public final void setShowDetailNode(boolean show) {
        this.showDetailNodeProperty().set(show);
    }

    public final ObjectProperty<Node> masterNodeProperty() {
        return this.masterNode;
    }

    public final Node getMasterNode() {
        return (Node)this.masterNodeProperty().get();
    }

    public final void setMasterNode(Node node) {
        Objects.requireNonNull(node);
        this.masterNodeProperty().set((Object)node);
    }

    public final ObjectProperty<Node> detailNodeProperty() {
        return this.detailNode;
    }

    public final Node getDetailNode() {
        return (Node)this.detailNodeProperty().get();
    }

    public final void setDetailNode(Node node) {
        Objects.requireNonNull(node);
        this.detailNodeProperty().set((Object)node);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    public final void setAnimated(boolean animated) {
        this.animatedProperty().set(animated);
    }

    public final DoubleProperty dividerPositionProperty() {
        return this.dividerPosition;
    }

    public final double getDividerPosition() {
        return this.dividerPosition.get();
    }

    public final void setDividerPosition(double position) {
        if (this.getDividerPosition() == position) {
            this.dividerPosition.set(-1.0);
        }
        this.dividerPosition.set(position);
    }

    private static final class Placeholder
    extends Label {
        public Placeholder(boolean master) {
            super(master ? "Master" : "Detail");
            this.setAlignment(Pos.CENTER);
            if (master) {
                this.setStyle("-fx-background-color: -fx-background;");
            } else {
                this.setStyle("-fx-background-color: derive(-fx-background, -10%);");
            }
        }
    }
}

