/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRowSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.scene.control.TableRow;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRow
extends TableRow<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;
    DoubleProperty verticalShift = new SimpleDoubleProperty();
    private final InvalidationListener setPrefHeightListener = new InvalidationListener(){

        public void invalidated(Observable o) {
            GridRow.this.setRowHeight(GridRow.this.computePrefHeight(-1.0));
        }
    };

    public GridRow(SpreadsheetHandle handle) {
        this.handle = handle;
        this.indexProperty().addListener(this.setPrefHeightListener);
        this.visibleProperty().addListener(this.setPrefHeightListener);
        handle.getView().gridProperty().addListener(this.setPrefHeightListener);
        handle.getCellsViewSkin().rowHeightMap.addListener((MapChangeListener)new MapChangeListener<Integer, Double>(){

            public void onChanged(MapChangeListener.Change<? extends Integer, ? extends Double> change) {
                if (change.wasAdded() && ((Integer)change.getKey()).intValue() == GridRow.this.getIndex()) {
                    GridRow.this.setRowHeight((Double)change.getValueAdded());
                } else if (change.wasRemoved() && ((Integer)change.getKey()).intValue() == GridRow.this.getIndex()) {
                    GridRow.this.setRowHeight(GridRow.this.computePrefHeight(-1.0));
                }
            }
        });
    }

    void addCell(CellView cell) {
        this.getChildren().add((Object)cell);
    }

    void removeCell(CellView gc) {
        this.getChildren().remove((Object)gc);
    }

    SpreadsheetView getSpreadsheetView() {
        return this.handle.getView();
    }

    protected double computePrefHeight(double width) {
        return this.handle.getCellsViewSkin().getRowHeight(this.getIndex());
    }

    protected double computeMinHeight(double width) {
        return this.handle.getCellsViewSkin().getRowHeight(this.getIndex());
    }

    protected Skin<?> createDefaultSkin() {
        return new GridRowSkin(this.handle, this);
    }

    private void setRowHeight(double height) {
        this.setHeight(height);
        this.setPrefHeight(height);
    }
}

