/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import impl.org.controlsfx.skin.NotificationBar;
import java.util.Collections;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.Action;

public class NotificationPaneSkin
extends BehaviorSkinBase<NotificationPane, BehaviorBase<NotificationPane>> {
    private NotificationBar notificationBar;
    private Node content;
    private Rectangle clip = new Rectangle();

    public NotificationPaneSkin(final NotificationPane control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.notificationBar = new NotificationBar(){

            @Override
            public void requestContainerLayout() {
                control.requestLayout();
            }

            @Override
            public String getText() {
                return control.getText();
            }

            @Override
            public Node getGraphic() {
                return control.getGraphic();
            }

            @Override
            public ObservableList<Action> getActions() {
                return control.getActions();
            }

            @Override
            public boolean isShowing() {
                return control.isShowing();
            }

            @Override
            public boolean isShowFromTop() {
                return control.isShowFromTop();
            }

            @Override
            public void hide() {
                control.hide();
            }

            @Override
            public double getContainerHeight() {
                return control.getHeight();
            }

            @Override
            public void relocateInParent(double x, double y) {
                NotificationPaneSkin.this.notificationBar.relocate(x, y);
            }
        };
        control.setClip((Node)this.clip);
        this.updateContent();
        this.registerChangeListener((ObservableValue)control.contentProperty(), "CONTENT");
        this.registerChangeListener((ObservableValue)control.textProperty(), "TEXT");
        this.registerChangeListener((ObservableValue)control.graphicProperty(), "GRAPHIC");
        this.registerChangeListener((ObservableValue)control.showingProperty(), "SHOWING");
        this.registerChangeListener((ObservableValue)control.showFromTopProperty(), "SHOW_FROM_TOP");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("CONTENT".equals(p)) {
            this.updateContent();
        } else if ("TEXT".equals(p)) {
            this.notificationBar.label.setText(((NotificationPane)this.getSkinnable()).getText());
        } else if ("GRAPHIC".equals(p)) {
            this.notificationBar.label.setGraphic(((NotificationPane)this.getSkinnable()).getGraphic());
        } else if ("SHOWING".equals(p)) {
            if (((NotificationPane)this.getSkinnable()).isShowing()) {
                this.notificationBar.doShow();
            } else {
                this.notificationBar.doHide();
            }
        } else if ("SHOW_FROM_TOP".equals(p) && ((NotificationPane)this.getSkinnable()).isShowing()) {
            ((NotificationPane)this.getSkinnable()).requestLayout();
        }
    }

    private void updateContent() {
        if (this.content != null) {
            this.getChildren().remove((Object)this.content);
        }
        this.content = ((NotificationPane)this.getSkinnable()).getContent();
        if (this.content == null) {
            this.getChildren().setAll((Object[])new Node[]{this.notificationBar});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.content, this.notificationBar});
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double notificationBarHeight = this.notificationBar.prefHeight(w);
        this.notificationBar.resize(w, notificationBarHeight);
        if (this.content != null) {
            this.content.resizeRelocate(x, y, w, h);
        }
        this.clip.setX(x);
        this.clip.setY(y);
        this.clip.setWidth(w);
        this.clip.setHeight(h);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.minWidth(height);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.minHeight(width);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.prefWidth(height);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.prefHeight(width);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.maxWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.maxHeight(width);
    }

    static {
        StyleManager.getInstance().addUserAgentStylesheet(NotificationPane.class.getResource("notificationpane.css").toExternalForm());
    }
}

