/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.css.StyleManager;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import org.controlsfx.control.MasterDetailPane;

public class MasterDetailPaneSkin
extends SkinBase<MasterDetailPane> {
    private boolean changing = false;
    private SplitPane splitPane;
    private Timeline timeline;
    private InvalidationListener listenersDivider = new InvalidationListener(){

        public void invalidated(Observable arg0) {
            MasterDetailPaneSkin.this.changing = true;
            MasterDetailPaneSkin.this.splitPane.setDividerPosition(0, ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDividerPosition());
            MasterDetailPaneSkin.this.changing = false;
        }
    };
    private ChangeListener<Number> updateDividerPositionListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
            if (!MasterDetailPaneSkin.this.changing) {
                ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).setDividerPosition(t1.doubleValue());
            }
        }
    };

    public MasterDetailPaneSkin(MasterDetailPane pane) {
        super((Control)pane);
        this.splitPane = new SplitPane();
        this.splitPane.setDividerPosition(0, pane.getDividerPosition());
        this.splitPane.getDividers().addListener((ListChangeListener)new ListChangeListener<SplitPane.Divider>(){

            public void onChanged(ListChangeListener.Change<? extends SplitPane.Divider> change) {
                while (change.next()) {
                    if (change.wasAdded()) {
                        ((SplitPane.Divider)change.getAddedSubList().get(0)).positionProperty().addListener(MasterDetailPaneSkin.this.updateDividerPositionListener);
                        continue;
                    }
                    if (!change.wasRemoved()) continue;
                    ((SplitPane.Divider)change.getRemoved().get(0)).positionProperty().removeListener(MasterDetailPaneSkin.this.updateDividerPositionListener);
                }
            }
        });
        SplitPane.setResizableWithParent((Node)((MasterDetailPane)this.getSkinnable()).getDetailNode(), (Boolean)false);
        switch (((MasterDetailPane)this.getSkinnable()).getDetailSide()) {
            case BOTTOM: 
            case TOP: {
                this.splitPane.setOrientation(Orientation.VERTICAL);
                break;
            }
            case LEFT: 
            case RIGHT: {
                this.splitPane.setOrientation(Orientation.HORIZONTAL);
            }
        }
        ((MasterDetailPane)this.getSkinnable()).masterNodeProperty().addListener((ChangeListener)new ChangeListener<Node>(){

            public void changed(ObservableValue<? extends Node> value, Node oldNode, Node newNode) {
                if (oldNode != null) {
                    MasterDetailPaneSkin.this.splitPane.getItems().remove((Object)oldNode);
                }
                if (newNode != null) {
                    MasterDetailPaneSkin.this.updateMinAndMaxSizes();
                    int masterIndex = 0;
                    block0 : switch (MasterDetailPaneSkin.this.splitPane.getOrientation()) {
                        case HORIZONTAL: {
                            switch (((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailSide()) {
                                case LEFT: {
                                    masterIndex = 1;
                                    break block0;
                                }
                                case RIGHT: {
                                    masterIndex = 0;
                                    break block0;
                                }
                            }
                            throw new IllegalArgumentException("illegal details position " + ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailSide() + " for orientation " + MasterDetailPaneSkin.this.splitPane.getOrientation());
                        }
                        case VERTICAL: {
                            switch (((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailSide()) {
                                case TOP: {
                                    masterIndex = 1;
                                    break block0;
                                }
                                case BOTTOM: {
                                    masterIndex = 0;
                                    break block0;
                                }
                            }
                            throw new IllegalArgumentException("illegal details position " + ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailSide() + " for orientation " + MasterDetailPaneSkin.this.splitPane.getOrientation());
                        }
                    }
                    ObservableList items = MasterDetailPaneSkin.this.splitPane.getItems();
                    if (items.isEmpty()) {
                        items.add(newNode);
                    } else {
                        items.add(masterIndex, newNode);
                    }
                }
            }
        });
        ((MasterDetailPane)this.getSkinnable()).detailNodeProperty().addListener((ChangeListener)new ChangeListener<Node>(){

            public void changed(ObservableValue<? extends Node> value, Node oldNode, Node newNode) {
                if (oldNode != null) {
                    MasterDetailPaneSkin.this.splitPane.getItems().remove((Object)oldNode);
                }
                if (newNode != null && ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).isShowDetailNode()) {
                    MasterDetailPaneSkin.this.splitPane.setDividerPositions(new double[]{((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDividerPosition()});
                    MasterDetailPaneSkin.this.updateMinAndMaxSizes();
                    SplitPane.setResizableWithParent((Node)newNode, (Boolean)false);
                    int detailsIndex = 0;
                    block0 : switch (MasterDetailPaneSkin.this.splitPane.getOrientation()) {
                        case HORIZONTAL: {
                            switch (((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailSide()) {
                                case LEFT: {
                                    detailsIndex = 0;
                                    break block0;
                                }
                                case RIGHT: {
                                    detailsIndex = 1;
                                    break block0;
                                }
                            }
                            throw new IllegalArgumentException("illegal details position " + ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailSide() + " for orientation " + MasterDetailPaneSkin.this.splitPane.getOrientation());
                        }
                        case VERTICAL: {
                            switch (((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailSide()) {
                                case TOP: {
                                    detailsIndex = 0;
                                    break block0;
                                }
                                case BOTTOM: {
                                    detailsIndex = 1;
                                    break block0;
                                }
                            }
                            throw new IllegalArgumentException("illegal details position " + ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailSide() + " for orientation " + MasterDetailPaneSkin.this.splitPane.getOrientation());
                        }
                    }
                    ObservableList items = MasterDetailPaneSkin.this.splitPane.getItems();
                    if (items.isEmpty()) {
                        items.add(newNode);
                    } else {
                        items.add(detailsIndex, newNode);
                    }
                }
            }
        });
        ((MasterDetailPane)this.getSkinnable()).showDetailNodeProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> value, Boolean oldShow, Boolean newShow) {
                if (newShow.booleanValue()) {
                    MasterDetailPaneSkin.this.open();
                } else {
                    MasterDetailPaneSkin.this.close();
                }
            }
        });
        ((MasterDetailPane)this.getSkinnable()).detailSideProperty().addListener((ChangeListener)new ChangeListener<Side>(){

            public void changed(ObservableValue<? extends Side> value, Side oldPos, Side newPos) {
                if (((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).isShowDetailNode()) {
                    MasterDetailPaneSkin.this.splitPane.getItems().clear();
                }
                switch (newPos) {
                    case BOTTOM: 
                    case TOP: {
                        MasterDetailPaneSkin.this.splitPane.setOrientation(Orientation.VERTICAL);
                        break;
                    }
                    case LEFT: 
                    case RIGHT: {
                        MasterDetailPaneSkin.this.splitPane.setOrientation(Orientation.HORIZONTAL);
                    }
                }
                block4 : switch (newPos) {
                    case TOP: 
                    case LEFT: {
                        if (((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).isShowDetailNode()) {
                            MasterDetailPaneSkin.this.splitPane.getItems().add((Object)((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailNode());
                            MasterDetailPaneSkin.this.splitPane.getItems().add((Object)((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getMasterNode());
                        }
                        switch (oldPos) {
                            case BOTTOM: 
                            case RIGHT: {
                                ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).setDividerPosition(1.0 - ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDividerPosition());
                                break block4;
                            }
                        }
                        break;
                    }
                    case BOTTOM: 
                    case RIGHT: {
                        if (((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).isShowDetailNode()) {
                            MasterDetailPaneSkin.this.splitPane.getItems().add((Object)((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getMasterNode());
                            MasterDetailPaneSkin.this.splitPane.getItems().add((Object)((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailNode());
                        }
                        switch (oldPos) {
                            case TOP: 
                            case LEFT: {
                                ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).setDividerPosition(1.0 - ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDividerPosition());
                                break block4;
                            }
                        }
                    }
                }
                if (((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).isShowDetailNode()) {
                    MasterDetailPaneSkin.this.splitPane.setDividerPositions(new double[]{((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDividerPosition()});
                }
            }
        });
        this.updateMinAndMaxSizes();
        this.getChildren().add((Object)this.splitPane);
        this.splitPane.getItems().add((Object)((MasterDetailPane)this.getSkinnable()).getMasterNode());
        if (((MasterDetailPane)this.getSkinnable()).isShowDetailNode()) {
            switch (((MasterDetailPane)this.getSkinnable()).getDetailSide()) {
                case TOP: 
                case LEFT: {
                    this.splitPane.getItems().add(0, (Object)((MasterDetailPane)this.getSkinnable()).getDetailNode());
                    break;
                }
                case BOTTOM: 
                case RIGHT: {
                    this.splitPane.getItems().add((Object)((MasterDetailPane)this.getSkinnable()).getDetailNode());
                }
            }
            this.bindDividerPosition();
        }
    }

    private void bindDividerPosition() {
        ((MasterDetailPane)this.getSkinnable()).dividerPositionProperty().addListener(this.listenersDivider);
    }

    private void unbindDividerPosition() {
        ((MasterDetailPane)this.getSkinnable()).dividerPositionProperty().removeListener(this.listenersDivider);
    }

    private void updateMinAndMaxSizes() {
        if (((MasterDetailPane)this.getSkinnable()).getMasterNode() instanceof Region) {
            ((Region)((MasterDetailPane)this.getSkinnable()).getMasterNode()).setMinSize(0.0, 0.0);
            ((Region)((MasterDetailPane)this.getSkinnable()).getMasterNode()).setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (((MasterDetailPane)this.getSkinnable()).getDetailNode() instanceof Region) {
            ((Region)((MasterDetailPane)this.getSkinnable()).getDetailNode()).setMinSize(0.0, 0.0);
            ((Region)((MasterDetailPane)this.getSkinnable()).getDetailNode()).setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        }
    }

    private void open() {
        this.changing = true;
        Node node = ((MasterDetailPane)this.getSkinnable()).getDetailNode();
        switch (((MasterDetailPane)this.getSkinnable()).getDetailSide()) {
            case TOP: 
            case LEFT: {
                this.splitPane.getItems().add(0, (Object)node);
                this.splitPane.setDividerPositions(new double[]{0.0});
                break;
            }
            case BOTTOM: 
            case RIGHT: {
                this.splitPane.getItems().add((Object)node);
                this.splitPane.setDividerPositions(new double[]{1.0});
            }
        }
        this.updateMinAndMaxSizes();
        this.maybeAnimatePositionChange(((MasterDetailPane)this.getSkinnable()).getDividerPosition(), true);
    }

    private void close() {
        this.changing = true;
        if (!this.splitPane.getDividers().isEmpty()) {
            double targetLocation = 0.0;
            switch (((MasterDetailPane)this.getSkinnable()).getDetailSide()) {
                case BOTTOM: 
                case RIGHT: {
                    targetLocation = 1.0;
                    break;
                }
            }
            this.maybeAnimatePositionChange(targetLocation, false);
        }
    }

    private void maybeAnimatePositionChange(double position, final boolean showDetail) {
        SplitPane.Divider divider = (SplitPane.Divider)this.splitPane.getDividers().get(0);
        if (((MasterDetailPane)this.getSkinnable()).isAnimated()) {
            if (showDetail) {
                this.unbindDividerPosition();
                this.bindDividerPosition();
            }
            KeyValue positionKeyValue = new KeyValue((WritableValue)divider.positionProperty(), (Object)position);
            KeyValue opacityKeyValue = new KeyValue((WritableValue)((MasterDetailPane)this.getSkinnable()).getDetailNode().opacityProperty(), (Object)(showDetail ? 1 : 0));
            KeyFrame keyFrame = new KeyFrame(Duration.seconds((double)0.1), new KeyValue[]{positionKeyValue, opacityKeyValue});
            this.timeline = new Timeline(new KeyFrame[]{keyFrame});
            this.timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent evt) {
                    if (!showDetail) {
                        MasterDetailPaneSkin.this.unbindDividerPosition();
                        MasterDetailPaneSkin.this.splitPane.getItems().remove((Object)((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailNode());
                        ((MasterDetailPane)MasterDetailPaneSkin.this.getSkinnable()).getDetailNode().setOpacity(1.0);
                    }
                    MasterDetailPaneSkin.this.changing = false;
                }
            });
            this.timeline.play();
        } else {
            if (showDetail) {
                this.unbindDividerPosition();
                this.bindDividerPosition();
            }
            ((MasterDetailPane)this.getSkinnable()).getDetailNode().setOpacity(1.0);
            divider.setPosition(position);
            if (!showDetail) {
                this.unbindDividerPosition();
                this.splitPane.getItems().remove((Object)((MasterDetailPane)this.getSkinnable()).getDetailNode());
            }
            this.changing = false;
        }
    }

    static {
        StyleManager.getInstance().addUserAgentStylesheet(MasterDetailPane.class.getResource("masterdetailpane.css").toExternalForm());
    }
}

