
package prettyprintervsclassicocl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
public class PivotAndPrettyPrinter {
    private EPackage modelPackage = null;
    public EClass eClass = null;
    public EAttribute eAttribute1 = null;
    public EAttribute eAttribute2 = null;
    private String oclDelegateURI = OCLDelegateDomain.OCL_DELEGATE_URI_PIVOT;
    public ResourceSet ecoreResourceSet;
    private OCLSettingDelegateFactory settingFactory;
    public Resource resource;
    public String oclToRefactor = "--mycomment \r\n if 1=1 then \r\n          2*(t2 + 1)      \r\n else \r\n 0 \r\n endif";
    public PivotAndPrettyPrinter() {
    	settingFactory = new OCLSettingDelegateFactory.Global();
        EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put
        (oclDelegateURI, new OCLInvocationDelegateFactory.Global());
        EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put(oclDelegateURI, settingFactory);
    	makeMataModel();    
    } 
    
    private void makeMataModel() {
         modelPackage = EcoreFactory.eINSTANCE.createEPackage();
         modelPackage.setName("temp");
         modelPackage.setNsPrefix("Test");
         modelPackage.setNsURI("http://www.eclipse.org/mdt/ocl/oclinecore/tutorial");
         EAnnotation mainOCLAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
         mainOCLAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
         mainOCLAnnotation.getDetails().put("invocationDelegates", oclDelegateURI);
         mainOCLAnnotation.getDetails().put("settingDelegates", oclDelegateURI);
         mainOCLAnnotation.getDetails().put("validationDelegates", oclDelegateURI);
         modelPackage.getEAnnotations().add(mainOCLAnnotation);
         eClass = EcoreFactory.eINSTANCE.createEClass();
         eClass.setName("TestClass");
         
         eAttribute1= EcoreFactory.eINSTANCE.createEAttribute();
         eAttribute1.setName("t1");
         eAttribute1.setUpperBound(1);
         eAttribute1.setLowerBound(1);
         eAttribute1.setEType(EcorePackage.eINSTANCE.getEDoubleObject());
         eAttribute1.setDerived(true);
         eAttribute1.setVolatile(true);
         EAnnotation driveAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
         driveAnnotation.setSource(oclDelegateURI);
         driveAnnotation.getDetails().put("derivation", oclToRefactor);
         eAttribute1.getEAnnotations().add(driveAnnotation);
         eClass.getEStructuralFeatures().add(eAttribute1);
         
         eAttribute2= EcoreFactory.eINSTANCE.createEAttribute();
         eAttribute2.setName("t2");
         eAttribute2.setUpperBound(1);
         eAttribute2.setLowerBound(1);
         eAttribute2.setEType(EcorePackage.eINSTANCE.getEDoubleObject());
         eAttribute2.setDerived(true);
         eAttribute2.setVolatile(true);
         EAnnotation driveAnnotation1 = EcoreFactory.eINSTANCE.createEAnnotation();
         driveAnnotation1.setSource(oclDelegateURI);
         driveAnnotation1.getDetails().put("derivation", "2*2");
         eAttribute2.getEAnnotations().add(driveAnnotation1);
         eClass.getEStructuralFeatures().add(eAttribute2); 
         
         modelPackage.getEClassifiers().add(eClass);
         URI uri1 = URI.createFileURI("c:\\pivot\\test.ecore");
         ecoreResourceSet = new ResourceSetImpl();
         ecoreResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
         resource = ecoreResourceSet.createResource(uri1);
         resource.getContents().add(modelPackage);        
          
    }
    
    /*
     * here i want to rename eAttribute2 but before that i want to change the OCL statement of t1 to use new name of t2
     */    
    
    public void renameAttributeWithOCLStatementUsingPivotOCL() {
    	
		org.eclipse.ocl.examples.pivot.OCL ocl = org.eclipse.ocl.examples.pivot.OCL.newInstance(new PivotEnvironmentFactory());
		org.eclipse.ocl.examples.pivot.helper.OCLHelper helper = ocl.createOCLHelper();

		
		helper.setContext(eClass);
		ExpressionInOCL expression;
		try {
			expression = helper.createQuery(oclToRefactor);
			String oclStmt = MyPrettyPrinter.print(expression, eAttribute2, "newT");
			System.out.println(oclStmt);
		} catch (ParserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
    }
    
 
}
 