
package prettyprintervsclassicocl;

import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.utilities.AbstractVisitor;
public class ClassicOCL {
    private EPackage modelPackage = null;
    public EClass eClass = null;
    public EAttribute eAttribute1 = null;
    public EAttribute eAttribute2 = null;
    private String oclDelegateURI = OCLDelegateDomain.OCL_DELEGATE_URI;
    public ResourceSet ecoreResourceSet;
    public Resource resource;
    public String oclToRefactor = "--mycomment \r\n if 1=1 then \r\n          2*(t2 + 1)      \r\n else \r\n 0 \r\n endif";
    public ClassicOCL() {
    	makeMataModel();    
    }    
    private void makeMataModel() {
         modelPackage = EcoreFactory.eINSTANCE.createEPackage();
         modelPackage.setName("temp");
         modelPackage.setNsPrefix("Test");
         modelPackage.setNsURI("http://www.eclipse.org/mdt/ocl/oclinecore/tutorial");
         EAnnotation mainOCLAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
         mainOCLAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
         mainOCLAnnotation.getDetails().put("invocationDelegates", oclDelegateURI);
         mainOCLAnnotation.getDetails().put("settingDelegates", oclDelegateURI);
         mainOCLAnnotation.getDetails().put("validationDelegates", oclDelegateURI);
         modelPackage.getEAnnotations().add(mainOCLAnnotation);
         eClass = EcoreFactory.eINSTANCE.createEClass();
         eClass.setName("TestClass");
         
         eAttribute1= EcoreFactory.eINSTANCE.createEAttribute();
         eAttribute1.setName("t1");
         eAttribute1.setUpperBound(1);
         eAttribute1.setLowerBound(1);
         eAttribute1.setEType(EcorePackage.eINSTANCE.getEDoubleObject());
         eAttribute1.setDerived(true);
         eAttribute1.setVolatile(true);
         EAnnotation driveAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
         driveAnnotation.setSource(oclDelegateURI);
         driveAnnotation.getDetails().put("derivation", oclToRefactor);
         eAttribute1.getEAnnotations().add(driveAnnotation);
         eClass.getEStructuralFeatures().add(eAttribute1);
         
         
         eAttribute2= EcoreFactory.eINSTANCE.createEAttribute();
         eAttribute2.setName("t2");
         eAttribute2.setUpperBound(1);
         eAttribute2.setLowerBound(1);
         eAttribute2.setEType(EcorePackage.eINSTANCE.getEDoubleObject());
         eAttribute2.setDerived(true);
         eAttribute2.setVolatile(true);
         EAnnotation driveAnnotation1 = EcoreFactory.eINSTANCE.createEAnnotation();
         driveAnnotation1.setSource(oclDelegateURI);
         //driveAnnotation1.getDetails().put("derivation", "self.opt()");
         driveAnnotation1.getDetails().put("derivation", "2*2");
         eAttribute2.getEAnnotations().add(driveAnnotation1);
         eClass.getEStructuralFeatures().add(eAttribute2);         
         
         
         modelPackage.getEClassifiers().add(eClass);
         URI uri1 = URI.createFileURI("test.ecore");
         ecoreResourceSet = new ResourceSetImpl();
         ecoreResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
         resource = ecoreResourceSet.createResource(uri1);
         resource.getContents().add(modelPackage);
          
    }
    
    /*
     * here i want to rename eAttribute2 but before that i want to change the OCL statement of t1 to use new name of t2
     */
    public void renameAttributeWithOCLStatementUsingClassicOCL() {
        OCL<?, EClassifier, EOperation, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> ocl1;
        ocl1 = OCL.newInstance(EcoreEnvironmentFactory.INSTANCE);
        OCLHelper<EClassifier, EOperation, ?, Constraint> helper = ocl1.createOCLHelper();
        helper.setContext(eClass); 
        OCLExpression expression;
		try {
			expression = (OCLExpression) helper.createQuery(oclToRefactor);
	        OCLAttributeRefectorer attRef = new OCLAttributeRefectorer(eAttribute2, oclToRefactor, "tNew");
	        Integer accept = expression.accept(attRef); 
	        System.out.println(attRef.getChangedOCLStatement());
		} catch (ParserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally {
			ocl1.dispose();
		}
     
    }
    
    private class OCLAttributeRefectorer extends AbstractVisitor<Integer,
	EClassifier, EOperation, EStructuralFeature, EEnumLiteral,
	EParameter, EObject, EObject, EObject, Constraint> {
    	
    	private String ocl = "";
    	private String newName;
    	private EAttribute attribute;
    	public OCLAttributeRefectorer(EAttribute attribute, String ocl, String newName) {
    		this.ocl = ocl;
    		this.newName = newName;
    		this.attribute = attribute;
    	}

    @Override
    protected Integer handlePropertyCallExp(PropertyCallExp<EClassifier, EStructuralFeature> callExp, Integer sourceResult, List<Integer> qualifierResults) {
        EStructuralFeature referredProperty = callExp.getReferredProperty();
        if(referredProperty==attribute && referredProperty.getName().equals(eAttribute2.getName())) {
        	ocl = ocl.substring(0, callExp.getStartPosition()) + newName + ocl.substring(callExp.getEndPosition(), ocl.length());
        }
        return super.handlePropertyCallExp(callExp, sourceResult, qualifierResults);
    }
    
    public String getChangedOCLStatement() {
    	return ocl;
    }
}
    
}
 