package xxx.ui.swt.application.action;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutAction;
import org.eclipse.ui.forms.widgets.Form;

import xxx.client.ui.forms.IXxxForm;
import xxx.ui.swt.Activator;

public class ToolButtonUtility {

  private ToolButtonUtility() {
  }

  public static void addToolButtons(IForm form, Form rootForm) {
    if (form instanceof IXxxForm) {
      IToolButton[] buttons = ((IXxxForm) form).getToolButtons();
      if (buttons != null) {
        IToolBarManager toolBarManager = rootForm.getToolBarManager();
        toolBarManager.removeAll();

        for (IToolButton m : buttons) {
          if (m.isVisible()) {
            SwtScoutAction sAction = new SwtScoutAction(m, Activator.getDefault().getEnvironment());

            toolBarManager.add(sAction.getSwtAction());
          }

        }
        toolBarManager.update(true);
      }
    }
  }

}
