/**
 *
 */
package xxx.client.ui.forms;

import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.tool.AbstractToolButton;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.shared.TEXTS;

import xxx.client.ui.forms.DesktopForm.MainBox.String1Field;
import xxx.client.ui.forms.DesktopForm.MainBox.String2Field;
import xxx.client.ui.forms.DesktopForm.MainBox.String3Field;
import xxx.shared.Icons;
import xxx.shared.services.DesktopFormData;

/**
 * @author jbr
 */
@FormData(value = DesktopFormData.class, sdkCommand = FormData.SdkCommand.CREATE)
public class DesktopForm extends AbstractXxxForm {

  /**
   * @throws org.eclipse.scout.commons.exception.ProcessingException
   */
  public DesktopForm() throws ProcessingException {
    super();
  }

  public String1Field getString1Field() {
    return getFieldByClass(String1Field.class);
  }

  public String2Field getString2Field() {
    return getFieldByClass(String2Field.class);
  }

  public String3Field getString3Field() {
    return getFieldByClass(String3Field.class);
  }

  @Override
  protected boolean getConfiguredAskIfNeedSave() {
    return false;
  }

  //  @Override
  //  protected String getConfiguredSubTitle() {
  //    return "My Form";
  //  }

  @Override
  protected int getConfiguredDisplayHint() {
    return DISPLAY_HINT_VIEW;
  }

  @Override
  protected String getConfiguredDisplayViewId() {
    return VIEW_ID_CENTER;
  }

  @Override
  protected String getConfiguredIconId() {
    return Icons.EclipseScout;
  }

  /**
   * @throws org.eclipse.scout.commons.exception.ProcessingException
   */
  public void startView() throws ProcessingException {
    startInternal(new ViewHandler());
  }

  /**
   * @return the MainBox
   */
  public MainBox getMainBox() {
    return getFieldByClass(MainBox.class);
  }

  @Order(10.0)
  public class MainBox extends AbstractGroupBox {

    @Order(10.0)
    public class String1Field extends AbstractStringField {

      @Override
      protected String getConfiguredLabel() {
        return "String 1";
      }
    }

    @Order(20.0)
    public class String2Field extends AbstractStringField {

      @Override
      protected String getConfiguredLabel() {
        return "String 2";
      }
    }

    @Order(30.0)
    public class String3Field extends AbstractStringField {

      @Override
      protected String getConfiguredLabel() {
        return "String 3";
      }
    }
  }

  @Override
  protected void execChangedSaveNeeded(Boolean saveNeeded) throws ProcessingException {
    getToolButton(RefreshButton.class).setEnabled(saveNeeded);
    System.err.println("execChangedSaveNeeded " + saveNeeded);
  }

  @Order(5.0)
  public class RefreshButton extends AbstractToolButton {

    @Override
    protected String getConfiguredText() {
      return TEXTS.get("About");
    }

    @Override
    protected String getConfiguredIconId() {
      return Icons.Refresh;
    }

    @Override
    protected boolean getConfiguredEnabled() {
      return true;
    }

    @Override
    protected void execAction() throws ProcessingException {
      System.out.println(getString1Field().getValue());
      System.out.println(getString2Field().getValue());
      System.out.println(getString3Field().getValue());
    }
  }

  @Order(10.0)
  public class AboutButton extends AbstractToolButton {

    @Override
    protected String getConfiguredText() {
      return TEXTS.get("About");
    }

    @Override
    protected String getConfiguredIconId() {
      return Icons.Asterisk;
    }

    @Override
    protected void execAction() throws ProcessingException {
      XxxxScoutInfoForm form = new XxxxScoutInfoForm();
      form.startModify();
    }
  }

  public class ViewHandler extends AbstractFormHandler {

    @Override
    protected void execLoad() throws ProcessingException {
      //      IDesktopService service = SERVICES.getService(IDesktopService.class);
      //      DesktopFormData formData = new DesktopFormData();
      //      exportFormData(formData);
      //      formData = service.load(formData);
      //      importFormData(formData);

    }
  }
}
