/**
 *
 */
package xxx.client.ui.forms;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

/**
 * @author jbr
 */
public class AbstractXxxForm extends AbstractForm implements IXxxForm {

  /**
   * @param callInitializer
   * @throws ProcessingException
   */
  public AbstractXxxForm(boolean callInitializer) throws ProcessingException {
    super(callInitializer);
  }

  /**
   * @throws ProcessingException
   */
  public AbstractXxxForm() throws ProcessingException {
    super();
  }

  private IToolButton[] m_toolButtons;

  @Override
  protected void initConfig() throws ProcessingException {
    super.initConfig();

    ArrayList<IToolButton> list = new ArrayList<IToolButton>();
    Class<? extends IToolButton>[] a = getConfiguredToolButtons();
    for (Class<? extends IToolButton> element : a) {
      IToolButton toolButton;
      try {
        toolButton = ConfigurationUtility.newInnerInstance(this, element);
        list.add(toolButton);
      }
      catch (Throwable t) {
        SERVICES.getService(IExceptionHandlerService.class).handleException(new ProcessingException("toolButton: " + element.getName(), t));
      }
    }
    m_toolButtons = list.toArray(new IToolButton[0]);

    addPropertyChangeListener(PROP_SAVE_NEEDED, new PropertyChangeListener() {

      @Override
      public void propertyChange(PropertyChangeEvent evt) {
        try {
          execChangedSaveNeeded((Boolean) evt.getNewValue());
        }
        catch (ProcessingException e) {
          SERVICES.getService(IExceptionHandlerService.class).handleException(e);
        }
      }
    });
  }

  protected void execChangedSaveNeeded(Boolean saveNeeded) throws ProcessingException {
  }

  @Override
  public IToolButton[] getToolButtons() {
    return m_toolButtons;
  }

  @SuppressWarnings("unchecked")
  public <T extends IToolButton> T getToolButton(Class<T> type) throws ProcessingException {
    for (IToolButton m : getToolButtons()) {
      if (m.getClass() == type) {
        return (T) m;
      }
    }
    return null;
  }

  @SuppressWarnings({"rawtypes"})
  private Class<? extends IToolButton>[] getConfiguredToolButtons() {
    Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(getClass());
    return ConfigurationUtility.sortFilteredClassesByOrderAnnotation(dca, IToolButton.class);
  }

}
