/**
 * <copyright>
 * </copyright>
 *
 * $Id: XpdlAdapterFactory.java,v 1.1 2006/12/29 12:25:12 yyang Exp $
 */
package com.soyatec.xpdl.util;

import com.soyatec.xpdl.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see com.soyatec.xpdl.XpdlPackage
 * @generated
 */
public class XpdlAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static XpdlPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XpdlAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = XpdlPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XpdlSwitch modelSwitch =
		new XpdlSwitch() {
			public Object caseActivitiesType(ActivitiesType object) {
				return createActivitiesTypeAdapter();
			}
			public Object caseActivitySetsType(ActivitySetsType object) {
				return createActivitySetsTypeAdapter();
			}
			public Object caseActivitySetType(ActivitySetType object) {
				return createActivitySetTypeAdapter();
			}
			public Object caseActivityType(ActivityType object) {
				return createActivityTypeAdapter();
			}
			public Object caseActualParametersType(ActualParametersType object) {
				return createActualParametersTypeAdapter();
			}
			public Object caseApplicationsType(ApplicationsType object) {
				return createApplicationsTypeAdapter();
			}
			public Object caseApplicationType(ApplicationType object) {
				return createApplicationTypeAdapter();
			}
			public Object caseArrayTypeType(ArrayTypeType object) {
				return createArrayTypeTypeAdapter();
			}
			public Object caseAutomaticType(AutomaticType object) {
				return createAutomaticTypeAdapter();
			}
			public Object caseBasicTypeType(BasicTypeType object) {
				return createBasicTypeTypeAdapter();
			}
			public Object caseBlockActivityType(BlockActivityType object) {
				return createBlockActivityTypeAdapter();
			}
			public Object caseConditionType(ConditionType object) {
				return createConditionTypeAdapter();
			}
			public Object caseConformanceClassType(ConformanceClassType object) {
				return createConformanceClassTypeAdapter();
			}
			public Object caseDataFieldsType(DataFieldsType object) {
				return createDataFieldsTypeAdapter();
			}
			public Object caseDataFieldType(DataFieldType object) {
				return createDataFieldTypeAdapter();
			}
			public Object caseDataTypeType(DataTypeType object) {
				return createDataTypeTypeAdapter();
			}
			public Object caseDeadlineType(DeadlineType object) {
				return createDeadlineTypeAdapter();
			}
			public Object caseDeclaredTypeType(DeclaredTypeType object) {
				return createDeclaredTypeTypeAdapter();
			}
			public Object caseDocumentRoot(DocumentRoot object) {
				return createDocumentRootAdapter();
			}
			public Object caseEnumerationTypeType(EnumerationTypeType object) {
				return createEnumerationTypeTypeAdapter();
			}
			public Object caseEnumerationValueType(EnumerationValueType object) {
				return createEnumerationValueTypeAdapter();
			}
			public Object caseExtendedAttributesType(ExtendedAttributesType object) {
				return createExtendedAttributesTypeAdapter();
			}
			public Object caseExtendedAttributeType(ExtendedAttributeType object) {
				return createExtendedAttributeTypeAdapter();
			}
			public Object caseExternalPackagesType(ExternalPackagesType object) {
				return createExternalPackagesTypeAdapter();
			}
			public Object caseExternalPackageType(ExternalPackageType object) {
				return createExternalPackageTypeAdapter();
			}
			public Object caseExternalReferenceType(ExternalReferenceType object) {
				return createExternalReferenceTypeAdapter();
			}
			public Object caseFinishModeType(FinishModeType object) {
				return createFinishModeTypeAdapter();
			}
			public Object caseFormalParametersType(FormalParametersType object) {
				return createFormalParametersTypeAdapter();
			}
			public Object caseFormalParameterType(FormalParameterType object) {
				return createFormalParameterTypeAdapter();
			}
			public Object caseImplementationType(ImplementationType object) {
				return createImplementationTypeAdapter();
			}
			public Object caseJoinType(JoinType object) {
				return createJoinTypeAdapter();
			}
			public Object caseListTypeType(ListTypeType object) {
				return createListTypeTypeAdapter();
			}
			public Object caseManualType(ManualType object) {
				return createManualTypeAdapter();
			}
			public Object caseMemberType(MemberType object) {
				return createMemberTypeAdapter();
			}
			public Object caseNoType(NoType object) {
				return createNoTypeAdapter();
			}
			public Object casePackageHeaderType(PackageHeaderType object) {
				return createPackageHeaderTypeAdapter();
			}
			public Object casePackageType(PackageType object) {
				return createPackageTypeAdapter();
			}
			public Object caseParticipantsType(ParticipantsType object) {
				return createParticipantsTypeAdapter();
			}
			public Object caseParticipantType(ParticipantType object) {
				return createParticipantTypeAdapter();
			}
			public Object caseParticipantTypeType(ParticipantTypeType object) {
				return createParticipantTypeTypeAdapter();
			}
			public Object caseProcessHeaderType(ProcessHeaderType object) {
				return createProcessHeaderTypeAdapter();
			}
			public Object caseRecordTypeType(RecordTypeType object) {
				return createRecordTypeTypeAdapter();
			}
			public Object caseRedefinableHeaderType(RedefinableHeaderType object) {
				return createRedefinableHeaderTypeAdapter();
			}
			public Object caseResponsiblesType(ResponsiblesType object) {
				return createResponsiblesTypeAdapter();
			}
			public Object caseRouteType(RouteType object) {
				return createRouteTypeAdapter();
			}
			public Object caseSchemaTypeType(SchemaTypeType object) {
				return createSchemaTypeTypeAdapter();
			}
			public Object caseScriptType(ScriptType object) {
				return createScriptTypeAdapter();
			}
			public Object caseSimulationInformationType(SimulationInformationType object) {
				return createSimulationInformationTypeAdapter();
			}
			public Object caseSplitType(SplitType object) {
				return createSplitTypeAdapter();
			}
			public Object caseStartModeType(StartModeType object) {
				return createStartModeTypeAdapter();
			}
			public Object caseSubFlowType(SubFlowType object) {
				return createSubFlowTypeAdapter();
			}
			public Object caseTimeEstimationType(TimeEstimationType object) {
				return createTimeEstimationTypeAdapter();
			}
			public Object caseToolType(ToolType object) {
				return createToolTypeAdapter();
			}
			public Object caseTransitionRefsType(TransitionRefsType object) {
				return createTransitionRefsTypeAdapter();
			}
			public Object caseTransitionRefType(TransitionRefType object) {
				return createTransitionRefTypeAdapter();
			}
			public Object caseTransitionRestrictionsType(TransitionRestrictionsType object) {
				return createTransitionRestrictionsTypeAdapter();
			}
			public Object caseTransitionRestrictionType(TransitionRestrictionType object) {
				return createTransitionRestrictionTypeAdapter();
			}
			public Object caseTransitionsType(TransitionsType object) {
				return createTransitionsTypeAdapter();
			}
			public Object caseTransitionType(TransitionType object) {
				return createTransitionTypeAdapter();
			}
			public Object caseTypeDeclarationsType(TypeDeclarationsType object) {
				return createTypeDeclarationsTypeAdapter();
			}
			public Object caseTypeDeclarationType(TypeDeclarationType object) {
				return createTypeDeclarationTypeAdapter();
			}
			public Object caseUnionTypeType(UnionTypeType object) {
				return createUnionTypeTypeAdapter();
			}
			public Object caseWorkflowProcessesType(WorkflowProcessesType object) {
				return createWorkflowProcessesTypeAdapter();
			}
			public Object caseWorkflowProcessType(WorkflowProcessType object) {
				return createWorkflowProcessTypeAdapter();
			}
			public Object caseXpressionType(XpressionType object) {
				return createXpressionTypeAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ActivitiesType <em>Activities Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ActivitiesType
	 * @generated
	 */
	public Adapter createActivitiesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ActivitySetsType <em>Activity Sets Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ActivitySetsType
	 * @generated
	 */
	public Adapter createActivitySetsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ActivitySetType <em>Activity Set Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ActivitySetType
	 * @generated
	 */
	public Adapter createActivitySetTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ActivityType <em>Activity Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ActivityType
	 * @generated
	 */
	public Adapter createActivityTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ActualParametersType <em>Actual Parameters Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ActualParametersType
	 * @generated
	 */
	public Adapter createActualParametersTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ApplicationsType <em>Applications Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ApplicationsType
	 * @generated
	 */
	public Adapter createApplicationsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ApplicationType <em>Application Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ApplicationType
	 * @generated
	 */
	public Adapter createApplicationTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ArrayTypeType <em>Array Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ArrayTypeType
	 * @generated
	 */
	public Adapter createArrayTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.AutomaticType <em>Automatic Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.AutomaticType
	 * @generated
	 */
	public Adapter createAutomaticTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.BasicTypeType <em>Basic Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.BasicTypeType
	 * @generated
	 */
	public Adapter createBasicTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.BlockActivityType <em>Block Activity Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.BlockActivityType
	 * @generated
	 */
	public Adapter createBlockActivityTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ConditionType <em>Condition Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ConditionType
	 * @generated
	 */
	public Adapter createConditionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ConformanceClassType <em>Conformance Class Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ConformanceClassType
	 * @generated
	 */
	public Adapter createConformanceClassTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.DataFieldsType <em>Data Fields Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.DataFieldsType
	 * @generated
	 */
	public Adapter createDataFieldsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.DataFieldType <em>Data Field Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.DataFieldType
	 * @generated
	 */
	public Adapter createDataFieldTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.DataTypeType <em>Data Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.DataTypeType
	 * @generated
	 */
	public Adapter createDataTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.DeadlineType <em>Deadline Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.DeadlineType
	 * @generated
	 */
	public Adapter createDeadlineTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.DeclaredTypeType <em>Declared Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.DeclaredTypeType
	 * @generated
	 */
	public Adapter createDeclaredTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.DocumentRoot <em>Document Root</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.DocumentRoot
	 * @generated
	 */
	public Adapter createDocumentRootAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.EnumerationTypeType <em>Enumeration Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.EnumerationTypeType
	 * @generated
	 */
	public Adapter createEnumerationTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.EnumerationValueType <em>Enumeration Value Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.EnumerationValueType
	 * @generated
	 */
	public Adapter createEnumerationValueTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ExtendedAttributesType <em>Extended Attributes Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ExtendedAttributesType
	 * @generated
	 */
	public Adapter createExtendedAttributesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ExtendedAttributeType <em>Extended Attribute Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ExtendedAttributeType
	 * @generated
	 */
	public Adapter createExtendedAttributeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ExternalPackagesType <em>External Packages Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ExternalPackagesType
	 * @generated
	 */
	public Adapter createExternalPackagesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ExternalPackageType <em>External Package Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ExternalPackageType
	 * @generated
	 */
	public Adapter createExternalPackageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ExternalReferenceType <em>External Reference Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ExternalReferenceType
	 * @generated
	 */
	public Adapter createExternalReferenceTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.FinishModeType <em>Finish Mode Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.FinishModeType
	 * @generated
	 */
	public Adapter createFinishModeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.FormalParametersType <em>Formal Parameters Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.FormalParametersType
	 * @generated
	 */
	public Adapter createFormalParametersTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.FormalParameterType <em>Formal Parameter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.FormalParameterType
	 * @generated
	 */
	public Adapter createFormalParameterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ImplementationType <em>Implementation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ImplementationType
	 * @generated
	 */
	public Adapter createImplementationTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.JoinType <em>Join Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.JoinType
	 * @generated
	 */
	public Adapter createJoinTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ListTypeType <em>List Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ListTypeType
	 * @generated
	 */
	public Adapter createListTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ManualType <em>Manual Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ManualType
	 * @generated
	 */
	public Adapter createManualTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.MemberType <em>Member Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.MemberType
	 * @generated
	 */
	public Adapter createMemberTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.NoType <em>No Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.NoType
	 * @generated
	 */
	public Adapter createNoTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.PackageHeaderType <em>Package Header Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.PackageHeaderType
	 * @generated
	 */
	public Adapter createPackageHeaderTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.PackageType <em>Package Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.PackageType
	 * @generated
	 */
	public Adapter createPackageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ParticipantsType <em>Participants Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ParticipantsType
	 * @generated
	 */
	public Adapter createParticipantsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ParticipantType <em>Participant Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ParticipantType
	 * @generated
	 */
	public Adapter createParticipantTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ParticipantTypeType <em>Participant Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ParticipantTypeType
	 * @generated
	 */
	public Adapter createParticipantTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ProcessHeaderType <em>Process Header Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ProcessHeaderType
	 * @generated
	 */
	public Adapter createProcessHeaderTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.RecordTypeType <em>Record Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.RecordTypeType
	 * @generated
	 */
	public Adapter createRecordTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.RedefinableHeaderType <em>Redefinable Header Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.RedefinableHeaderType
	 * @generated
	 */
	public Adapter createRedefinableHeaderTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ResponsiblesType <em>Responsibles Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ResponsiblesType
	 * @generated
	 */
	public Adapter createResponsiblesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.RouteType <em>Route Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.RouteType
	 * @generated
	 */
	public Adapter createRouteTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.SchemaTypeType <em>Schema Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.SchemaTypeType
	 * @generated
	 */
	public Adapter createSchemaTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ScriptType <em>Script Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ScriptType
	 * @generated
	 */
	public Adapter createScriptTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.SimulationInformationType <em>Simulation Information Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.SimulationInformationType
	 * @generated
	 */
	public Adapter createSimulationInformationTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.SplitType <em>Split Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.SplitType
	 * @generated
	 */
	public Adapter createSplitTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.StartModeType <em>Start Mode Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.StartModeType
	 * @generated
	 */
	public Adapter createStartModeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.SubFlowType <em>Sub Flow Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.SubFlowType
	 * @generated
	 */
	public Adapter createSubFlowTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TimeEstimationType <em>Time Estimation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TimeEstimationType
	 * @generated
	 */
	public Adapter createTimeEstimationTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.ToolType <em>Tool Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.ToolType
	 * @generated
	 */
	public Adapter createToolTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TransitionRefsType <em>Transition Refs Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TransitionRefsType
	 * @generated
	 */
	public Adapter createTransitionRefsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TransitionRefType <em>Transition Ref Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TransitionRefType
	 * @generated
	 */
	public Adapter createTransitionRefTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TransitionRestrictionsType <em>Transition Restrictions Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TransitionRestrictionsType
	 * @generated
	 */
	public Adapter createTransitionRestrictionsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TransitionRestrictionType <em>Transition Restriction Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TransitionRestrictionType
	 * @generated
	 */
	public Adapter createTransitionRestrictionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TransitionsType <em>Transitions Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TransitionsType
	 * @generated
	 */
	public Adapter createTransitionsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TransitionType <em>Transition Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TransitionType
	 * @generated
	 */
	public Adapter createTransitionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TypeDeclarationsType <em>Type Declarations Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TypeDeclarationsType
	 * @generated
	 */
	public Adapter createTypeDeclarationsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.TypeDeclarationType <em>Type Declaration Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.TypeDeclarationType
	 * @generated
	 */
	public Adapter createTypeDeclarationTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.UnionTypeType <em>Union Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.UnionTypeType
	 * @generated
	 */
	public Adapter createUnionTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.WorkflowProcessesType <em>Workflow Processes Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.WorkflowProcessesType
	 * @generated
	 */
	public Adapter createWorkflowProcessesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.WorkflowProcessType <em>Workflow Process Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.WorkflowProcessType
	 * @generated
	 */
	public Adapter createWorkflowProcessTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.soyatec.xpdl.XpressionType <em>Xpression Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.soyatec.xpdl.XpressionType
	 * @generated
	 */
	public Adapter createXpressionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //XpdlAdapterFactory
