/**
 * <copyright>
 * </copyright>
 *
 * $Id: XpdlFactoryImpl.java,v 1.1 2006/12/29 12:25:11 yyang Exp $
 */
package com.soyatec.xpdl.impl;

import com.soyatec.xpdl.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class XpdlFactoryImpl extends EFactoryImpl implements XpdlFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static XpdlFactory init() {
		try {
			XpdlFactory theXpdlFactory = (XpdlFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.wfmc.org/2002/XPDL1.0"); 
			if (theXpdlFactory != null) {
				return theXpdlFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new XpdlFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XpdlFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case XpdlPackage.ACTIVITIES_TYPE: return createActivitiesType();
			case XpdlPackage.ACTIVITY_SETS_TYPE: return createActivitySetsType();
			case XpdlPackage.ACTIVITY_SET_TYPE: return createActivitySetType();
			case XpdlPackage.ACTIVITY_TYPE: return createActivityType();
			case XpdlPackage.ACTUAL_PARAMETERS_TYPE: return createActualParametersType();
			case XpdlPackage.APPLICATIONS_TYPE: return createApplicationsType();
			case XpdlPackage.APPLICATION_TYPE: return createApplicationType();
			case XpdlPackage.ARRAY_TYPE_TYPE: return createArrayTypeType();
			case XpdlPackage.AUTOMATIC_TYPE: return createAutomaticType();
			case XpdlPackage.BASIC_TYPE_TYPE: return createBasicTypeType();
			case XpdlPackage.BLOCK_ACTIVITY_TYPE: return createBlockActivityType();
			case XpdlPackage.CONDITION_TYPE: return createConditionType();
			case XpdlPackage.CONFORMANCE_CLASS_TYPE: return createConformanceClassType();
			case XpdlPackage.DATA_FIELDS_TYPE: return createDataFieldsType();
			case XpdlPackage.DATA_FIELD_TYPE: return createDataFieldType();
			case XpdlPackage.DATA_TYPE_TYPE: return createDataTypeType();
			case XpdlPackage.DEADLINE_TYPE: return createDeadlineType();
			case XpdlPackage.DECLARED_TYPE_TYPE: return createDeclaredTypeType();
			case XpdlPackage.DOCUMENT_ROOT: return createDocumentRoot();
			case XpdlPackage.ENUMERATION_TYPE_TYPE: return createEnumerationTypeType();
			case XpdlPackage.ENUMERATION_VALUE_TYPE: return createEnumerationValueType();
			case XpdlPackage.EXTENDED_ATTRIBUTES_TYPE: return createExtendedAttributesType();
			case XpdlPackage.EXTENDED_ATTRIBUTE_TYPE: return createExtendedAttributeType();
			case XpdlPackage.EXTERNAL_PACKAGES_TYPE: return createExternalPackagesType();
			case XpdlPackage.EXTERNAL_PACKAGE_TYPE: return createExternalPackageType();
			case XpdlPackage.EXTERNAL_REFERENCE_TYPE: return createExternalReferenceType();
			case XpdlPackage.FINISH_MODE_TYPE: return createFinishModeType();
			case XpdlPackage.FORMAL_PARAMETERS_TYPE: return createFormalParametersType();
			case XpdlPackage.FORMAL_PARAMETER_TYPE: return createFormalParameterType();
			case XpdlPackage.IMPLEMENTATION_TYPE: return createImplementationType();
			case XpdlPackage.JOIN_TYPE: return createJoinType();
			case XpdlPackage.LIST_TYPE_TYPE: return createListTypeType();
			case XpdlPackage.MANUAL_TYPE: return createManualType();
			case XpdlPackage.MEMBER_TYPE: return createMemberType();
			case XpdlPackage.NO_TYPE: return createNoType();
			case XpdlPackage.PACKAGE_HEADER_TYPE: return createPackageHeaderType();
			case XpdlPackage.PACKAGE_TYPE: return createPackageType();
			case XpdlPackage.PARTICIPANTS_TYPE: return createParticipantsType();
			case XpdlPackage.PARTICIPANT_TYPE: return createParticipantType();
			case XpdlPackage.PARTICIPANT_TYPE_TYPE: return createParticipantTypeType();
			case XpdlPackage.PROCESS_HEADER_TYPE: return createProcessHeaderType();
			case XpdlPackage.RECORD_TYPE_TYPE: return createRecordTypeType();
			case XpdlPackage.REDEFINABLE_HEADER_TYPE: return createRedefinableHeaderType();
			case XpdlPackage.RESPONSIBLES_TYPE: return createResponsiblesType();
			case XpdlPackage.ROUTE_TYPE: return createRouteType();
			case XpdlPackage.SCHEMA_TYPE_TYPE: return createSchemaTypeType();
			case XpdlPackage.SCRIPT_TYPE: return createScriptType();
			case XpdlPackage.SIMULATION_INFORMATION_TYPE: return createSimulationInformationType();
			case XpdlPackage.SPLIT_TYPE: return createSplitType();
			case XpdlPackage.START_MODE_TYPE: return createStartModeType();
			case XpdlPackage.SUB_FLOW_TYPE: return createSubFlowType();
			case XpdlPackage.TIME_ESTIMATION_TYPE: return createTimeEstimationType();
			case XpdlPackage.TOOL_TYPE: return createToolType();
			case XpdlPackage.TRANSITION_REFS_TYPE: return createTransitionRefsType();
			case XpdlPackage.TRANSITION_REF_TYPE: return createTransitionRefType();
			case XpdlPackage.TRANSITION_RESTRICTIONS_TYPE: return createTransitionRestrictionsType();
			case XpdlPackage.TRANSITION_RESTRICTION_TYPE: return createTransitionRestrictionType();
			case XpdlPackage.TRANSITIONS_TYPE: return createTransitionsType();
			case XpdlPackage.TRANSITION_TYPE: return createTransitionType();
			case XpdlPackage.TYPE_DECLARATIONS_TYPE: return createTypeDeclarationsType();
			case XpdlPackage.TYPE_DECLARATION_TYPE: return createTypeDeclarationType();
			case XpdlPackage.UNION_TYPE_TYPE: return createUnionTypeType();
			case XpdlPackage.WORKFLOW_PROCESSES_TYPE: return createWorkflowProcessesType();
			case XpdlPackage.WORKFLOW_PROCESS_TYPE: return createWorkflowProcessType();
			case XpdlPackage.XPRESSION_TYPE: return createXpressionType();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case XpdlPackage.ACCESS_LEVEL_TYPE:
				return createAccessLevelTypeFromString(eDataType, initialValue);
			case XpdlPackage.DURATION_UNIT_TYPE:
				return createDurationUnitTypeFromString(eDataType, initialValue);
			case XpdlPackage.EXECUTION_TYPE:
				return createExecutionTypeFromString(eDataType, initialValue);
			case XpdlPackage.EXECUTION_TYPE1:
				return createExecutionType1FromString(eDataType, initialValue);
			case XpdlPackage.GRAPH_CONFORMANCE_TYPE:
				return createGraphConformanceTypeFromString(eDataType, initialValue);
			case XpdlPackage.INSTANTIATION_TYPE:
				return createInstantiationTypeFromString(eDataType, initialValue);
			case XpdlPackage.IS_ARRAY_TYPE:
				return createIsArrayTypeFromString(eDataType, initialValue);
			case XpdlPackage.MODE_TYPE:
				return createModeTypeFromString(eDataType, initialValue);
			case XpdlPackage.PUBLICATION_STATUS_TYPE:
				return createPublicationStatusTypeFromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE:
				return createTypeTypeFromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE1:
				return createTypeType1FromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE2:
				return createTypeType2FromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE3:
				return createTypeType3FromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE4:
				return createTypeType4FromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE5:
				return createTypeType5FromString(eDataType, initialValue);
			case XpdlPackage.ACCESS_LEVEL_TYPE_OBJECT:
				return createAccessLevelTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.DURATION_UNIT_TYPE_OBJECT:
				return createDurationUnitTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.EXECUTION_TYPE_OBJECT:
				return createExecutionTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.EXECUTION_TYPE_OBJECT1:
				return createExecutionTypeObject1FromString(eDataType, initialValue);
			case XpdlPackage.GRAPH_CONFORMANCE_TYPE_OBJECT:
				return createGraphConformanceTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.INSTANTIATION_TYPE_OBJECT:
				return createInstantiationTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.IS_ARRAY_TYPE_OBJECT:
				return createIsArrayTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.MODE_TYPE_OBJECT:
				return createModeTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.PUBLICATION_STATUS_TYPE_OBJECT:
				return createPublicationStatusTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE_OBJECT:
				return createTypeTypeObjectFromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE_OBJECT1:
				return createTypeTypeObject1FromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE_OBJECT2:
				return createTypeTypeObject2FromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE_OBJECT3:
				return createTypeTypeObject3FromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE_OBJECT4:
				return createTypeTypeObject4FromString(eDataType, initialValue);
			case XpdlPackage.TYPE_TYPE_OBJECT5:
				return createTypeTypeObject5FromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case XpdlPackage.ACCESS_LEVEL_TYPE:
				return convertAccessLevelTypeToString(eDataType, instanceValue);
			case XpdlPackage.DURATION_UNIT_TYPE:
				return convertDurationUnitTypeToString(eDataType, instanceValue);
			case XpdlPackage.EXECUTION_TYPE:
				return convertExecutionTypeToString(eDataType, instanceValue);
			case XpdlPackage.EXECUTION_TYPE1:
				return convertExecutionType1ToString(eDataType, instanceValue);
			case XpdlPackage.GRAPH_CONFORMANCE_TYPE:
				return convertGraphConformanceTypeToString(eDataType, instanceValue);
			case XpdlPackage.INSTANTIATION_TYPE:
				return convertInstantiationTypeToString(eDataType, instanceValue);
			case XpdlPackage.IS_ARRAY_TYPE:
				return convertIsArrayTypeToString(eDataType, instanceValue);
			case XpdlPackage.MODE_TYPE:
				return convertModeTypeToString(eDataType, instanceValue);
			case XpdlPackage.PUBLICATION_STATUS_TYPE:
				return convertPublicationStatusTypeToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE:
				return convertTypeTypeToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE1:
				return convertTypeType1ToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE2:
				return convertTypeType2ToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE3:
				return convertTypeType3ToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE4:
				return convertTypeType4ToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE5:
				return convertTypeType5ToString(eDataType, instanceValue);
			case XpdlPackage.ACCESS_LEVEL_TYPE_OBJECT:
				return convertAccessLevelTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.DURATION_UNIT_TYPE_OBJECT:
				return convertDurationUnitTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.EXECUTION_TYPE_OBJECT:
				return convertExecutionTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.EXECUTION_TYPE_OBJECT1:
				return convertExecutionTypeObject1ToString(eDataType, instanceValue);
			case XpdlPackage.GRAPH_CONFORMANCE_TYPE_OBJECT:
				return convertGraphConformanceTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.INSTANTIATION_TYPE_OBJECT:
				return convertInstantiationTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.IS_ARRAY_TYPE_OBJECT:
				return convertIsArrayTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.MODE_TYPE_OBJECT:
				return convertModeTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.PUBLICATION_STATUS_TYPE_OBJECT:
				return convertPublicationStatusTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE_OBJECT:
				return convertTypeTypeObjectToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE_OBJECT1:
				return convertTypeTypeObject1ToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE_OBJECT2:
				return convertTypeTypeObject2ToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE_OBJECT3:
				return convertTypeTypeObject3ToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE_OBJECT4:
				return convertTypeTypeObject4ToString(eDataType, instanceValue);
			case XpdlPackage.TYPE_TYPE_OBJECT5:
				return convertTypeTypeObject5ToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ActivitiesType createActivitiesType() {
		ActivitiesTypeImpl activitiesType = new ActivitiesTypeImpl();
		return activitiesType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ActivitySetsType createActivitySetsType() {
		ActivitySetsTypeImpl activitySetsType = new ActivitySetsTypeImpl();
		return activitySetsType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ActivitySetType createActivitySetType() {
		ActivitySetTypeImpl activitySetType = new ActivitySetTypeImpl();
		return activitySetType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ActivityType createActivityType() {
		ActivityTypeImpl activityType = new ActivityTypeImpl();
		return activityType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ActualParametersType createActualParametersType() {
		ActualParametersTypeImpl actualParametersType = new ActualParametersTypeImpl();
		return actualParametersType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApplicationsType createApplicationsType() {
		ApplicationsTypeImpl applicationsType = new ApplicationsTypeImpl();
		return applicationsType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApplicationType createApplicationType() {
		ApplicationTypeImpl applicationType = new ApplicationTypeImpl();
		return applicationType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayTypeType createArrayTypeType() {
		ArrayTypeTypeImpl arrayTypeType = new ArrayTypeTypeImpl();
		return arrayTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AutomaticType createAutomaticType() {
		AutomaticTypeImpl automaticType = new AutomaticTypeImpl();
		return automaticType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BasicTypeType createBasicTypeType() {
		BasicTypeTypeImpl basicTypeType = new BasicTypeTypeImpl();
		return basicTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BlockActivityType createBlockActivityType() {
		BlockActivityTypeImpl blockActivityType = new BlockActivityTypeImpl();
		return blockActivityType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConditionType createConditionType() {
		ConditionTypeImpl conditionType = new ConditionTypeImpl();
		return conditionType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConformanceClassType createConformanceClassType() {
		ConformanceClassTypeImpl conformanceClassType = new ConformanceClassTypeImpl();
		return conformanceClassType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataFieldsType createDataFieldsType() {
		DataFieldsTypeImpl dataFieldsType = new DataFieldsTypeImpl();
		return dataFieldsType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataFieldType createDataFieldType() {
		DataFieldTypeImpl dataFieldType = new DataFieldTypeImpl();
		return dataFieldType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataTypeType createDataTypeType() {
		DataTypeTypeImpl dataTypeType = new DataTypeTypeImpl();
		return dataTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeadlineType createDeadlineType() {
		DeadlineTypeImpl deadlineType = new DeadlineTypeImpl();
		return deadlineType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeclaredTypeType createDeclaredTypeType() {
		DeclaredTypeTypeImpl declaredTypeType = new DeclaredTypeTypeImpl();
		return declaredTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentRoot createDocumentRoot() {
		DocumentRootImpl documentRoot = new DocumentRootImpl();
		return documentRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnumerationTypeType createEnumerationTypeType() {
		EnumerationTypeTypeImpl enumerationTypeType = new EnumerationTypeTypeImpl();
		return enumerationTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnumerationValueType createEnumerationValueType() {
		EnumerationValueTypeImpl enumerationValueType = new EnumerationValueTypeImpl();
		return enumerationValueType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtendedAttributesType createExtendedAttributesType() {
		ExtendedAttributesTypeImpl extendedAttributesType = new ExtendedAttributesTypeImpl();
		return extendedAttributesType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtendedAttributeType createExtendedAttributeType() {
		ExtendedAttributeTypeImpl extendedAttributeType = new ExtendedAttributeTypeImpl();
		return extendedAttributeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalPackagesType createExternalPackagesType() {
		ExternalPackagesTypeImpl externalPackagesType = new ExternalPackagesTypeImpl();
		return externalPackagesType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalPackageType createExternalPackageType() {
		ExternalPackageTypeImpl externalPackageType = new ExternalPackageTypeImpl();
		return externalPackageType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalReferenceType createExternalReferenceType() {
		ExternalReferenceTypeImpl externalReferenceType = new ExternalReferenceTypeImpl();
		return externalReferenceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FinishModeType createFinishModeType() {
		FinishModeTypeImpl finishModeType = new FinishModeTypeImpl();
		return finishModeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FormalParametersType createFormalParametersType() {
		FormalParametersTypeImpl formalParametersType = new FormalParametersTypeImpl();
		return formalParametersType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FormalParameterType createFormalParameterType() {
		FormalParameterTypeImpl formalParameterType = new FormalParameterTypeImpl();
		return formalParameterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ImplementationType createImplementationType() {
		ImplementationTypeImpl implementationType = new ImplementationTypeImpl();
		return implementationType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JoinType createJoinType() {
		JoinTypeImpl joinType = new JoinTypeImpl();
		return joinType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListTypeType createListTypeType() {
		ListTypeTypeImpl listTypeType = new ListTypeTypeImpl();
		return listTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ManualType createManualType() {
		ManualTypeImpl manualType = new ManualTypeImpl();
		return manualType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MemberType createMemberType() {
		MemberTypeImpl memberType = new MemberTypeImpl();
		return memberType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NoType createNoType() {
		NoTypeImpl noType = new NoTypeImpl();
		return noType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PackageHeaderType createPackageHeaderType() {
		PackageHeaderTypeImpl packageHeaderType = new PackageHeaderTypeImpl();
		return packageHeaderType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PackageType createPackageType() {
		PackageTypeImpl packageType = new PackageTypeImpl();
		return packageType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParticipantsType createParticipantsType() {
		ParticipantsTypeImpl participantsType = new ParticipantsTypeImpl();
		return participantsType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParticipantType createParticipantType() {
		ParticipantTypeImpl participantType = new ParticipantTypeImpl();
		return participantType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParticipantTypeType createParticipantTypeType() {
		ParticipantTypeTypeImpl participantTypeType = new ParticipantTypeTypeImpl();
		return participantTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessHeaderType createProcessHeaderType() {
		ProcessHeaderTypeImpl processHeaderType = new ProcessHeaderTypeImpl();
		return processHeaderType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RecordTypeType createRecordTypeType() {
		RecordTypeTypeImpl recordTypeType = new RecordTypeTypeImpl();
		return recordTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RedefinableHeaderType createRedefinableHeaderType() {
		RedefinableHeaderTypeImpl redefinableHeaderType = new RedefinableHeaderTypeImpl();
		return redefinableHeaderType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResponsiblesType createResponsiblesType() {
		ResponsiblesTypeImpl responsiblesType = new ResponsiblesTypeImpl();
		return responsiblesType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RouteType createRouteType() {
		RouteTypeImpl routeType = new RouteTypeImpl();
		return routeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SchemaTypeType createSchemaTypeType() {
		SchemaTypeTypeImpl schemaTypeType = new SchemaTypeTypeImpl();
		return schemaTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ScriptType createScriptType() {
		ScriptTypeImpl scriptType = new ScriptTypeImpl();
		return scriptType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimulationInformationType createSimulationInformationType() {
		SimulationInformationTypeImpl simulationInformationType = new SimulationInformationTypeImpl();
		return simulationInformationType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SplitType createSplitType() {
		SplitTypeImpl splitType = new SplitTypeImpl();
		return splitType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StartModeType createStartModeType() {
		StartModeTypeImpl startModeType = new StartModeTypeImpl();
		return startModeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SubFlowType createSubFlowType() {
		SubFlowTypeImpl subFlowType = new SubFlowTypeImpl();
		return subFlowType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimeEstimationType createTimeEstimationType() {
		TimeEstimationTypeImpl timeEstimationType = new TimeEstimationTypeImpl();
		return timeEstimationType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ToolType createToolType() {
		ToolTypeImpl toolType = new ToolTypeImpl();
		return toolType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransitionRefsType createTransitionRefsType() {
		TransitionRefsTypeImpl transitionRefsType = new TransitionRefsTypeImpl();
		return transitionRefsType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransitionRefType createTransitionRefType() {
		TransitionRefTypeImpl transitionRefType = new TransitionRefTypeImpl();
		return transitionRefType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransitionRestrictionsType createTransitionRestrictionsType() {
		TransitionRestrictionsTypeImpl transitionRestrictionsType = new TransitionRestrictionsTypeImpl();
		return transitionRestrictionsType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransitionRestrictionType createTransitionRestrictionType() {
		TransitionRestrictionTypeImpl transitionRestrictionType = new TransitionRestrictionTypeImpl();
		return transitionRestrictionType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransitionsType createTransitionsType() {
		TransitionsTypeImpl transitionsType = new TransitionsTypeImpl();
		return transitionsType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransitionType createTransitionType() {
		TransitionTypeImpl transitionType = new TransitionTypeImpl();
		return transitionType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeDeclarationsType createTypeDeclarationsType() {
		TypeDeclarationsTypeImpl typeDeclarationsType = new TypeDeclarationsTypeImpl();
		return typeDeclarationsType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeDeclarationType createTypeDeclarationType() {
		TypeDeclarationTypeImpl typeDeclarationType = new TypeDeclarationTypeImpl();
		return typeDeclarationType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnionTypeType createUnionTypeType() {
		UnionTypeTypeImpl unionTypeType = new UnionTypeTypeImpl();
		return unionTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WorkflowProcessesType createWorkflowProcessesType() {
		WorkflowProcessesTypeImpl workflowProcessesType = new WorkflowProcessesTypeImpl();
		return workflowProcessesType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WorkflowProcessType createWorkflowProcessType() {
		WorkflowProcessTypeImpl workflowProcessType = new WorkflowProcessTypeImpl();
		return workflowProcessType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XpressionType createXpressionType() {
		XpressionTypeImpl xpressionType = new XpressionTypeImpl();
		return xpressionType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AccessLevelType createAccessLevelTypeFromString(EDataType eDataType, String initialValue) {
		AccessLevelType result = AccessLevelType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertAccessLevelTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DurationUnitType createDurationUnitTypeFromString(EDataType eDataType, String initialValue) {
		DurationUnitType result = DurationUnitType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDurationUnitTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExecutionType createExecutionTypeFromString(EDataType eDataType, String initialValue) {
		ExecutionType result = ExecutionType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertExecutionTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExecutionType1 createExecutionType1FromString(EDataType eDataType, String initialValue) {
		ExecutionType1 result = ExecutionType1.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertExecutionType1ToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GraphConformanceType createGraphConformanceTypeFromString(EDataType eDataType, String initialValue) {
		GraphConformanceType result = GraphConformanceType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertGraphConformanceTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstantiationType createInstantiationTypeFromString(EDataType eDataType, String initialValue) {
		InstantiationType result = InstantiationType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertInstantiationTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IsArrayType createIsArrayTypeFromString(EDataType eDataType, String initialValue) {
		IsArrayType result = IsArrayType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertIsArrayTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModeType createModeTypeFromString(EDataType eDataType, String initialValue) {
		ModeType result = ModeType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertModeTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PublicationStatusType createPublicationStatusTypeFromString(EDataType eDataType, String initialValue) {
		PublicationStatusType result = PublicationStatusType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPublicationStatusTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType createTypeTypeFromString(EDataType eDataType, String initialValue) {
		TypeType result = TypeType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType1 createTypeType1FromString(EDataType eDataType, String initialValue) {
		TypeType1 result = TypeType1.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeType1ToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType2 createTypeType2FromString(EDataType eDataType, String initialValue) {
		TypeType2 result = TypeType2.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeType2ToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType3 createTypeType3FromString(EDataType eDataType, String initialValue) {
		TypeType3 result = TypeType3.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeType3ToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType4 createTypeType4FromString(EDataType eDataType, String initialValue) {
		TypeType4 result = TypeType4.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeType4ToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType5 createTypeType5FromString(EDataType eDataType, String initialValue) {
		TypeType5 result = TypeType5.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeType5ToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AccessLevelType createAccessLevelTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (AccessLevelType)createAccessLevelTypeFromString(XpdlPackage.Literals.ACCESS_LEVEL_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertAccessLevelTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertAccessLevelTypeToString(XpdlPackage.Literals.ACCESS_LEVEL_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DurationUnitType createDurationUnitTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (DurationUnitType)createDurationUnitTypeFromString(XpdlPackage.Literals.DURATION_UNIT_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDurationUnitTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertDurationUnitTypeToString(XpdlPackage.Literals.DURATION_UNIT_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExecutionType createExecutionTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (ExecutionType)createExecutionTypeFromString(XpdlPackage.Literals.EXECUTION_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertExecutionTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertExecutionTypeToString(XpdlPackage.Literals.EXECUTION_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExecutionType1 createExecutionTypeObject1FromString(EDataType eDataType, String initialValue) {
		return (ExecutionType1)createExecutionType1FromString(XpdlPackage.Literals.EXECUTION_TYPE1, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertExecutionTypeObject1ToString(EDataType eDataType, Object instanceValue) {
		return convertExecutionType1ToString(XpdlPackage.Literals.EXECUTION_TYPE1, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GraphConformanceType createGraphConformanceTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (GraphConformanceType)createGraphConformanceTypeFromString(XpdlPackage.Literals.GRAPH_CONFORMANCE_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertGraphConformanceTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertGraphConformanceTypeToString(XpdlPackage.Literals.GRAPH_CONFORMANCE_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstantiationType createInstantiationTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (InstantiationType)createInstantiationTypeFromString(XpdlPackage.Literals.INSTANTIATION_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertInstantiationTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertInstantiationTypeToString(XpdlPackage.Literals.INSTANTIATION_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IsArrayType createIsArrayTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (IsArrayType)createIsArrayTypeFromString(XpdlPackage.Literals.IS_ARRAY_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertIsArrayTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertIsArrayTypeToString(XpdlPackage.Literals.IS_ARRAY_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModeType createModeTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (ModeType)createModeTypeFromString(XpdlPackage.Literals.MODE_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertModeTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertModeTypeToString(XpdlPackage.Literals.MODE_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PublicationStatusType createPublicationStatusTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (PublicationStatusType)createPublicationStatusTypeFromString(XpdlPackage.Literals.PUBLICATION_STATUS_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPublicationStatusTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertPublicationStatusTypeToString(XpdlPackage.Literals.PUBLICATION_STATUS_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType4 createTypeTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (TypeType4)createTypeType4FromString(XpdlPackage.Literals.TYPE_TYPE4, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return convertTypeType4ToString(XpdlPackage.Literals.TYPE_TYPE4, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType1 createTypeTypeObject1FromString(EDataType eDataType, String initialValue) {
		return (TypeType1)createTypeType1FromString(XpdlPackage.Literals.TYPE_TYPE1, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeTypeObject1ToString(EDataType eDataType, Object instanceValue) {
		return convertTypeType1ToString(XpdlPackage.Literals.TYPE_TYPE1, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType3 createTypeTypeObject2FromString(EDataType eDataType, String initialValue) {
		return (TypeType3)createTypeType3FromString(XpdlPackage.Literals.TYPE_TYPE3, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeTypeObject2ToString(EDataType eDataType, Object instanceValue) {
		return convertTypeType3ToString(XpdlPackage.Literals.TYPE_TYPE3, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType2 createTypeTypeObject3FromString(EDataType eDataType, String initialValue) {
		return (TypeType2)createTypeType2FromString(XpdlPackage.Literals.TYPE_TYPE2, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeTypeObject3ToString(EDataType eDataType, Object instanceValue) {
		return convertTypeType2ToString(XpdlPackage.Literals.TYPE_TYPE2, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType createTypeTypeObject4FromString(EDataType eDataType, String initialValue) {
		return (TypeType)createTypeTypeFromString(XpdlPackage.Literals.TYPE_TYPE, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeTypeObject4ToString(EDataType eDataType, Object instanceValue) {
		return convertTypeTypeToString(XpdlPackage.Literals.TYPE_TYPE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeType5 createTypeTypeObject5FromString(EDataType eDataType, String initialValue) {
		return (TypeType5)createTypeType5FromString(XpdlPackage.Literals.TYPE_TYPE5, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeTypeObject5ToString(EDataType eDataType, Object instanceValue) {
		return convertTypeType5ToString(XpdlPackage.Literals.TYPE_TYPE5, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XpdlPackage getXpdlPackage() {
		return (XpdlPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static XpdlPackage getPackage() {
		return XpdlPackage.eINSTANCE;
	}

} //XpdlFactoryImpl
