import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.model.OCLstdlib;
import org.eclipse.ocl.examples.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.ocl.examples.xtext.oclinecore.OCLinEcoreStandaloneSetup;
import org.eclipse.ocl.examples.xtext.oclstdlib.OCLstdlibStandaloneSetup;

import root.RootFactory;
import root.Test;

public class TestOCLValidation {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		ResourceSet rs = initEMF();
		Resource resource = rs.createResource(URI.createFileURI("./target/test.xmi"));

		Test test = RootFactory.eINSTANCE.createTest();
		test.setAtt1(1);
		test.setAtt2(123);

		resource.getContents().add(test);

		// OCL constraint is self.att1 > self.att2
		// The validation of this instance must raise a validation error

		Diagnostic diag = Diagnostician.INSTANCE.validate(test);
		for (Diagnostic subDiag : diag.getChildren()) {
			System.out.println(subDiag);
		}

	}

	private static ResourceSet initEMF() {
		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore",
				new EcoreResourceFactoryImpl());

		ResourceSet rs = new ResourceSetImpl();

		try {
			OCL.initialize(rs);
			OCLstdlib.install();
			// UML2Pivot.initialize(rs);
			OCLDelegateDomain.initialize(rs);
			CompleteOCLStandaloneSetup.doSetup();
			OCLinEcoreStandaloneSetup.doSetup();
			OCLstdlibStandaloneSetup.doSetup();
			EssentialOCLStandaloneSetup.doSetup();
			StandaloneProjectMap.getAdapter(rs);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return rs;
	}
}
