package org.xtext.example.mydsl2.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.xtext.example.mydsl2.myDsl2.Group;
import org.xtext.example.mydsl2.myDsl2.MyDsl2Package;
import org.xtext.example.mydsl2.myDsl2.RoleAssignment;
import org.xtext.example.mydsl2.myDsl2.RoleDefinition;
import org.xtext.example.mydsl2.myDsl2.SitePermission;
import org.xtext.example.mydsl2.myDsl2.User;
import org.xtext.example.mydsl2.myDsl2.UserModel;
import org.xtext.example.mydsl2.services.MyDsl2GrammarAccess;

@SuppressWarnings("all")
public class MyDsl2SemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private MyDsl2GrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == MyDsl2Package.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case MyDsl2Package.GROUP:
				if(context == grammarAccess.getGroupRule() ||
				   context == grammarAccess.getPrincipleRule()) {
					sequence_Group(context, (Group) semanticObject); 
					return; 
				}
				else break;
			case MyDsl2Package.ROLE_ASSIGNMENT:
				if(context == grammarAccess.getRoleAssignmentRule()) {
					sequence_RoleAssignment(context, (RoleAssignment) semanticObject); 
					return; 
				}
				else break;
			case MyDsl2Package.ROLE_DEFINITION:
				if(context == grammarAccess.getRoleDefinitionRule()) {
					sequence_RoleDefinition(context, (RoleDefinition) semanticObject); 
					return; 
				}
				else break;
			case MyDsl2Package.SITE_PERMISSION:
				if(context == grammarAccess.getSitePermissionRule()) {
					sequence_SitePermission(context, (SitePermission) semanticObject); 
					return; 
				}
				else break;
			case MyDsl2Package.USER:
				if(context == grammarAccess.getPrincipleRule() ||
				   context == grammarAccess.getUserRule()) {
					sequence_User(context, (User) semanticObject); 
					return; 
				}
				else break;
			case MyDsl2Package.USER_MODEL:
				if(context == grammarAccess.getUserModelRule()) {
					sequence_UserModel(context, (UserModel) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (name=QualifiedName (users+=[User|QualifiedName] users+=[User|QualifiedName]*)?)
	 */
	protected void sequence_Group(EObject context, Group semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         name=QualifiedName 
	 *         member=[Principle|QualifiedName] 
	 *         (roleDefinitionBindings+=[RoleDefinition|QualifiedName] roleDefinitionBindings+=[RoleDefinition|QualifiedName]*)?
	 *     )
	 */
	protected void sequence_RoleAssignment(EObject context, RoleAssignment semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName basePermissions+=BasePermission basePermissions+=BasePermission*)
	 */
	protected void sequence_RoleDefinition(EObject context, RoleDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName webGUID=STRING ownedGroup+=Group* ownedRoleDefinition+=RoleDefinition* ownedRoleAssignments+=RoleAssignment*)
	 */
	protected void sequence_SitePermission(EObject context, SitePermission semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=QualifiedName (users+=User users+=User*)? (sitePermissions+=SitePermission sitePermissions+=SitePermission*)?)
	 */
	protected void sequence_UserModel(EObject context, UserModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     name=QualifiedName
	 */
	protected void sequence_User(EObject context, User semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, MyDsl2Package.Literals.PRINCIPLE__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MyDsl2Package.Literals.PRINCIPLE__NAME));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getUserAccess().getNameQualifiedNameParserRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
}
