package org.xtext.example.mydsl.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.xtext.example.mydsl.myDsl.ContentModel;
import org.xtext.example.mydsl.myDsl.MyDslPackage;
import org.xtext.example.mydsl.myDsl.Web;
import org.xtext.example.mydsl.services.MyDslGrammarAccess;

@SuppressWarnings("all")
public class MyDslSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private MyDslGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == MyDslPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case MyDslPackage.CONTENT_MODEL:
				if(context == grammarAccess.getContentModelRule() ||
				   context == grammarAccess.getContentUnitRule()) {
					sequence_ContentModel(context, (ContentModel) semanticObject); 
					return; 
				}
				else break;
			case MyDslPackage.WEB:
				if(context == grammarAccess.getContentUnitRule() ||
				   context == grammarAccess.getWebRule()) {
					sequence_Web(context, (Web) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (name=QualifiedName displayName=STRING description=STRING? ownedWeb=Web)
	 */
	protected void sequence_ContentModel(EObject context, ContentModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         name=QualifiedName 
	 *         guID=STRING 
	 *         displayName=STRING 
	 *         description=STRING? 
	 *         sitePermission=[SitePermission|QualifiedName]? 
	 *         (ownedWeb+=Web ownedWeb+=Web*)?
	 *     )
	 */
	protected void sequence_Web(EObject context, Web semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
