package org.xtext.example.mydsl.myDsl.util;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.xtext.example.mydsl.myDsl.Web;
import org.xtext.example.mydsl2.MyDsl2RuntimeModule;
import org.xtext.example.mydsl2.myDsl2.Group;
import org.xtext.example.mydsl2.myDsl2.MyDsl2Factory;
import org.xtext.example.mydsl2.myDsl2.MyDsl2Package;
import org.xtext.example.mydsl2.myDsl2.SitePermission;
import org.xtext.example.mydsl2.myDsl2.UserModel;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;



public class Sitepermissiontwo {
	
	@Inject
	Provider<XtextResourceSet> rsp;
	public  SitePermission createDefaultSitePermission(String webName,
			String webGuID) {
		// Initialize the model
				MyDsl2Package.eINSTANCE.eClass();
				// Retrieve the default factory singleton
				MyDsl2Factory factory = MyDsl2Factory.eINSTANCE;
				// SitePermission
				SitePermission sitePermission = factory.createSitePermission();
				sitePermission.setName(webName);
				sitePermission.setWebGUID(webGuID);

				// Owners Group
				Group ownerGroup = MyDsl2Factory.eINSTANCE.createGroup();
				ownerGroup.setName("Owners");
				sitePermission.getOwnedGroup().add(ownerGroup);
				
		
		return sitePermission;
	}

	public  void loadAndAddSitePermission(Web web, SitePermission s){
		
		
		XtextResourceSet resourceSet = rsp.get();
		resourceSet.addLoadOption(XtextResource.OPTION_RESOLVE_ALL, Boolean.TRUE);
			
		Resource resource = resourceSet.getResource(URI.createURI(getUserFileLocationURI()), true);
		
		UserModel model = (UserModel) resource.getContents().get(0);
	    model.getSitePermissions().add(s);
	    System.out.println( model.getSitePermissions().add(s));
	    try {
			resource.save(null);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	    

	}
	
	public  String getUserFileLocationURI() {
		IEditorPart editorPart = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
		
		if (editorPart != null) {
			IFileEditorInput input = (IFileEditorInput) editorPart
					.getEditorInput();
			IFile file = input.getFile();
			
			String path = "";
			int segmentCount = file.getProjectRelativePath().segmentCount();
			if(segmentCount != 1){
				for (int i = 0; i < segmentCount -1; i++) {
					path += file.getProjectRelativePath().segment(i) + "/";
				}
			}
			return "platform:/resource/" + file.getProject().getName() + "/" + path + UserConstant.USER_FILE_NAME;
		}
		return "";
	}
	

}
