package org.xtext.example.mydsl.myDsl.util;

import java.io.File;
import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.xtext.example.mydsl2.myDsl2.Group;
import org.xtext.example.mydsl2.myDsl2.MyDsl2Factory;
import org.xtext.example.mydsl2.myDsl2.MyDsl2Package;
import org.xtext.example.mydsl2.myDsl2.SitePermission;
import org.xtext.example.mydsl2.myDsl2.UserModel;
import org.xtext.example.mydsl.myDsl.Web;
import org.xtext.example.mydsl.myDsl.util.UserConstant;

import com.google.inject.Inject;
import com.google.inject.Provider;

public class SitePermission7 {
	@Inject
	Provider<XtextResourceSet> rsp;
	
	
	public static File userFile;

	public static SitePermission createDefaultSitePermission(String webName,String webGuID) {
		// Initialize the model
		MyDsl2Package.eINSTANCE.eClass();
		// Retrieve the default factory singleton
		MyDsl2Factory factory = MyDsl2Factory.eINSTANCE;
		// SitePermission
		SitePermission sitePermission = factory.createSitePermission();
		sitePermission.setName(webName);
		sitePermission.setWebGUID(webGuID);

		// Owners Group
		Group ownerGroup = MyDsl2Factory.eINSTANCE.createGroup();
		ownerGroup.setName("Owners");
		sitePermission.getOwnedGroup().add(ownerGroup);
		
        
		//userModel.getSitePermissions().add(sitePermission);
		
		return sitePermission;
	}

	public void  loadForCreateSitePermission(Web web, SitePermission s) {
		
        XtextResourceSet resourceSet = rsp.get();
		
		resourceSet.addLoadOption(XtextResource.OPTION_RESOLVE_ALL, Boolean.TRUE);
		
		
		 String userfile =getUserFileLocationURI();
		
		 Resource resource = resourceSet.getResource(URI.createURI(userfile), true);
		 UserModel model = (UserModel) resource.getContents().get(0);
		 resourceSet.getResources().add(resource);
		
		 resource.getContents().add(s);
	
		 model.getSitePermissions().add(s);
	    // web.eResource().getResourceSet().getResources().add(resource);
	    
		
			try {
				
				resource.save(null);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}	
		
		//return sitePermission;
	

	
	public  String getUserFileLocationURI() {
		
		IEditorPart editorPart = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
		
		if (editorPart != null) {
			IFileEditorInput input = (IFileEditorInput) editorPart
					.getEditorInput();
			IFile file = input.getFile();
			
			String path = "";
			int segmentCount = file.getProjectRelativePath().segmentCount();
			if(segmentCount != 1){
				for (int i = 0; i < segmentCount -1; i++) {
					path += file.getProjectRelativePath().segment(i) + "/";
				}
			}
			return "platform:/resource/" + file.getProject().getName() + "/" + path + UserConstant.USER_FILE_NAME;
		}
		return "";
	}
	
	

}
