package org.epsilon.tests.workflow;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.uml2.uml.UMLPackage;

public class EpsilonUtils {


	static public void registerPkgUML() {
		EPackage.Registry.INSTANCE.put(UMLPackage.eNS_URI, UMLPackage.eINSTANCE);
	}
	
	static public void registerPkg(String metamodelPath) throws EpsilonWorkflowException {
		try {
			String file = EpsilonUtils.getFile(metamodelPath).getAbsolutePath();
			EmfUtil.register(URI.createFileURI(file), EPackage.Registry.INSTANCE);
			
		} catch (Exception e) {
			throw new EpsilonWorkflowException("Could not register package " + metamodelPath, e);
		}
		
	}
	
	@SuppressWarnings("deprecation")
	static public EmfModel model_byMMfile(String name, String model, 
			String metamodel, 
			boolean readOnLoad,
			boolean storeOnDisposal) throws EpsilonWorkflowException 
			{
		try {
			EmfModel emfModel = new EmfModel();
			StringProperties properties = new StringProperties();
			properties.put(EmfModel.PROPERTY_NAME, name);
			properties.put(EmfModel.PROPERTY_FILE_BASED_METAMODEL_URI, 
					"file:/" + getFile(metamodel).getAbsolutePath());
			properties.put(EmfModel.PROPERTY_MODEL_URI, 
					"file:/" + getFile(model).getAbsolutePath());
			properties.put(EmfModel.PROPERTY_IS_METAMODEL_FILE_BASED, "true");
			properties.put(EmfModel.PROPERTY_READONLOAD, readOnLoad + "");
			properties.put(EmfModel.PROPERTY_STOREONDISPOSAL, 
					storeOnDisposal + "");
			emfModel.load(properties, null);
			return emfModel;

		} catch (EolModelLoadingException e) {
			throw new EpsilonWorkflowException("Model loading exception", e);
		} catch (URISyntaxException e) {
			throw new EpsilonWorkflowException("URI exception during model", e);
		}
			}

	@SuppressWarnings("deprecation")
	static public EmfModel model_byMMuri(String name, String model, 
			String metamodel, boolean readOnLoad, boolean storeOnDisposal) throws EpsilonWorkflowException 
			{
		try {
			EmfModel emfModel = new EmfModel();
			StringProperties properties = new StringProperties();
			properties.put(EmfModel.PROPERTY_NAME, name);
			properties.put(EmfModel.PROPERTY_METAMODEL_URI, metamodel);
			properties.put(EmfModel.PROPERTY_MODEL_URI, 
					"file:/" + getFile(model).getAbsolutePath());
			properties.put(EmfModel.PROPERTY_IS_METAMODEL_FILE_BASED, "false");
			properties.put(EmfModel.PROPERTY_READONLOAD, readOnLoad + "");
			properties.put(EmfModel.PROPERTY_STOREONDISPOSAL, 
					storeOnDisposal + "");
			emfModel.load(properties, null);
			return emfModel;

		} catch (EolModelLoadingException e) {
			throw new EpsilonWorkflowException("Model loading exception", e);
		} catch (URISyntaxException e) {
			throw new EpsilonWorkflowException("URI exception during model", e);
		}
			}

	static public File getFile(String fileName) throws URISyntaxException 
	{
		URL url = EpsilonUtils.class.getResource(fileName);
		if (url != null)	
			return new File(url.toURI());
		return new File(fileName);
	}

}
