package org.epsilon.tests;


import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

import org.epsilon.tests.workflow.EpsilonWorkflowException;
import org.epsilon.tests.workflow.EpsilonTask;
import org.epsilon.tests.workflow.EpsilonUtils;

public class RunWorkflow {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			//-- Setup package registry to find metamodels by URIs

			//Epsilon ETL Trace metamodel
			EpsilonUtils.registerPkg("metamodels/trace/SimpleTrace.ecore");
			//MyCCM metamodels (load from existing file)
			EpsilonUtils.registerPkg("metamodels/mmSource.ecore");
			EpsilonUtils.registerPkg("metamodels/mmTarget1.ecore");
			EpsilonUtils.registerPkg("metamodels/mmTarget2.ecore");


			//-- Do the model transformation
			EpsilonTask projection = new EpsilonTask("scripts/basicTransform.etl");
			projection.addModel(EpsilonUtils.model_byMMuri(
					"IN",
					"tests/source/production.model",
					"http://org.epsilon.tests/source/1.0.0",
					true, false));
			projection.addModel(EpsilonUtils.model_byMMuri(
					"OUT",
					"tests/target/distribution.model", 
					"http://org.epsilon.tests/target/1/1.0.0"
					+ ",http://org.epsilon.tests/target/2/1.0.0",
					false, true));
			//Optional model => If setup, the traces are recorded
			projection.addModel(EpsilonUtils.model_byMMuri(
					"TRACE",
					"tests/target/trace-from-java.model", 
					"http://org.eclipse.epsilon/m2m/SimpleTrace/1.0.0",
					false, true));

//			projection.addModel(EpsilonUtils.model_byMMfile(
//					"IN",
//					"tests/source/production.model",
//					"metamodels/mmSource.ecore",
//					true, false));
//			projection.addModel(EpsilonUtils.model_byMMfile(
//					"OUT",
//					"tests/target/distribution.model", 
//					"metamodels/mmTarget1.ecore"
//							+ ",metamodels/mmTarget2.ecore",
//							false, true));
//			//Optional model => If setup, the traces are recorded
//			projection.addModel(EpsilonUtils.model_byMMfile(
//					"TRACE",
//					"tests/target/sales-trace.model", 
//					"metamodels/trace/SimpleTrace.ecore",
//					false, true));

			//Run the epsilon task
			projection.execute();

		} catch (EpsilonWorkflowException e) {
			e.printStackTrace();
		} catch (EolRuntimeException e) {
			e.printStackTrace();
		}

		System.out.println("DONE !!");
	}

}
