package ui.editor.service;

import org.apache.xerces.util.XMLChar;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class NameValidationService extends ValidationService {

    @Override
    public Status validate() {
        final Value<?> value = context(Element.class).property(context(ValueProperty.class));
        final String name = value.text();
        if (isValidContent(name)) {
            return Status.createOkStatus();
        }
        return Status.createErrorStatus(getErrorMessage(name));
    }

    public boolean isValidContent(final String name) {
        return XMLChar.isValidName(name == null ? "" : name);
    }

    public String getErrorMessage(final String name) {
        return String.format("\"%s\" is not a valid value for the type \"Name\".", name);
    }
}
