package ui.editor.service;

import org.apache.xerces.util.XMLChar;

public class NCNameValidationService extends NameValidationService {

    public boolean isValidContent(final String name) {
        return XMLChar.isValidNCName(name == null ? "" : name);
    }

    @Override
    public String getErrorMessage(String name) {
        return String.format("\"%s\" is not a valid value for the type \"NCName\".", name);
    }
}