package ui.editor.service;

import java.util.List;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.services.DependenciesService;

public class IDValidationService extends NCNameValidationService {

    @Override
    public String getErrorMessage(String id) {
        return String.format("\"%s\" is either not a valid value for the type \"ID\" or appears multiple times.", id);
    }

    @Override
    public boolean isValidContent(String name) {
        if (!super.isValidContent(name)) {
            return false;
        }

        Value<?> value = context(Element.class).property(context(ValueProperty.class));
        List<DependenciesService> services = value.services(DependenciesService.class);
        for (DependenciesService dependenciesService : services) {
            for (ModelPath path : dependenciesService.dependencies()) {

                for (Property property : value.root().properties(path)) {
                    if (!(property instanceof Value<?>)) {
                        continue;
                    }
                    Value<?> otherValue = (Value<?>) property;
                    if (otherValue.equals(value)) {
                        continue;
                    }
                    if (otherValue.text().equals(value.text())) {
                        return false;
                    }
                }
            }
        }

        return true;
    }
}
