package ui.editor;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;


//@GenerateImpl
//@XmlNamespace(uri = "http://www.example.org/TestSystem")
//@XmlSchema(namespace = "http://www.example.org/TestSystem", location = "http://www.example.org/TestSystem/1.0")
@XmlBinding(path = "root")
public interface Root extends Element {

    ElementType TYPE = new ElementType(Root.class);

    // *** Item ***
    @Type(base = Item.class)
    @Label(standard = "items")
    @CountConstraint(min = 1)
    @XmlListBinding(mappings = @XmlListBinding.Mapping(element = "item", type = Item.class))
    ListProperty PROP_ITEMS = new ListProperty(TYPE, "Items");

    ElementList<Item> getItems();
}
